/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.equipment.toolbox;

import com.mojang.serialization.MapCodec;
import com.zurrtum.create.AllMountedStorageTypes;
import com.zurrtum.create.api.contraption.storage.item.MountedItemStorageType;
import com.zurrtum.create.api.contraption.storage.item.WrapperMountedItemStorage;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.equipment.toolbox.ToolboxBlockEntity;
import com.zurrtum.create.content.equipment.toolbox.ToolboxInventory;
import com.zurrtum.create.foundation.item.ItemHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.Nullable;

public class ToolboxMountedStorage
extends WrapperMountedItemStorage<ToolboxInventory> {
    public static final MapCodec<ToolboxMountedStorage> CODEC = ToolboxInventory.CODEC.xmap(ToolboxMountedStorage::new, storage -> (ToolboxInventory)storage.wrapped).fieldOf("value");

    protected ToolboxMountedStorage(MountedItemStorageType<?> type, ToolboxInventory wrapped) {
        super(type, wrapped);
    }

    protected ToolboxMountedStorage(ToolboxInventory wrapped) {
        this((MountedItemStorageType<?>)AllMountedStorageTypes.TOOLBOX, wrapped);
    }

    @Override
    public void unmount(Level level, BlockState state, BlockPos pos, @Nullable BlockEntity be) {
        if (be instanceof ToolboxBlockEntity) {
            ToolboxBlockEntity toolbox = (ToolboxBlockEntity)be;
            ItemHelper.copyContents(this, toolbox.inventory);
        }
    }

    @Override
    public boolean handleInteraction(ServerPlayer player, Contraption contraption, StructureTemplate.StructureBlockInfo info) {
        return false;
    }

    public static ToolboxMountedStorage fromToolbox(ToolboxBlockEntity toolbox) {
        ToolboxInventory copy = new ToolboxInventory(null);
        ItemHelper.copyContents(toolbox.inventory, copy);
        NonNullList<ItemStack> from = toolbox.inventory.filters;
        NonNullList<ItemStack> to = copy.filters;
        int size = from.size();
        for (int i = 0; i < size; ++i) {
            to.set(i, ((ItemStack)from.get(i)).copy());
        }
        return new ToolboxMountedStorage(copy);
    }
}

