/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.equipment.wrench;

import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.catnip.math.VoxelShaper;
import com.zurrtum.create.content.kinetics.base.DirectionalAxisKineticBlock;
import com.zurrtum.create.content.kinetics.base.DirectionalKineticBlock;
import com.zurrtum.create.content.kinetics.base.HorizontalAxisKineticBlock;
import com.zurrtum.create.content.kinetics.base.HorizontalKineticBlock;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.base.RotatedPillarKineticBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public interface IWrenchable {
    public static void playRemoveSound(Level level, BlockPos pos) {
        AllSoundEvents.WRENCH_REMOVE.playOnServer(level, (Vec3i)pos, 1.0f, level.random.nextFloat() * 0.5f + 0.5f);
    }

    public static void playRotateSound(Level level, BlockPos pos) {
        AllSoundEvents.WRENCH_ROTATE.playOnServer(level, (Vec3i)pos, 1.0f, level.random.nextFloat() + 0.5f);
    }

    default public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState rotated = this.getRotatedBlockState(state, context.getClickedFace());
        if (!rotated.canSurvive((LevelReader)level, context.getClickedPos())) {
            return InteractionResult.PASS;
        }
        KineticBlockEntity.switchToBlockState(level, pos, this.updateAfterWrenched(rotated, context));
        if (level.getBlockState(pos) != state) {
            IWrenchable.playRotateSound(level, pos);
        }
        return InteractionResult.SUCCESS;
    }

    default public BlockState updateAfterWrenched(BlockState newState, UseOnContext context) {
        return Block.updateFromNeighbourShapes((BlockState)newState, (LevelAccessor)context.getLevel(), (BlockPos)context.getClickedPos());
    }

    default public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        if (!(world instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ServerLevel serverLevel = (ServerLevel)world;
        BlockEntity be = world.getBlockEntity(pos);
        if (player != null && !player.isCreative()) {
            Block.getDrops((BlockState)state, (ServerLevel)serverLevel, (BlockPos)pos, (BlockEntity)world.getBlockEntity(pos), (Entity)player, (ItemStack)context.getItemInHand()).forEach(itemStack -> player.getInventory().placeItemBackInInventory(itemStack));
        }
        state.spawnAfterBreak(serverLevel, pos, ItemStack.EMPTY, true);
        world.destroyBlock(pos, false);
        IWrenchable.playRemoveSound(world, pos);
        return InteractionResult.SUCCESS;
    }

    default public BlockState getRotatedBlockState(BlockState originalState, Direction targetedFace) {
        BlockState newState = originalState;
        if (targetedFace.getAxis() == Direction.Axis.Y) {
            if (originalState.hasProperty(HorizontalAxisKineticBlock.HORIZONTAL_AXIS)) {
                return (BlockState)originalState.setValue(HorizontalAxisKineticBlock.HORIZONTAL_AXIS, (Comparable)VoxelShaper.axisAsFace((Direction.Axis)originalState.getValue(HorizontalAxisKineticBlock.HORIZONTAL_AXIS)).getClockWise(targetedFace.getAxis()).getAxis());
            }
            if (originalState.hasProperty(HorizontalKineticBlock.HORIZONTAL_FACING)) {
                return (BlockState)originalState.setValue(HorizontalKineticBlock.HORIZONTAL_FACING, (Comparable)((Direction)originalState.getValue(HorizontalKineticBlock.HORIZONTAL_FACING)).getClockWise(targetedFace.getAxis()));
            }
        }
        if (originalState.hasProperty(RotatedPillarKineticBlock.AXIS)) {
            return (BlockState)originalState.setValue(RotatedPillarKineticBlock.AXIS, (Comparable)VoxelShaper.axisAsFace((Direction.Axis)originalState.getValue(RotatedPillarKineticBlock.AXIS)).getClockWise(targetedFace.getAxis()).getAxis());
        }
        if (!originalState.hasProperty(DirectionalKineticBlock.FACING)) {
            return originalState;
        }
        Direction stateFacing = (Direction)originalState.getValue(DirectionalKineticBlock.FACING);
        if (stateFacing.getAxis().equals((Object)targetedFace.getAxis())) {
            if (originalState.hasProperty((Property)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE)) {
                return (BlockState)originalState.cycle((Property)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE);
            }
            return originalState;
        }
        do {
            newState = (BlockState)newState.setValue(DirectionalKineticBlock.FACING, (Comparable)((Direction)newState.getValue(DirectionalKineticBlock.FACING)).getClockWise(targetedFace.getAxis()));
            if (targetedFace.getAxis() != Direction.Axis.Y || !newState.hasProperty((Property)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE)) continue;
            newState = (BlockState)newState.cycle((Property)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE);
        } while (((Direction)newState.getValue(DirectionalKineticBlock.FACING)).getAxis().equals((Object)targetedFace.getAxis()));
        return newState;
    }
}

