/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.equipment.wrench;

import com.zurrtum.create.AllBlockTags;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class WrenchItem
extends Item {
    public WrenchItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        if (player == null || !player.mayBuild()) {
            return super.useOn(context);
        }
        BlockState state = context.getLevel().getBlockState(context.getClickedPos());
        Block block = state.getBlock();
        if (!(block instanceof IWrenchable)) {
            if (player.isShiftKeyDown() && this.canWrenchPickup(state)) {
                return this.onItemUseOnOther(context);
            }
            return super.useOn(context);
        }
        IWrenchable actor = (IWrenchable)block;
        if (player.isShiftKeyDown()) {
            return actor.onSneakWrenched(state, context);
        }
        return actor.onWrenched(state, context);
    }

    private boolean canWrenchPickup(BlockState state) {
        return state.is(AllBlockTags.WRENCH_PICKUP);
    }

    private InteractionResult onItemUseOnOther(UseOnContext context) {
        Player player = context.getPlayer();
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = world.getBlockState(pos);
        if (!(world instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ServerLevel serverWorld = (ServerLevel)world;
        if (player != null && !player.isCreative()) {
            Block.getDrops((BlockState)state, (ServerLevel)serverWorld, (BlockPos)pos, (BlockEntity)world.getBlockEntity(pos), (Entity)player, (ItemStack)context.getItemInHand()).forEach(itemStack -> player.getInventory().placeItemBackInInventory(itemStack));
        }
        state.spawnAfterBreak(serverWorld, pos, ItemStack.EMPTY, true);
        world.destroyBlock(pos, false);
        AllSoundEvents.WRENCH_REMOVE.playOnServer(world, (Vec3i)pos, 1.0f, world.random.nextFloat() * 0.5f + 0.5f);
        return InteractionResult.SUCCESS;
    }

    public static boolean wrenchInstaKillsMinecarts(ServerPlayer player, Entity target) {
        if (!(target instanceof AbstractMinecart)) {
            return false;
        }
        AbstractMinecart minecart = (AbstractMinecart)target;
        ItemStack heldItem = player.getMainHandItem();
        if (!heldItem.is((Item)AllItems.WRENCH)) {
            return false;
        }
        if (player.isCreative()) {
            return false;
        }
        minecart.hurtServer(player.level(), minecart.damageSources().playerAttack((Player)player), 100.0f);
        return true;
    }
}

