/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.fluids;

import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.catnip.math.BlockFace;
import com.zurrtum.create.content.contraptions.actors.psi.PortableFluidInterfaceBlockEntity;
import com.zurrtum.create.content.fluids.FlowSource;
import com.zurrtum.create.content.fluids.FluidTransportBehaviour;
import com.zurrtum.create.content.fluids.PipeConnection;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.infrastructure.fluids.FluidInventory;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class FluidNetwork {
    private static final int CYCLES_PER_TICK = 16;
    Level world;
    BlockFace start;
    Supplier<FluidInventory> sourceSupplier;
    @Nullable
    FluidInventory source = null;
    int transferSpeed;
    int pauseBeforePropagation;
    List<BlockFace> queued;
    Set<Pair<BlockFace, PipeConnection>> frontier;
    Set<BlockPos> visited;
    FluidStack fluid;
    List<Pair<BlockFace, FlowSource>> targets;
    Map<BlockPos, WeakReference<FluidTransportBehaviour>> cache;

    public FluidNetwork(Level world, BlockFace location, Supplier<FluidInventory> sourceSupplier) {
        this.world = world;
        this.start = location;
        this.sourceSupplier = sourceSupplier;
        this.fluid = FluidStack.EMPTY;
        this.frontier = new HashSet<Pair<BlockFace, PipeConnection>>();
        this.visited = new HashSet<BlockPos>();
        this.targets = new ArrayList<Pair<BlockFace, FlowSource>>();
        this.cache = new HashMap<BlockPos, WeakReference<FluidTransportBehaviour>>();
        this.queued = new ArrayList<BlockFace>();
        this.reset();
    }

    public void tick() {
        if (this.pauseBeforePropagation > 0) {
            --this.pauseBeforePropagation;
            return;
        }
        for (int cycle = 0; cycle < 16; ++cycle) {
            boolean shouldContinue = false;
            Iterator<Pair> iterator = this.queued.iterator();
            while (iterator.hasNext()) {
                BlockFace blockFace = iterator.next();
                if (!this.isPresent(blockFace)) continue;
                PipeConnection pipeConnection = this.get(blockFace);
                if (pipeConnection != null) {
                    if (blockFace.equals(this.start)) {
                        this.transferSpeed = (int)Math.max(1.0f, pipeConnection.pressure.get(true).floatValue() / 2.0f) * 81;
                    }
                    this.frontier.add(Pair.of(blockFace, pipeConnection));
                }
                iterator.remove();
            }
            iterator = this.frontier.iterator();
            while (iterator.hasNext()) {
                Pair pair = iterator.next();
                BlockFace blockFace = (BlockFace)pair.getFirst();
                PipeConnection pipeConnection = (PipeConnection)pair.getSecond();
                if (!pipeConnection.hasFlow()) continue;
                PipeConnection.Flow flow = pipeConnection.flow.get();
                if (!this.fluid.isEmpty() && !FluidStack.areFluidsAndComponentsEqualIgnoreCapacity(flow.fluid, this.fluid)) {
                    iterator.remove();
                    continue;
                }
                if (!flow.inbound) {
                    if (!(pipeConnection.comparePressure() >= 0.0f)) continue;
                    iterator.remove();
                    continue;
                }
                if (!flow.complete) continue;
                if (this.fluid.isEmpty()) {
                    this.fluid = flow.fluid;
                }
                boolean canRemove = true;
                for (Direction side : Iterate.directions) {
                    BlockFace adjacentLocation;
                    PipeConnection adjacent;
                    if (side == blockFace.getFace() || (adjacent = this.get(adjacentLocation = new BlockFace(blockFace.getPos(), side))) == null) continue;
                    if (!adjacent.hasFlow()) {
                        if (!adjacent.hasPressure() || !(((Float)adjacent.pressure.getSecond()).floatValue() > 0.0f)) continue;
                        canRemove = false;
                        continue;
                    }
                    PipeConnection.Flow outFlow = adjacent.flow.get();
                    if (outFlow.inbound) {
                        if (!(adjacent.comparePressure() > 0.0f)) continue;
                        canRemove = false;
                        continue;
                    }
                    if (!outFlow.complete) {
                        canRemove = false;
                        continue;
                    }
                    if (!adjacent.source.isPresent() && !adjacent.determineSource(this.world, blockFace.getPos())) {
                        canRemove = false;
                        continue;
                    }
                    if (adjacent.source.isPresent() && adjacent.source.get().isEndpoint()) {
                        this.targets.add(Pair.of(adjacentLocation, adjacent.source.get()));
                        continue;
                    }
                    if (!this.visited.add(adjacentLocation.getConnectedPos())) continue;
                    this.queued.add(adjacentLocation.getOpposite());
                    shouldContinue = true;
                }
                if (!canRemove) continue;
                iterator.remove();
            }
            if (!shouldContinue) break;
        }
        if (this.source == null) {
            this.source = this.sourceSupplier.get();
        }
        if (this.source == null) {
            return;
        }
        this.keepPortableFluidInterfaceEngaged();
        if (this.targets.isEmpty()) {
            return;
        }
        for (Pair<BlockFace, FlowSource> pair : this.targets) {
            PipeConnection pipeConnection;
            if (pair.getSecond() != null && this.world.getGameTime() % 40L != 0L || (pipeConnection = this.get(pair.getFirst())) == null) continue;
            pipeConnection.source.ifPresent(fs -> {
                if (fs.isEndpoint()) {
                    pair.setSecond((FlowSource)fs);
                }
            });
        }
        int amount = this.source.count(this.fluid, this.transferSpeed, this.start.getFace().getOpposite());
        if (amount == 0) {
            return;
        }
        int transferredAmount = amount;
        ArrayList<Pair<BlockFace, FlowSource>> availableOutputs = new ArrayList<Pair<BlockFace, FlowSource>>(this.targets);
        while (!availableOutputs.isEmpty() && amount > 0) {
            int dividedTransfer = amount / availableOutputs.size();
            int remainder = amount % availableOutputs.size();
            Iterator iterator = availableOutputs.iterator();
            while (amount > 0 && iterator.hasNext()) {
                FluidInventory targetHandlerProvider;
                Pair pair = (Pair)iterator.next();
                int toTransfer = dividedTransfer;
                if (remainder > 0) {
                    ++toTransfer;
                    --remainder;
                }
                if ((targetHandlerProvider = ((FlowSource)pair.getSecond()).provideHandler()) == null) {
                    iterator.remove();
                    continue;
                }
                int fill = targetHandlerProvider.insert(this.fluid, toTransfer, ((BlockFace)pair.getFirst()).getFace().getOpposite());
                if (fill == toTransfer) {
                    amount -= fill;
                    continue;
                }
                iterator.remove();
                if (fill == 0) continue;
                amount -= fill;
            }
        }
        if (transferredAmount != amount) {
            this.source.extract(this.fluid, transferredAmount - amount, this.start.getFace().getOpposite());
        }
    }

    private void keepPortableFluidInterfaceEngaged() {
        if (!(this.source instanceof PortableFluidInterfaceBlockEntity.InterfaceFluidHandler)) {
            return;
        }
        if (this.frontier.isEmpty()) {
            return;
        }
        this.source.markDirty();
    }

    public void reset() {
        this.frontier.clear();
        this.visited.clear();
        this.targets.clear();
        this.queued.clear();
        this.fluid = FluidStack.EMPTY;
        this.queued.add(this.start);
        this.pauseBeforePropagation = 2;
    }

    @Nullable
    private PipeConnection get(BlockFace location) {
        BlockPos pos = location.getPos();
        FluidTransportBehaviour fluidTransfer = this.getFluidTransfer(pos);
        if (fluidTransfer == null) {
            return null;
        }
        return fluidTransfer.getConnection(location.getFace());
    }

    private boolean isPresent(BlockFace location) {
        return this.world.isLoaded(location.getPos());
    }

    @Nullable
    private FluidTransportBehaviour getFluidTransfer(BlockPos pos) {
        FluidTransportBehaviour behaviour;
        WeakReference<FluidTransportBehaviour> weakReference = this.cache.get(pos);
        FluidTransportBehaviour fluidTransportBehaviour = behaviour = weakReference != null ? (FluidTransportBehaviour)weakReference.get() : null;
        if (behaviour != null && behaviour.blockEntity.isRemoved()) {
            behaviour = null;
        }
        if (behaviour == null && (behaviour = BlockEntityBehaviour.get((BlockGetter)this.world, pos, FluidTransportBehaviour.TYPE)) != null) {
            this.cache.put(pos, new WeakReference<FluidTransportBehaviour>(behaviour));
        }
        return behaviour;
    }
}

