/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.fluids;

import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.BlockFace;
import com.zurrtum.create.content.fluids.FlowSource;
import com.zurrtum.create.content.fluids.FluidNetwork;
import com.zurrtum.create.content.fluids.FluidPropagator;
import com.zurrtum.create.content.fluids.FluidTransportBehaviour;
import com.zurrtum.create.content.fluids.OpenEndedPipe;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class PipeConnection {
    public Direction side;
    Couple<Float> pressure;
    Optional<FlowSource> source;
    Optional<FlowSource> previousSource;
    Optional<Flow> flow;
    boolean particleSplashNextTick;
    Optional<FluidNetwork> network;
    public static final int MAX_PARTICLE_RENDER_DISTANCE = 20;
    public static final int SPLASH_PARTICLE_AMOUNT = 1;
    public static final float IDLE_PARTICLE_SPAWN_CHANCE = 0.001f;
    public static final float RIM_RADIUS = 0.265625f;

    public PipeConnection(Direction side) {
        this.side = side;
        this.pressure = Couple.create(() -> Float.valueOf(0.0f));
        this.flow = Optional.empty();
        this.previousSource = Optional.empty();
        this.source = Optional.empty();
        this.network = Optional.empty();
        this.particleSplashNextTick = false;
    }

    public FluidStack getProvidedFluid() {
        FluidStack empty = FluidStack.EMPTY;
        if (!this.hasFlow()) {
            return empty;
        }
        Flow flow = this.flow.get();
        if (!flow.inbound) {
            return empty;
        }
        if (!flow.complete) {
            return empty;
        }
        return flow.fluid;
    }

    public boolean flipFlowsIfPressureReversed() {
        if (!this.hasFlow()) {
            return false;
        }
        boolean singlePressure = this.comparePressure() != 0.0f && (this.getInboundPressure() == 0.0f || this.getOutwardPressure() == 0.0f);
        Flow flow = this.flow.get();
        if (!singlePressure || this.comparePressure() < 0.0f == flow.inbound) {
            return false;
        }
        boolean bl = flow.inbound = !flow.inbound;
        if (!flow.complete) {
            this.flow = Optional.empty();
        }
        return true;
    }

    public void manageSource(Level world, BlockPos pos, BlockEntity blockEntity) {
        if (!this.source.isPresent() && !this.determineSource(world, pos)) {
            return;
        }
        FlowSource flowSource = this.source.get();
        flowSource.manageSource(world, blockEntity);
    }

    public boolean manageFlows(Level world, BlockPos pos, FluidStack internalFluid, Predicate<FluidStack> extractionPredicate) {
        FluidStack provided;
        Optional<FluidNetwork> retainedNetwork = this.network;
        this.network = Optional.empty();
        if (!this.source.isPresent() && !this.determineSource(world, pos)) {
            return false;
        }
        FlowSource flowSource = this.source.get();
        if (!this.hasFlow()) {
            if (!this.hasPressure()) {
                return false;
            }
            boolean prioritizeInbound = this.comparePressure() < 0.0f;
            for (boolean trueFalse : Iterate.trueAndFalse) {
                boolean inbound;
                boolean bl = inbound = prioritizeInbound == trueFalse;
                if (this.pressure.get(inbound).floatValue() == 0.0f || !this.tryStartingNewFlow(inbound, inbound ? flowSource.provideFluid(extractionPredicate) : internalFluid)) continue;
                return true;
            }
            return false;
        }
        Flow flow = this.flow.get();
        FluidStack fluidStack = provided = flow.inbound ? flowSource.provideFluid(extractionPredicate) : internalFluid;
        if (!this.hasPressure() || provided.isEmpty() || !FluidStack.areFluidsAndComponentsEqualIgnoreCapacity(provided, flow.fluid)) {
            this.flow = Optional.empty();
            return true;
        }
        if (flow.inbound != this.comparePressure() < 0.0f) {
            boolean inbound;
            boolean bl = inbound = !flow.inbound;
            if (inbound && !provided.isEmpty() || !inbound && !internalFluid.isEmpty()) {
                FluidPropagator.resetAffectedFluidNetworks(world, pos, this.side);
                this.tryStartingNewFlow(inbound, inbound ? flowSource.provideFluid(extractionPredicate) : internalFluid);
                return true;
            }
        }
        flowSource.whileFlowPresent(world, flow.inbound);
        if (!flowSource.isEndpoint()) {
            return false;
        }
        if (!flow.inbound) {
            return false;
        }
        this.network = retainedNetwork;
        if (!this.hasNetwork()) {
            this.network = Optional.of(new FluidNetwork(world, new BlockFace(pos, this.side), flowSource::provideHandler));
        }
        this.network.get().tick();
        return false;
    }

    private boolean tryStartingNewFlow(boolean inbound, FluidStack providedFluid) {
        if (providedFluid.isEmpty()) {
            return false;
        }
        Flow flow = new Flow(this, inbound, providedFluid);
        this.flow = Optional.of(flow);
        return true;
    }

    public boolean determineSource(Level world, BlockPos pos) {
        BlockPos relative = pos.relative(this.side);
        if (world.getChunk(relative.getX() >> 4, relative.getZ() >> 4, ChunkStatus.FULL, false) == null) {
            return false;
        }
        BlockFace location = new BlockFace(pos, this.side);
        if (FluidPropagator.isOpenEnd((BlockGetter)world, pos, this.side)) {
            this.source = this.previousSource.orElse(null) instanceof OpenEndedPipe ? this.previousSource : Optional.of(new OpenEndedPipe(location));
            return true;
        }
        if (FluidPropagator.hasFluidCapability((BlockGetter)world, location.getConnectedPos(), this.side.getOpposite())) {
            this.source = Optional.of(new FlowSource.FluidHandler(location));
            return true;
        }
        FluidTransportBehaviour behaviour = BlockEntityBehaviour.get((BlockGetter)world, relative, FluidTransportBehaviour.TYPE);
        this.source = Optional.of(behaviour == null ? new FlowSource.Blocked(location) : new FlowSource.OtherPipe(location));
        return true;
    }

    public void tickFlowProgress(Level world, BlockPos pos) {
        if (!this.hasFlow()) {
            return;
        }
        Flow flow = this.flow.get();
        if (flow.fluid.isEmpty()) {
            return;
        }
        if (world.isClientSide()) {
            if (!this.source.isPresent()) {
                this.determineSource(world, pos);
            }
            boolean openEnd = this.hasOpenEnd();
            int amount = 1;
            if (this.particleSplashNextTick) {
                ++amount;
            }
            AllClientHandle.INSTANCE.spawnPipeParticles(world, pos, flow, openEnd, this.side, amount);
            this.particleSplashNextTick = false;
        }
        float flowSpeed = 0.03125f + Mth.clamp((float)(this.pressure.get(flow.inbound).floatValue() / 128.0f), (float)0.0f, (float)1.0f) * 31.0f / 32.0f;
        flow.progress.setValue(Math.min(flow.progress.getValue() + flowSpeed, 1.0f));
        if (flow.progress.getValue() >= 1.0f) {
            flow.complete = true;
        }
    }

    public void write(ValueOutput view, BlockPos blockEntityPos, boolean clientPacket) {
        Object var5_4;
        if (this.hasPressure()) {
            view.store("Pressure", CreateCodecs.FLOAT_LIST_CODEC, List.of(Float.valueOf(this.getInboundPressure()), Float.valueOf(this.getOutwardPressure())));
        }
        if ((var5_4 = this.source.orElse(null)) instanceof OpenEndedPipe) {
            OpenEndedPipe openEndedPipe = var5_4;
            view.store("OpenEnd", OpenEndedPipe.codec(blockEntityPos), (Object)openEndedPipe);
        }
        this.flow.ifPresent(flow -> {
            ValueOutput flowData = view.child("Flow");
            if (!flow.fluid.isEmpty()) {
                flowData.store("Fluid", FluidStack.CODEC, (Object)flow.fluid);
            }
            flowData.putBoolean("In", flow.inbound);
            if (!flow.complete) {
                flow.progress.write(flowData.child("Progress"));
            }
        });
    }

    private boolean hasOpenEnd() {
        return this.source.orElse(null) instanceof OpenEndedPipe;
    }

    public void read(ValueInput view, BlockPos blockEntityPos, boolean clientPacket) {
        view.read("Pressure", CreateCodecs.FLOAT_LIST_CODEC).ifPresentOrElse(list -> {
            this.pressure = Couple.create((Float)list.getFirst(), (Float)list.getLast());
        }, () -> this.pressure.replace(f -> Float.valueOf(0.0f)));
        this.source = Optional.ofNullable(view.read("OpenEnd", OpenEndedPipe.codec(blockEntityPos)).orElse(null));
        view.child("Flow").ifPresentOrElse(flowData -> {
            Flow flow;
            boolean inbound = flowData.getBooleanOr("In", false);
            FluidStack fluid = flowData.read("Fluid", FluidStack.CODEC).orElse(FluidStack.EMPTY);
            if (this.flow.isEmpty()) {
                flow = new Flow(this, inbound, fluid);
                this.flow = Optional.of(flow);
                if (clientPacket) {
                    this.particleSplashNextTick = true;
                }
            } else {
                flow = this.flow.get();
                flow.fluid = fluid;
                flow.inbound = inbound;
            }
            flowData.child("Progress").ifPresentOrElse(progress -> {
                flow.complete = false;
                flow.progress.read((ValueInput)progress, clientPacket);
            }, () -> {
                flow.complete = true;
                if (flow.progress.getValue() == 0.0f) {
                    flow.progress.startWithValue(1.0);
                }
                flow.progress.setValue(1.0);
            });
        }, () -> {
            this.flow = Optional.empty();
        });
    }

    public float comparePressure() {
        return this.getOutwardPressure() - this.getInboundPressure();
    }

    public void wipePressure() {
        this.pressure.replace(f -> Float.valueOf(0.0f));
        if (this.source.isPresent()) {
            this.previousSource = this.source;
        }
        this.source = Optional.empty();
        this.resetNetwork();
    }

    public FluidStack provideOutboundFlow() {
        if (!this.hasFlow()) {
            return FluidStack.EMPTY;
        }
        Flow flow = this.flow.get();
        if (!flow.complete || flow.inbound) {
            return FluidStack.EMPTY;
        }
        return flow.fluid;
    }

    public void addPressure(boolean inbound, float pressure) {
        this.pressure = this.pressure.mapWithContext((f, in) -> Float.valueOf(in == inbound ? f.floatValue() + pressure : f.floatValue()));
    }

    public Couple<Float> getPressure() {
        return this.pressure;
    }

    public boolean hasPressure() {
        return this.getInboundPressure() != 0.0f || this.getOutwardPressure() != 0.0f;
    }

    private float getOutwardPressure() {
        return ((Float)this.pressure.getSecond()).floatValue();
    }

    private float getInboundPressure() {
        return ((Float)this.pressure.getFirst()).floatValue();
    }

    public boolean hasFlow() {
        return this.flow.isPresent();
    }

    public boolean hasNetwork() {
        return this.network.isPresent();
    }

    public void resetNetwork() {
        this.network.ifPresent(FluidNetwork::reset);
    }

    public class Flow {
        public boolean complete;
        public boolean inbound;
        public LerpedFloat progress;
        public FluidStack fluid;

        public Flow(PipeConnection this$0, boolean inbound, FluidStack fluid) {
            this.inbound = inbound;
            this.fluid = fluid;
            this.progress = LerpedFloat.linear().startWithValue(0.0);
            this.complete = false;
        }
    }
}

