/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.fluids.drain;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.fluids.drain.ItemDrainItemHandler;
import com.zurrtum.create.content.fluids.transfer.GenericItemEmptying;
import com.zurrtum.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.zurrtum.create.content.kinetics.belt.transport.TransportedItemStack;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.zurrtum.create.foundation.utility.BlockHelper;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.Nullable;

public class ItemDrainBlockEntity
extends SmartBlockEntity {
    public static final int FILLING_TIME = 20;
    public SmartFluidTankBehaviour internalTank;
    public TransportedItemStack heldItem;
    public int processingTicks;
    public Map<Direction, ItemDrainItemHandler> itemHandlers = new IdentityHashMap<Direction, ItemDrainItemHandler>();

    public ItemDrainBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.ITEM_DRAIN, pos, state);
        for (Direction d : Iterate.horizontalDirections) {
            this.itemHandlers.put(d, new ItemDrainItemHandler(this, d));
        }
    }

    @Override
    public void preRemoveSideEffects(BlockPos pos, BlockState oldState) {
        super.preRemoveSideEffects(pos, oldState);
        ItemStack heldItemStack = this.getHeldItemStack();
        if (!heldItemStack.isEmpty()) {
            Containers.dropItemStack((Level)this.level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)heldItemStack);
        }
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        behaviours.add(new DirectBeltInputBehaviour(this).allowingBeltFunnels().setInsertionHandler(this::tryInsertingFromSide));
        this.internalTank = SmartFluidTankBehaviour.single(this, 121500, (TriFunction<SmartFluidTankBehaviour, Boolean, Optional<Integer>, SmartFluidTankBehaviour.InternalFluidHandler>)((TriFunction)ItemDrainFluidHandler::new)).allowExtraction().forbidInsertion();
        behaviours.add(this.internalTank);
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.DRAIN, AllAdvancements.CHAINED_DRAIN);
    }

    private ItemStack tryInsertingFromSide(TransportedItemStack transportedStack, Direction side, boolean simulate) {
        ItemStack inserted = transportedStack.stack;
        ItemStack returned = ItemStack.EMPTY;
        if (!this.getHeldItemStack().isEmpty()) {
            return inserted;
        }
        if (inserted.getCount() > 1 && GenericItemEmptying.canItemBeEmptied(this.level, inserted)) {
            returned = inserted.copyWithCount(inserted.getCount() - 1);
            inserted = inserted.copyWithCount(1);
        }
        if (simulate) {
            return returned;
        }
        transportedStack = transportedStack.copy();
        transportedStack.stack = inserted.copy();
        transportedStack.beltPosition = side.getAxis().isVertical() ? 0.5f : 0.0f;
        transportedStack.prevSideOffset = transportedStack.sideOffset;
        transportedStack.prevBeltPosition = transportedStack.beltPosition;
        this.setHeldItem(transportedStack, side);
        this.setChanged();
        this.sendData();
        return returned;
    }

    public ItemStack getHeldItemStack() {
        return this.heldItem == null ? ItemStack.EMPTY : this.heldItem.stack;
    }

    @Override
    public void tick() {
        boolean onClient;
        super.tick();
        if (this.heldItem == null) {
            this.processingTicks = 0;
            return;
        }
        boolean bl = onClient = this.level.isClientSide() && !this.isVirtual();
        if (this.processingTicks > 0) {
            boolean wasAtBeginning;
            this.heldItem.prevBeltPosition = 0.5f;
            boolean bl2 = wasAtBeginning = this.processingTicks == 20;
            if (!onClient || this.processingTicks < 20) {
                --this.processingTicks;
            }
            if (!this.continueProcessing()) {
                this.processingTicks = 0;
                this.notifyUpdate();
                return;
            }
            if (wasAtBeginning != (this.processingTicks == 20)) {
                this.sendData();
            }
            return;
        }
        this.heldItem.prevBeltPosition = this.heldItem.beltPosition;
        this.heldItem.prevSideOffset = this.heldItem.sideOffset;
        this.heldItem.beltPosition += this.itemMovementPerTick();
        if (this.heldItem.beltPosition > 1.0f) {
            BlockPos nextPosition;
            DirectBeltInputBehaviour directBeltInputBehaviour;
            this.heldItem.beltPosition = 1.0f;
            if (onClient) {
                return;
            }
            Direction side = this.heldItem.insertedFrom;
            ItemStack tryExportingToBeltFunnel = this.getBehaviour(DirectBeltInputBehaviour.TYPE).tryExportingToBeltFunnel(this.heldItem.stack, side.getOpposite(), false);
            if (tryExportingToBeltFunnel != null) {
                if (tryExportingToBeltFunnel.getCount() != this.heldItem.stack.getCount()) {
                    if (tryExportingToBeltFunnel.isEmpty()) {
                        this.heldItem = null;
                    } else {
                        this.heldItem.stack = tryExportingToBeltFunnel;
                    }
                    this.notifyUpdate();
                    return;
                }
                if (!tryExportingToBeltFunnel.isEmpty()) {
                    return;
                }
            }
            if ((directBeltInputBehaviour = BlockEntityBehaviour.get((BlockGetter)this.level, nextPosition = this.worldPosition.relative(side), DirectBeltInputBehaviour.TYPE)) == null) {
                if (!BlockHelper.hasBlockSolidSide(this.level.getBlockState(nextPosition), (BlockGetter)this.level, nextPosition, side.getOpposite())) {
                    ItemStack ejected = this.heldItem.stack;
                    Vec3 outPos = VecHelper.getCenterOf((Vec3i)this.worldPosition).add(Vec3.atLowerCornerOf((Vec3i)side.getUnitVec3i()).scale(0.75));
                    float movementSpeed = this.itemMovementPerTick();
                    Vec3 outMotion = Vec3.atLowerCornerOf((Vec3i)side.getUnitVec3i()).scale((double)movementSpeed).add(0.0, 0.125, 0.0);
                    outPos.add(outMotion.normalize());
                    ItemEntity entity = new ItemEntity(this.level, outPos.x, outPos.y + 0.375, outPos.z, ejected);
                    entity.setDeltaMovement(outMotion);
                    entity.setDefaultPickUpDelay();
                    entity.hurtMarked = true;
                    this.level.addFreshEntity((Entity)entity);
                    this.heldItem = null;
                    this.notifyUpdate();
                }
                return;
            }
            if (!directBeltInputBehaviour.canInsertFromSide(side)) {
                return;
            }
            ItemStack returned = directBeltInputBehaviour.handleInsertion(this.heldItem.copy(), side, false);
            if (returned.isEmpty()) {
                if (this.level.getBlockEntity(nextPosition) instanceof ItemDrainBlockEntity) {
                    this.award(AllAdvancements.CHAINED_DRAIN);
                }
                this.heldItem = null;
                this.notifyUpdate();
                return;
            }
            if (returned.getCount() != this.heldItem.stack.getCount()) {
                this.heldItem.stack = returned;
                this.notifyUpdate();
                return;
            }
            return;
        }
        if (this.heldItem.prevBeltPosition < 0.5f && this.heldItem.beltPosition >= 0.5f) {
            if (!GenericItemEmptying.canItemBeEmptied(this.level, this.heldItem.stack)) {
                return;
            }
            this.heldItem.beltPosition = 0.5f;
            if (onClient) {
                return;
            }
            this.processingTicks = 20;
            this.sendData();
        }
    }

    protected boolean continueProcessing() {
        if (this.level.isClientSide() && !this.isVirtual()) {
            return true;
        }
        if (this.processingTicks < 5) {
            return true;
        }
        if (!GenericItemEmptying.canItemBeEmptied(this.level, this.heldItem.stack)) {
            return false;
        }
        Pair<FluidStack, ItemStack> emptyItem = GenericItemEmptying.emptyItem(this.level, this.heldItem.stack, true);
        FluidStack fluidFromItem = emptyItem.getFirst();
        if (this.processingTicks > 5) {
            this.internalTank.allowInsertion();
            int amount = fluidFromItem.getAmount();
            if (this.internalTank.getPrimaryHandler().countSpace(fluidFromItem) != amount) {
                this.internalTank.forbidInsertion();
                this.processingTicks = 20;
                return true;
            }
            this.internalTank.forbidInsertion();
            return true;
        }
        emptyItem = GenericItemEmptying.emptyItem(this.level, this.heldItem.stack.copy(), false);
        this.award(AllAdvancements.DRAIN);
        ItemStack out = emptyItem.getSecond();
        if (!out.isEmpty()) {
            this.heldItem.stack = out;
        } else {
            this.heldItem = null;
        }
        this.internalTank.allowInsertion();
        this.internalTank.getPrimaryHandler().insert(fluidFromItem);
        this.internalTank.forbidInsertion();
        this.notifyUpdate();
        return true;
    }

    private float itemMovementPerTick() {
        return 0.125f;
    }

    public void setHeldItem(TransportedItemStack heldItem, Direction insertedFrom) {
        this.heldItem = heldItem;
        this.heldItem.insertedFrom = insertedFrom;
    }

    @Override
    public void write(ValueOutput view, boolean clientPacket) {
        view.putInt("ProcessingTicks", this.processingTicks);
        if (this.heldItem != null) {
            view.store("HeldItem", TransportedItemStack.CODEC, (Object)this.heldItem);
        }
        super.write(view, clientPacket);
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        this.heldItem = null;
        this.processingTicks = view.getIntOr("ProcessingTicks", 0);
        this.heldItem = view.read("HeldItem", TransportedItemStack.CODEC).orElse(null);
        super.read(view, clientPacket);
    }

    public static class ItemDrainFluidHandler
    extends SmartFluidTankBehaviour.InternalFluidHandler {
        private static final int[] EMPTY_SLOTS = new int[0];

        public ItemDrainFluidHandler(SmartFluidTankBehaviour behaviour, boolean enforceVariety, Optional<Integer> max) {
            super(behaviour, enforceVariety, max);
        }

        @Override
        public int[] getAvailableSlots(@Nullable Direction side) {
            if (side == Direction.UP) {
                return EMPTY_SLOTS;
            }
            return super.getAvailableSlots(side);
        }
    }
}

