/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.fluids.drain;

import com.zurrtum.create.content.fluids.drain.ItemDrainBlockEntity;
import com.zurrtum.create.content.fluids.transfer.GenericItemEmptying;
import com.zurrtum.create.content.kinetics.belt.transport.TransportedItemStack;
import com.zurrtum.create.infrastructure.items.ItemInventory;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;

public class ItemDrainItemHandler
implements ItemInventory {
    private final ItemDrainBlockEntity blockEntity;
    private final Direction side;

    public ItemDrainItemHandler(ItemDrainBlockEntity be, Direction side) {
        this.blockEntity = be;
        this.side = side.getOpposite();
    }

    public int getContainerSize() {
        return 1;
    }

    public int getMaxStackSize(ItemStack stack) {
        if (GenericItemEmptying.canItemBeEmptied(this.blockEntity.getLevel(), stack)) {
            return 1;
        }
        return stack.getMaxStackSize();
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        return this.blockEntity.getHeldItemStack().isEmpty();
    }

    public ItemStack getItem(int slot) {
        if (slot > 1) {
            return ItemStack.EMPTY;
        }
        return this.blockEntity.getHeldItemStack();
    }

    public void setItem(int slot, ItemStack stack) {
        if (slot > 1) {
            return;
        }
        if (stack.isEmpty()) {
            this.blockEntity.heldItem = null;
        } else {
            TransportedItemStack heldItem = new TransportedItemStack(stack);
            heldItem.prevBeltPosition = 0.0f;
            this.blockEntity.setHeldItem(heldItem, this.side);
        }
    }

    @Override
    public void setChanged() {
        this.blockEntity.notifyUpdate();
    }
}

