/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.fluids.pipes;

import com.mojang.serialization.MapCodec;
import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.api.contraption.transformable.TransformableBlock;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.contraptions.StructureTransform;
import com.zurrtum.create.content.decoration.bracket.BracketedBlockEntityBehaviour;
import com.zurrtum.create.content.decoration.encasing.EncasableBlock;
import com.zurrtum.create.content.equipment.wrench.IWrenchableWithBracket;
import com.zurrtum.create.content.fluids.FluidPropagator;
import com.zurrtum.create.content.fluids.FluidTransportBehaviour;
import com.zurrtum.create.content.fluids.pipes.EncasedPipeBlock;
import com.zurrtum.create.content.fluids.pipes.FluidPipeBlockEntity;
import com.zurrtum.create.content.fluids.pipes.FluidPipeBlockRotation;
import com.zurrtum.create.content.fluids.pipes.GlassFluidPipeBlock;
import com.zurrtum.create.content.fluids.pipes.VanillaFluidTargets;
import com.zurrtum.create.foundation.advancement.AdvancementBehaviour;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.block.NeighborUpdateListeningBlock;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.TickPriority;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidPipeBlock
extends PipeBlock
implements SimpleWaterloggedBlock,
IWrenchableWithBracket,
IBE<FluidPipeBlockEntity>,
EncasableBlock,
TransformableBlock,
NeighborUpdateListeningBlock {
    private static final VoxelShape OCCLUSION_BOX = Block.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    public static final MapCodec<FluidPipeBlock> CODEC = FluidPipeBlock.simpleCodec(FluidPipeBlock::new);

    public FluidPipeBlock(BlockBehaviour.Properties properties) {
        super(8.0f, properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        if (this.tryRemoveBracket(context)) {
            return InteractionResult.SUCCESS;
        }
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Direction clickedFace = context.getClickedFace();
        Direction.Axis axis = this.getAxis((BlockGetter)world, pos, state);
        if (axis == null) {
            Vec3 clickLocation = context.getClickLocation().subtract((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
            double closest = 3.4028234663852886E38;
            Direction argClosest = Direction.UP;
            for (Direction direction : Iterate.directions) {
                Vec3 centerOf;
                double distance;
                if (clickedFace.getAxis() == direction.getAxis() || !((distance = (centerOf = Vec3.atCenterOf((Vec3i)direction.getUnitVec3i())).distanceToSqr(clickLocation)) < closest)) continue;
                closest = distance;
                argClosest = direction;
            }
            axis = argClosest.getAxis();
        }
        if (clickedFace.getAxis() == axis) {
            return InteractionResult.PASS;
        }
        if (!world.isClientSide()) {
            this.withBlockEntityDo((BlockGetter)world, pos, fpte -> fpte.getBehaviour(FluidTransportBehaviour.TYPE).interfaces.values().stream().filter(pc -> pc != null && pc.hasFlow()).findAny().ifPresent($ -> AllAdvancements.GLASS_PIPE.trigger((ServerPlayer)context.getPlayer())));
            FluidTransportBehaviour.cacheFlows((LevelAccessor)world, pos);
            world.setBlockAndUpdate(pos, (BlockState)((BlockState)AllBlocks.GLASS_FLUID_PIPE.defaultBlockState().setValue((Property)GlassFluidPipeBlock.AXIS, (Comparable)axis)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED))));
            FluidTransportBehaviour.loadFlows((LevelAccessor)world, pos);
        }
        return InteractionResult.SUCCESS;
    }

    public void setPlacedBy(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        super.setPlacedBy(pLevel, pPos, pState, pPlacer, pStack);
        AdvancementBehaviour.setPlacedBy(pLevel, pPos, pPlacer);
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        InteractionResult result = this.tryEncase(state, level, pos, stack, player, hand, hitResult);
        if (result.consumesAction()) {
            return result;
        }
        return InteractionResult.TRY_WITH_EMPTY_HAND;
    }

    public BlockState getAxisState(Direction.Axis axis) {
        BlockState defaultState = this.defaultBlockState();
        for (Direction d : Iterate.directions) {
            defaultState = (BlockState)defaultState.setValue((Property)PROPERTY_BY_DIRECTION.get(d), (Comparable)Boolean.valueOf(d.getAxis() == axis));
        }
        return defaultState;
    }

    @Nullable
    private Direction.Axis getAxis(BlockGetter world, BlockPos pos, BlockState state) {
        return FluidPropagator.getStraightPipeAxis(state);
    }

    public void affectNeighborsAfterRemoval(BlockState state, ServerLevel world, BlockPos pos, boolean isMoving) {
        if (!world.isClientSide()) {
            FluidPropagator.propagateChangedPipe((LevelAccessor)world, pos, state);
        }
        if (!isMoving) {
            this.removeBracket((BlockGetter)world, pos, true).ifPresent(stack -> Block.popResource((Level)world, (BlockPos)pos, (ItemStack)stack));
        }
        if (state.hasBlockEntity()) {
            world.removeBlockEntity(pos);
        }
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (world.isClientSide()) {
            return;
        }
        if (state != oldState) {
            world.scheduleTick(pos, (Block)this, 1, TickPriority.HIGH);
        }
    }

    @Override
    public void neighborUpdate(BlockState state, Level world, BlockPos pos, Block otherBlock, BlockPos neighborPos, boolean isMoving) {
        Direction d = FluidPropagator.validateNeighbourChange(state, world, pos, otherBlock, neighborPos, isMoving);
        if (d == null) {
            return;
        }
        if (!FluidPipeBlock.isOpenAt(state, d)) {
            return;
        }
        world.scheduleTick(pos, (Block)this, 1, TickPriority.HIGH);
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block otherBlock, @Nullable Orientation wireOrientation, boolean isMoving) {
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource r) {
        FluidPropagator.propagateChangedPipe((LevelAccessor)world, pos, state);
    }

    public static boolean isPipe(BlockState state) {
        return state.getBlock() instanceof FluidPipeBlock;
    }

    public static boolean canConnectTo(BlockAndTintGetter world, BlockPos neighbourPos, BlockState neighbour, Direction direction) {
        if (FluidPropagator.hasFluidCapability((BlockGetter)world, neighbourPos, direction.getOpposite())) {
            return true;
        }
        if (VanillaFluidTargets.canProvideFluidWithoutCapability(neighbour)) {
            return true;
        }
        if (FluidPipeBlock.isPipe(neighbour)) {
            BracketedBlockEntityBehaviour bracket = BlockEntityBehaviour.get((BlockGetter)world, neighbourPos, BracketedBlockEntityBehaviour.TYPE);
            return bracket == null || !bracket.isBracketPresent() || FluidPropagator.getStraightPipeAxis(neighbour) == direction.getAxis();
        }
        FluidTransportBehaviour transport = BlockEntityBehaviour.get((BlockGetter)world, neighbourPos, FluidTransportBehaviour.TYPE);
        if (transport == null) {
            return false;
        }
        return transport.canHaveFlowToward(neighbour, direction.getOpposite());
    }

    public static boolean shouldDrawRim(BlockAndTintGetter world, BlockPos pos, BlockState state, Direction direction) {
        BlockPos offsetPos = pos.relative(direction);
        BlockState facingState = world.getBlockState(offsetPos);
        if (facingState.getBlock() instanceof EncasedPipeBlock) {
            return true;
        }
        if (!FluidPipeBlock.isPipe(facingState)) {
            return true;
        }
        return !FluidPipeBlock.canConnectTo(world, offsetPos, facingState, direction);
    }

    public static boolean isOpenAt(BlockState state, Direction direction) {
        return (Boolean)state.getValue((Property)PROPERTY_BY_DIRECTION.get(direction));
    }

    public static boolean isCornerOrEndPipe(BlockAndTintGetter world, BlockPos pos, BlockState state) {
        return FluidPipeBlock.isPipe(state) && FluidPropagator.getStraightPipeAxis(state) == null && !FluidPipeBlock.shouldDrawCasing(world, pos, state);
    }

    public static boolean shouldDrawCasing(BlockAndTintGetter world, BlockPos pos, BlockState state) {
        if (!FluidPipeBlock.isPipe(state)) {
            return false;
        }
        for (Direction.Axis axis : Iterate.axes) {
            int connections = 0;
            for (Direction direction : Iterate.directions) {
                if (direction.getAxis() == axis || !FluidPipeBlock.isOpenAt(state, direction)) continue;
                ++connections;
            }
            if (connections <= 2) continue;
            return true;
        }
        return false;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{NORTH, EAST, SOUTH, WEST, UP, DOWN, BlockStateProperties.WATERLOGGED});
        super.createBlockStateDefinition(builder);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState FluidState2 = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)this.updateBlockState(this.defaultBlockState(), context.getNearestLookingDirection(), null, (BlockAndTintGetter)context.getLevel(), context.getClickedPos()).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(FluidState2.getType() == Fluids.WATER));
    }

    public BlockState updateShape(BlockState state, LevelReader world, ScheduledTickAccess tickView, BlockPos pos, Direction direction, BlockPos neighbourPos, BlockState neighbourState, RandomSource random) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            tickView.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(world));
        }
        if (FluidPipeBlock.isOpenAt(state, direction) && neighbourState.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
            tickView.scheduleTick(pos, (Block)this, 1, TickPriority.HIGH);
        }
        return this.updateBlockState(state, direction, direction.getOpposite(), (BlockAndTintGetter)world, pos);
    }

    public BlockState updateBlockState(BlockState state, Direction preferredDirection, @Nullable Direction ignore, BlockAndTintGetter world, BlockPos pos) {
        BracketedBlockEntityBehaviour bracket = BlockEntityBehaviour.get((BlockGetter)world, pos, BracketedBlockEntityBehaviour.TYPE);
        if (bracket != null && bracket.isBracketPresent()) {
            return state;
        }
        BlockState prevState = state;
        int prevStateSides = (int)Arrays.stream(Iterate.directions).map(PROPERTY_BY_DIRECTION::get).filter(arg_0 -> ((BlockState)prevState).getValue(arg_0)).count();
        for (Direction d : Iterate.directions) {
            if (d == ignore) continue;
            boolean shouldConnect = FluidPipeBlock.canConnectTo(world, pos.relative(d), world.getBlockState(pos.relative(d)), d);
            state = (BlockState)state.setValue((Property)PROPERTY_BY_DIRECTION.get(d), (Comparable)Boolean.valueOf(shouldConnect));
        }
        Direction connectedDirection = null;
        for (Direction d : Iterate.directions) {
            if (!FluidPipeBlock.isOpenAt(state, d)) continue;
            if (connectedDirection != null) {
                return state;
            }
            connectedDirection = d;
        }
        if (connectedDirection != null) {
            return (BlockState)state.setValue((Property)PROPERTY_BY_DIRECTION.get(connectedDirection.getOpposite()), (Comparable)Boolean.valueOf(true));
        }
        if (prevStateSides == 2) {
            return prevState;
        }
        return (BlockState)((BlockState)state.setValue((Property)PROPERTY_BY_DIRECTION.get(preferredDirection), (Comparable)Boolean.valueOf(true))).setValue((Property)PROPERTY_BY_DIRECTION.get(preferredDirection.getOpposite()), (Comparable)Boolean.valueOf(true));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : Fluids.EMPTY.defaultFluidState();
    }

    @Override
    public Optional<ItemStack> removeBracket(BlockGetter world, BlockPos pos, boolean inOnReplacedContext) {
        BracketedBlockEntityBehaviour behaviour = BracketedBlockEntityBehaviour.get(world, pos, BracketedBlockEntityBehaviour.TYPE);
        if (behaviour == null) {
            return Optional.empty();
        }
        BlockState bracket = behaviour.removeBracket(inOnReplacedContext);
        if (bracket == null) {
            return Optional.empty();
        }
        return Optional.of(new ItemStack((ItemLike)bracket.getBlock()));
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    @Override
    public Class<FluidPipeBlockEntity> getBlockEntityClass() {
        return FluidPipeBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends FluidPipeBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.FLUID_PIPE;
    }

    public VoxelShape getOcclusionShape(BlockState pState) {
        return OCCLUSION_BOX;
    }

    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return FluidPipeBlockRotation.rotate(pState, pRotation);
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return FluidPipeBlockRotation.mirror(pState, pMirror);
    }

    @Override
    public BlockState transform(BlockState state, StructureTransform transform) {
        return FluidPipeBlockRotation.transform(state, transform);
    }

    @NotNull
    protected MapCodec<? extends PipeBlock> codec() {
        return CODEC;
    }
}

