/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.fluids.pipes;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.content.fluids.FluidPropagator;
import com.zurrtum.create.content.fluids.pipes.SmartFluidPipeBlock;
import com.zurrtum.create.content.fluids.pipes.StraightPipeBlockEntity;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class SmartFluidPipeBlockEntity
extends SmartBlockEntity {
    private ServerFilteringBehaviour filter;

    public SmartFluidPipeBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.SMART_FLUID_PIPE, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        behaviours.add(new SmartPipeBehaviour(this));
        this.filter = new ServerFilteringBehaviour(this).forFluids().withCallback(this::onFilterChanged);
        behaviours.add(this.filter);
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return FluidPropagator.getSharedTriggers();
    }

    private void onFilterChanged(ItemStack newFilter) {
        if (!this.level.isClientSide()) {
            FluidPropagator.propagateChangedPipe((LevelAccessor)this.level, this.worldPosition, this.getBlockState());
        }
    }

    class SmartPipeBehaviour
    extends StraightPipeBlockEntity.StraightPipeFluidTransportBehaviour {
        public SmartPipeBehaviour(SmartBlockEntity be) {
            super(be);
        }

        @Override
        public boolean canPullFluidFrom(FluidStack fluid, BlockState state, Direction direction) {
            if (fluid.isEmpty() || SmartFluidPipeBlockEntity.this.filter != null && SmartFluidPipeBlockEntity.this.filter.test(fluid)) {
                return super.canPullFluidFrom(fluid, state, direction);
            }
            return false;
        }

        @Override
        public boolean canHaveFlowToward(BlockState state, Direction direction) {
            return state.getBlock() instanceof SmartFluidPipeBlock && SmartFluidPipeBlock.getPipeAxis(state) == direction.getAxis();
        }
    }
}

