/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.fluids.pipes.valve;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.content.fluids.FluidPropagator;
import com.zurrtum.create.content.fluids.pipes.StraightPipeBlockEntity;
import com.zurrtum.create.content.fluids.pipes.valve.FluidValveBlock;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class FluidValveBlockEntity
extends KineticBlockEntity {
    public LerpedFloat pointer = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.0, LerpedFloat.Chaser.LINEAR);

    public FluidValveBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.FLUID_VALVE, pos, state);
    }

    @Override
    public void onSpeedChanged(float previousSpeed) {
        super.onSpeedChanged(previousSpeed);
        float speed = this.getSpeed();
        this.pointer.chase(speed > 0.0f ? 1.0 : 0.0, this.getChaseSpeed(), LerpedFloat.Chaser.LINEAR);
        this.sendData();
    }

    @Override
    public void tick() {
        super.tick();
        this.pointer.tickChaser();
        if (this.level.isClientSide()) {
            return;
        }
        BlockState blockState = this.getBlockState();
        if (!(blockState.getBlock() instanceof FluidValveBlock)) {
            return;
        }
        boolean stateOpen = (Boolean)blockState.getValue((Property)FluidValveBlock.ENABLED);
        if (stateOpen && this.pointer.getValue() == 0.0f) {
            FluidValveBlockEntity.switchToBlockState(this.level, this.worldPosition, (BlockState)blockState.setValue((Property)FluidValveBlock.ENABLED, (Comparable)Boolean.valueOf(false)));
            return;
        }
        if (!stateOpen && this.pointer.getValue() == 1.0f) {
            FluidValveBlockEntity.switchToBlockState(this.level, this.worldPosition, (BlockState)blockState.setValue((Property)FluidValveBlock.ENABLED, (Comparable)Boolean.valueOf(true)));
        }
    }

    private float getChaseSpeed() {
        return Mth.clamp((float)(Math.abs(this.getSpeed()) / 16.0f / 20.0f), (float)0.0f, (float)1.0f);
    }

    @Override
    protected void write(ValueOutput view, boolean clientPacket) {
        super.write(view, clientPacket);
        this.pointer.write(view.child("Pointer"));
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        super.read(view, clientPacket);
        this.pointer.read(view.childOrEmpty("Pointer"), clientPacket);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        behaviours.add(new ValvePipeBehaviour(this));
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return FluidPropagator.getSharedTriggers();
    }

    static class ValvePipeBehaviour
    extends StraightPipeBlockEntity.StraightPipeFluidTransportBehaviour {
        public ValvePipeBehaviour(SmartBlockEntity be) {
            super(be);
        }

        @Override
        public boolean canHaveFlowToward(BlockState state, Direction direction) {
            return FluidValveBlock.getPipeAxis(state) == direction.getAxis();
        }

        @Override
        public boolean canPullFluidFrom(FluidStack fluid, BlockState state, Direction direction) {
            if (state.hasProperty((Property)FluidValveBlock.ENABLED) && ((Boolean)state.getValue((Property)FluidValveBlock.ENABLED)).booleanValue()) {
                return super.canPullFluidFrom(fluid, state, direction);
            }
            return false;
        }
    }
}

