/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.fluids.potion;

import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllFluids;
import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.foundation.fluid.FluidIngredient;
import com.zurrtum.create.foundation.fluid.FluidStackIngredient;
import com.zurrtum.create.infrastructure.component.BottleType;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class PotionFluidHandler {
    private static final Component NO_EFFECT = Component.translatable((String)"effect.none").withStyle(ChatFormatting.GRAY);

    public static boolean isPotionItem(ItemStack stack) {
        return stack.getItem() instanceof PotionItem && !(stack.getItem().getCraftingRemainder().getItem() instanceof BucketItem) && !stack.is(AllItemTags.NOT_POTION);
    }

    public static Pair<FluidStack, ItemStack> emptyPotion(ItemStack stack, boolean simulate) {
        FluidStack fluid = PotionFluidHandler.getFluidFromPotionItem(stack);
        if (!simulate) {
            stack.shrink(1);
        }
        return Pair.of(fluid, new ItemStack((ItemLike)Items.GLASS_BOTTLE));
    }

    public static FluidStack getFluidFromPotionItem(ItemStack stack) {
        PotionContents potion = (PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
        BottleType bottleTypeFromItem = PotionFluidHandler.bottleTypeFromItem(stack.getItem());
        if (potion.is(Potions.WATER) && potion.customEffects().isEmpty() && bottleTypeFromItem == BottleType.REGULAR) {
            return new FluidStack((Fluid)Fluids.WATER, 27000);
        }
        FluidStack fluid = PotionFluidHandler.getFluidFromPotion(potion, bottleTypeFromItem, 27000);
        fluid.set(AllDataComponents.POTION_FLUID_BOTTLE_TYPE, bottleTypeFromItem);
        return fluid;
    }

    public static FluidIngredient getFluidIngredientFromPotion(PotionContents potionContents, BottleType bottleType, int amount) {
        if (potionContents.is(Potions.WATER) && bottleType == BottleType.REGULAR) {
            return new FluidStackIngredient((Fluid)Fluids.WATER, DataComponentPatch.EMPTY, amount);
        }
        return PotionFluidHandler.getFluidIngredient(amount, potionContents, bottleType);
    }

    public static FluidStack getFluidFromPotion(PotionContents potionContents, BottleType bottleType, int amount) {
        if (potionContents.is(Potions.WATER) && bottleType == BottleType.REGULAR) {
            return new FluidStack((Fluid)Fluids.WATER, amount);
        }
        return PotionFluidHandler.getFluidStack(amount, potionContents, bottleType);
    }

    public static FluidIngredient getFluidIngredient(int amount, PotionContents potionContents, BottleType bottleType) {
        DataComponentPatch.Builder builder = DataComponentPatch.builder();
        if (potionContents != PotionContents.EMPTY) {
            builder.set(DataComponents.POTION_CONTENTS, (Object)potionContents);
        }
        builder.set(AllDataComponents.POTION_FLUID_BOTTLE_TYPE, (Object)bottleType);
        return new FluidStackIngredient((Fluid)AllFluids.POTION, builder.build(), amount);
    }

    public static FluidStack getFluidStack(int amount, PotionContents potionContents, BottleType bottleType) {
        FluidStack fluidStack = new FluidStack((Fluid)AllFluids.POTION, amount);
        PotionFluidHandler.addPotionToFluidStack(fluidStack, potionContents);
        fluidStack.set(AllDataComponents.POTION_FLUID_BOTTLE_TYPE, bottleType);
        return fluidStack;
    }

    public static void addPotionToFluidStack(FluidStack fs, PotionContents potionContents) {
        if (potionContents == PotionContents.EMPTY) {
            fs.remove(DataComponents.POTION_CONTENTS);
            return;
        }
        fs.set(DataComponents.POTION_CONTENTS, potionContents);
    }

    public static BottleType bottleTypeFromItem(Item item) {
        if (item == Items.LINGERING_POTION) {
            return BottleType.LINGERING;
        }
        if (item == Items.SPLASH_POTION) {
            return BottleType.SPLASH;
        }
        return BottleType.REGULAR;
    }

    public static Item itemFromBottleType(BottleType type) {
        return switch (type) {
            case BottleType.LINGERING -> Items.LINGERING_POTION;
            case BottleType.SPLASH -> Items.SPLASH_POTION;
            default -> Items.POTION;
        };
    }

    public static int getRequiredAmountForFilledBottle(ItemStack stack, FluidStack availableFluid) {
        return 27000;
    }

    public static ItemStack fillBottle(ItemStack stack, FluidStack availableFluid) {
        ItemStack potionStack = new ItemStack((ItemLike)PotionFluidHandler.itemFromBottleType((BottleType)((Object)availableFluid.getOrDefault(AllDataComponents.POTION_FLUID_BOTTLE_TYPE, (Object)BottleType.REGULAR))));
        potionStack.set(DataComponents.POTION_CONTENTS, (Object)((PotionContents)availableFluid.get(DataComponents.POTION_CONTENTS)));
        return potionStack;
    }
}

