/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.fluids.transfer;

import com.zurrtum.create.AllFluids;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.content.fluids.potion.PotionFluidHandler;
import com.zurrtum.create.foundation.fluid.FluidHelper;
import com.zurrtum.create.infrastructure.fluids.FluidItemInventory;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import net.minecraft.core.Holder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class GenericItemFilling {
    public static boolean canItemBeFilled(Level world, ItemStack stack) {
        if (stack.getItem() == Items.GLASS_BOTTLE) {
            return true;
        }
        if (stack.getItem() == Items.MILK_BUCKET) {
            return false;
        }
        try (FluidItemInventory capability = FluidHelper.getFluidInventory(stack);){
            if (capability == null) {
                boolean bl = false;
                return bl;
            }
            int size = capability.size();
            for (int i = 0; i < size; ++i) {
                FluidStack fluidStack = capability.getStack(i);
                if (fluidStack.getAmount() >= capability.getMaxAmount(fluidStack)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public static int getRequiredAmountForItem(Level world, ItemStack stack, FluidStack availableFluid) {
        if (stack.getItem() == Items.GLASS_BOTTLE && GenericItemFilling.canFillGlassBottleInternally(availableFluid)) {
            return PotionFluidHandler.getRequiredAmountForFilledBottle(stack, availableFluid);
        }
        try (FluidItemInventory capability = FluidHelper.getFluidInventory(stack);){
            if (capability == null) {
                int n = -1;
                return n;
            }
            int n = capability.countSpace(availableFluid);
            return n;
        }
    }

    private static boolean canFillGlassBottleInternally(FluidStack availableFluid) {
        Fluid fluid = availableFluid.getFluid();
        if (fluid.isSame((Fluid)Fluids.WATER)) {
            return true;
        }
        if (fluid.isSame((Fluid)AllFluids.POTION)) {
            return true;
        }
        return fluid.isSame((Fluid)AllFluids.TEA);
    }

    public static ItemStack fillItem(Level world, int requiredAmount, ItemStack stack, FluidStack availableFluid) {
        FluidStack toFill = availableFluid.copy();
        toFill.setAmount(requiredAmount);
        if (stack.getItem() == Items.GLASS_BOTTLE && GenericItemFilling.canFillGlassBottleInternally(toFill)) {
            Fluid fluid = toFill.getFluid();
            ItemStack fillBottle = FluidHelper.isWater(fluid) ? PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.WATER) : (fluid.isSame((Fluid)AllFluids.TEA) ? AllItems.BUILDERS_TEA.getDefaultInstance() : PotionFluidHandler.fillBottle(stack, toFill));
            availableFluid.decrement(requiredAmount);
            stack.shrink(1);
            return fillBottle;
        }
        try (FluidItemInventory capability = FluidHelper.getFluidInventory(stack.copyWithCount(1));){
            if (capability == null) {
                ItemStack fluid = ItemStack.EMPTY;
                return fluid;
            }
            int insert = capability.insert(toFill);
            if (insert == 0) {
                ItemStack itemStack = ItemStack.EMPTY;
                return itemStack;
            }
            availableFluid.decrement(insert);
            stack.shrink(1);
            ItemStack itemStack = capability.getContainer();
            return itemStack;
        }
    }
}

