/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.base;

import com.zurrtum.create.AllBlockTags;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.foundation.utility.BlockHelper;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;

public abstract class BlockBreakingKineticBlockEntity
extends KineticBlockEntity {
    public static final AtomicInteger NEXT_BREAKER_ID = new AtomicInteger();
    protected int ticksUntilNextProgress;
    protected int destroyProgress;
    protected int breakerId = -NEXT_BREAKER_ID.incrementAndGet();
    protected BlockPos breakingPos;

    public BlockBreakingKineticBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        if (this.destroyProgress == -1) {
            this.destroyNextTick();
        }
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.ticksUntilNextProgress == -1) {
            this.destroyNextTick();
        }
    }

    public void destroyNextTick() {
        this.ticksUntilNextProgress = 1;
    }

    protected abstract BlockPos getBreakingPos();

    protected boolean shouldRun() {
        return true;
    }

    @Override
    public void write(ValueOutput view, boolean clientPacket) {
        view.putInt("Progress", this.destroyProgress);
        view.putInt("NextTick", this.ticksUntilNextProgress);
        if (this.breakingPos != null) {
            view.store("Breaking", BlockPos.CODEC, (Object)this.breakingPos);
        }
        super.write(view, clientPacket);
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        this.destroyProgress = view.getIntOr("Progress", 0);
        this.ticksUntilNextProgress = view.getIntOr("NextTick", 0);
        this.breakingPos = view.read("Breaking", BlockPos.CODEC).orElse(null);
        super.read(view, clientPacket);
    }

    @Override
    public void invalidate() {
        super.invalidate();
        if (!this.level.isClientSide() && this.destroyProgress != 0) {
            this.level.destroyBlockProgress(this.breakerId, this.breakingPos, -1);
        }
    }

    @Override
    public void tick() {
        float blockHardness;
        super.tick();
        if (this.level.isClientSide()) {
            return;
        }
        if (!this.shouldRun()) {
            return;
        }
        if (this.getSpeed() == 0.0f) {
            return;
        }
        this.breakingPos = this.getBreakingPos();
        if (this.ticksUntilNextProgress < 0) {
            return;
        }
        if (this.ticksUntilNextProgress-- > 0) {
            return;
        }
        BlockState stateToBreak = this.level.getBlockState(this.breakingPos);
        if (!this.canBreak(stateToBreak, blockHardness = stateToBreak.getDestroySpeed((BlockGetter)this.level, this.breakingPos))) {
            if (this.destroyProgress != 0) {
                this.destroyProgress = 0;
                this.level.destroyBlockProgress(this.breakerId, this.breakingPos, -1);
            }
            return;
        }
        float breakSpeed = this.getBreakSpeed();
        this.destroyProgress += Mth.clamp((int)((int)(breakSpeed / blockHardness)), (int)1, (int)(10 - this.destroyProgress));
        this.level.playSound(null, this.worldPosition, stateToBreak.getSoundType().getHitSound(), SoundSource.BLOCKS, 0.25f, 1.0f);
        if (this.destroyProgress >= 10) {
            this.onBlockBroken(stateToBreak);
            this.destroyProgress = 0;
            this.ticksUntilNextProgress = -1;
            this.level.destroyBlockProgress(this.breakerId, this.breakingPos, -1);
            return;
        }
        this.ticksUntilNextProgress = (int)(blockHardness / breakSpeed);
        this.level.destroyBlockProgress(this.breakerId, this.breakingPos, this.destroyProgress);
    }

    public boolean canBreak(BlockState stateToBreak, float blockHardness) {
        return BlockBreakingKineticBlockEntity.isBreakable(stateToBreak, blockHardness);
    }

    public static boolean isBreakable(BlockState stateToBreak, float blockHardness) {
        return !stateToBreak.liquid() && !(stateToBreak.getBlock() instanceof AirBlock) && blockHardness != -1.0f && !stateToBreak.is(AllBlockTags.NON_BREAKABLE);
    }

    public void onBlockBroken(BlockState stateToBreak) {
        Vec3 vec = VecHelper.offsetRandomly(VecHelper.getCenterOf((Vec3i)this.breakingPos), this.level.random, 0.125f);
        BlockHelper.destroyBlock(this.level, this.breakingPos, 1.0f, stack -> {
            if (stack.isEmpty()) {
                return;
            }
            if (!((Boolean)((ServerLevel)this.level).getGameRules().get(GameRules.BLOCK_DROPS)).booleanValue()) {
                return;
            }
            ItemEntity itementity = new ItemEntity(this.level, vec.x, vec.y, vec.z, stack);
            itementity.setDefaultPickUpDelay();
            itementity.setDeltaMovement(Vec3.ZERO);
            this.level.addFreshEntity((Entity)itementity);
        });
    }

    protected float getBreakSpeed() {
        return Math.abs(this.getSpeed() / 100.0f);
    }
}

