/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.base;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.Create;
import com.zurrtum.create.api.stress.BlockStressValues;
import com.zurrtum.create.content.kinetics.KineticNetwork;
import com.zurrtum.create.content.kinetics.RotationPropagator;
import com.zurrtum.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.base.KineticBlock;
import com.zurrtum.create.content.kinetics.base.KineticEffectHandler;
import com.zurrtum.create.content.kinetics.simpleRelays.ICogWheel;
import com.zurrtum.create.content.kinetics.transmission.sequencer.SequencedGearshiftBlockEntity;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.Nullable;

public class KineticBlockEntity
extends SmartBlockEntity {
    @Nullable
    public Long network;
    @Nullable
    public BlockPos source;
    public boolean networkDirty;
    public boolean updateSpeed = true;
    public int preventSpeedUpdate;
    public SequencedGearshiftBlockEntity.SequenceContext sequenceContext;
    public KineticEffectHandler effects = new KineticEffectHandler(this);
    protected float speed;
    protected float capacity;
    protected float stress;
    protected boolean overStressed;
    protected boolean wasMoved;
    protected float lastStressApplied;
    protected float lastCapacityProvided;
    private int flickerTally;
    private int networkSize;
    private int validationCountdown;

    public KineticBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public static KineticBlockEntity encased(BlockPos pos, BlockState state) {
        return new KineticBlockEntity(AllBlockEntityTypes.ENCASED_SHAFT, pos, state);
    }

    public static void switchToBlockState(Level world, BlockPos pos, BlockState state) {
        if (world.isClientSide()) {
            return;
        }
        BlockEntity blockEntity = world.getBlockEntity(pos);
        BlockState currentState = world.getBlockState(pos);
        boolean isKinetic = blockEntity instanceof KineticBlockEntity;
        if (currentState == state) {
            return;
        }
        if (blockEntity == null || !isKinetic) {
            world.setBlock(pos, state, 3);
            return;
        }
        KineticBlockEntity kineticBlockEntity = (KineticBlockEntity)blockEntity;
        if (state.getBlock() instanceof KineticBlock && !((KineticBlock)state.getBlock()).areStatesKineticallyEquivalent(currentState, state)) {
            if (kineticBlockEntity.hasNetwork()) {
                kineticBlockEntity.getOrCreateNetwork().remove(kineticBlockEntity);
            }
            kineticBlockEntity.detachKinetics();
            kineticBlockEntity.removeSource();
        }
        if (blockEntity instanceof GeneratingKineticBlockEntity) {
            GeneratingKineticBlockEntity generatingBlockEntity = (GeneratingKineticBlockEntity)blockEntity;
            generatingBlockEntity.reActivateSource = true;
        }
        world.setBlock(pos, state, 3);
    }

    public static float convertToDirection(float axisSpeed, Direction d) {
        return d.getAxisDirection() == Direction.AxisDirection.POSITIVE ? axisSpeed : -axisSpeed;
    }

    public static float convertToLinear(float speed) {
        return speed / 512.0f;
    }

    public static float convertToAngular(float speed) {
        return speed * 3.0f / 10.0f;
    }

    @Override
    public void initialize() {
        if (this.hasNetwork() && !this.level.isClientSide()) {
            KineticNetwork network = this.getOrCreateNetwork();
            if (!network.initialized) {
                network.initFromTE(this.capacity, this.stress, this.networkSize);
            }
            network.addSilently(this, this.lastCapacityProvided, this.lastStressApplied);
        }
        super.initialize();
    }

    @Override
    public void tick() {
        if (!this.level.isClientSide() && this.needsSpeedUpdate()) {
            this.attachKinetics();
        }
        super.tick();
        this.effects.tick();
        this.preventSpeedUpdate = 0;
        if (this.level.isClientSide()) {
            return;
        }
        if (this.validationCountdown-- <= 0) {
            this.validationCountdown = (Integer)AllConfigs.server().kinetics.kineticValidationFrequency.get();
            this.validateKinetics();
        }
        if (this.getFlickerScore() > 0) {
            this.flickerTally = this.getFlickerScore() - 1;
        }
        if (this.networkDirty) {
            if (this.hasNetwork()) {
                this.getOrCreateNetwork().updateNetwork();
            }
            this.networkDirty = false;
        }
    }

    private void validateKinetics() {
        if (this.hasSource()) {
            KineticBlockEntity sourceBE;
            if (!this.hasNetwork()) {
                this.removeSource();
                return;
            }
            if (!this.level.hasChunkAt(this.source)) {
                return;
            }
            BlockEntity blockEntity = this.level.getBlockEntity(this.source);
            KineticBlockEntity kineticBlockEntity = sourceBE = blockEntity instanceof KineticBlockEntity ? (KineticBlockEntity)blockEntity : null;
            if (sourceBE == null || sourceBE.speed == 0.0f) {
                this.removeSource();
                this.detachKinetics();
                return;
            }
            return;
        }
        if (this.speed != 0.0f && this.getGeneratedSpeed() == 0.0f) {
            this.speed = 0.0f;
        }
    }

    public void updateFromNetwork(float maxStress, float currentStress, int networkSize) {
        this.networkDirty = false;
        this.capacity = maxStress;
        this.stress = currentStress;
        this.networkSize = networkSize;
        boolean overStressed = maxStress < currentStress && IRotate.StressImpact.isEnabled();
        this.setChanged();
        if (overStressed != this.overStressed) {
            float prevSpeed = this.getSpeed();
            this.overStressed = overStressed;
            this.onSpeedChanged(prevSpeed);
            this.sendData();
        }
    }

    protected Block getStressConfigKey() {
        return this.getBlockState().getBlock();
    }

    public float calculateStressApplied() {
        float impact;
        this.lastStressApplied = impact = (float)BlockStressValues.getImpact(this.getStressConfigKey());
        return impact;
    }

    public float calculateAddedStressCapacity() {
        float capacity;
        this.lastCapacityProvided = capacity = (float)BlockStressValues.getCapacity(this.getStressConfigKey());
        return capacity;
    }

    public void onSpeedChanged(float previousSpeed) {
        boolean directionSwap;
        boolean fromOrToZero = previousSpeed == 0.0f != (this.getSpeed() == 0.0f);
        boolean bl = directionSwap = !fromOrToZero && Math.signum(previousSpeed) != Math.signum(this.getSpeed());
        if (fromOrToZero || directionSwap) {
            this.flickerTally = this.getFlickerScore() + 5;
        }
        this.setChanged();
    }

    @Override
    public void remove() {
        if (!this.level.isClientSide()) {
            if (this.hasNetwork()) {
                this.getOrCreateNetwork().remove(this);
            }
            this.detachKinetics();
        }
        super.remove();
    }

    @Override
    protected void write(ValueOutput view, boolean clientPacket) {
        view.putFloat("Speed", this.speed);
        if (this.sequenceContext != null && (!clientPacket || this.syncSequenceContext())) {
            view.store("Sequence", SequencedGearshiftBlockEntity.SequenceContext.CODEC, (Object)this.sequenceContext);
        }
        if (this.needsSpeedUpdate()) {
            view.putBoolean("NeedsSpeedUpdate", true);
        }
        if (this.hasSource()) {
            view.store("Source", BlockPos.CODEC, (Object)this.source);
        }
        if (this.hasNetwork()) {
            ValueOutput networkTag = view.child("Network");
            networkTag.putLong("Id", this.network.longValue());
            networkTag.putFloat("Stress", this.stress);
            networkTag.putFloat("Capacity", this.capacity);
            networkTag.putInt("Size", this.networkSize);
            if (this.lastStressApplied != 0.0f) {
                networkTag.putFloat("AddedStress", this.lastStressApplied);
            }
            if (this.lastCapacityProvided != 0.0f) {
                networkTag.putFloat("AddedCapacity", this.lastCapacityProvided);
            }
        }
        super.write(view, clientPacket);
    }

    public boolean needsSpeedUpdate() {
        return this.updateSpeed;
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        boolean overStressedBefore = this.overStressed;
        this.clearKineticInformation();
        if (this.wasMoved) {
            super.read(view, clientPacket);
            return;
        }
        this.speed = view.getFloatOr("Speed", 0.0f);
        this.sequenceContext = view.read("Sequence", SequencedGearshiftBlockEntity.SequenceContext.CODEC).orElse(null);
        this.source = view.read("Source", BlockPos.CODEC).orElse(null);
        view.child("Network").ifPresent(networkTag -> {
            this.network = networkTag.getLongOr("Id", 0L);
            this.stress = networkTag.getFloatOr("Stress", 0.0f);
            this.capacity = networkTag.getFloatOr("Capacity", 0.0f);
            this.networkSize = networkTag.getIntOr("Size", 0);
            this.lastStressApplied = networkTag.getFloatOr("AddedStress", 0.0f);
            this.lastCapacityProvided = networkTag.getFloatOr("AddedCapacity", 0.0f);
            this.overStressed = this.capacity < this.stress && IRotate.StressImpact.isEnabled();
        });
        super.read(view, clientPacket);
        if (clientPacket && overStressedBefore != this.overStressed && this.speed != 0.0f) {
            this.effects.triggerOverStressedEffect();
        }
        if (clientPacket) {
            AllClientHandle.INSTANCE.queueUpdate(this);
        }
    }

    public float getGeneratedSpeed() {
        return 0.0f;
    }

    public boolean isSource() {
        return this.getGeneratedSpeed() != 0.0f;
    }

    public void setSource(BlockPos source) {
        this.source = source;
        if (this.level == null || this.level.isClientSide()) {
            return;
        }
        BlockEntity blockEntity = this.level.getBlockEntity(source);
        if (!(blockEntity instanceof KineticBlockEntity)) {
            this.removeSource();
            return;
        }
        KineticBlockEntity sourceBE = (KineticBlockEntity)blockEntity;
        this.setNetwork(sourceBE.network);
        this.copySequenceContextFrom(sourceBE);
    }

    public float getSpeed() {
        if (this.overStressed || this.level != null && this.level.tickRateManager().isFrozen()) {
            return 0.0f;
        }
        return this.getTheoreticalSpeed();
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public float getTheoreticalSpeed() {
        return this.speed;
    }

    public boolean hasSource() {
        return this.source != null;
    }

    protected void copySequenceContextFrom(KineticBlockEntity sourceBE) {
        this.sequenceContext = sourceBE.sequenceContext;
    }

    public void removeSource() {
        float prevSpeed = this.getSpeed();
        this.speed = 0.0f;
        this.source = null;
        this.setNetwork(null);
        this.sequenceContext = null;
        this.onSpeedChanged(prevSpeed);
    }

    public void setNetwork(@Nullable Long networkIn) {
        if (Objects.equals(this.network, networkIn)) {
            return;
        }
        if (this.network != null) {
            this.getOrCreateNetwork().remove(this);
        }
        this.network = networkIn;
        this.setChanged();
        if (networkIn == null) {
            return;
        }
        this.network = networkIn;
        KineticNetwork network = this.getOrCreateNetwork();
        network.initialized = true;
        network.add(this);
    }

    public KineticNetwork getOrCreateNetwork() {
        return Create.TORQUE_PROPAGATOR.getOrCreateNetworkFor(this);
    }

    public boolean hasNetwork() {
        return this.network != null;
    }

    public void attachKinetics() {
        this.updateSpeed = false;
        RotationPropagator.handleAdded(this.level, this.worldPosition, this);
    }

    public void detachKinetics() {
        RotationPropagator.handleRemoved(this.level, this.worldPosition, this);
    }

    public boolean isSpeedRequirementFulfilled() {
        BlockState state = this.getBlockState();
        Block block = state.getBlock();
        if (!(block instanceof IRotate)) {
            return true;
        }
        IRotate def = (IRotate)block;
        IRotate.SpeedLevel minimumRequiredSpeedLevel = def.getMinimumRequiredSpeedLevel();
        return Math.abs(this.getSpeed()) >= minimumRequiredSpeedLevel.getSpeedValue();
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
    }

    public void clearKineticInformation() {
        this.speed = 0.0f;
        this.source = null;
        this.network = null;
        this.overStressed = false;
        this.stress = 0.0f;
        this.capacity = 0.0f;
        this.lastStressApplied = 0.0f;
        this.lastCapacityProvided = 0.0f;
    }

    public void warnOfMovement() {
        this.wasMoved = true;
    }

    public int getFlickerScore() {
        return this.flickerTally;
    }

    public boolean isOverStressed() {
        return this.overStressed;
    }

    public float propagateRotationTo(KineticBlockEntity target, BlockState stateFrom, BlockState stateTo, BlockPos diff, boolean connectedViaAxes, boolean connectedViaCogs) {
        return 0.0f;
    }

    public List<BlockPos> addPropagationLocations(IRotate block, BlockState state, List<BlockPos> neighbours) {
        if (!this.canPropagateDiagonally(block, state)) {
            return neighbours;
        }
        Direction.Axis axis = block.getRotationAxis(state);
        BlockPos.betweenClosedStream((BlockPos)new BlockPos(-1, -1, -1), (BlockPos)new BlockPos(1, 1, 1)).forEach(offset -> {
            if (axis.choose(offset.getX(), offset.getY(), offset.getZ()) != 0) {
                return;
            }
            if (offset.distSqr((Vec3i)BlockPos.ZERO) != 2.0) {
                return;
            }
            neighbours.add(this.worldPosition.offset((Vec3i)offset));
        });
        return neighbours;
    }

    public boolean isCustomConnection(KineticBlockEntity other, BlockState state, BlockState otherState) {
        return false;
    }

    protected boolean canPropagateDiagonally(IRotate block, BlockState state) {
        return ICogWheel.isSmallCog(state);
    }

    public boolean isNoisy() {
        return true;
    }

    public int getRotationAngleOffset(Direction.Axis axis) {
        return 0;
    }

    protected boolean syncSequenceContext() {
        return false;
    }
}

