/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.belt;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.api.contraption.transformable.TransformableBlock;
import com.zurrtum.create.api.schematic.requirement.SpecialBlockItemRequirement;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.contraptions.StructureTransform;
import com.zurrtum.create.content.equipment.armor.DivingBootsItem;
import com.zurrtum.create.content.fluids.transfer.GenericItemEmptying;
import com.zurrtum.create.content.kinetics.base.HorizontalKineticBlock;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.belt.BeltBlockEntity;
import com.zurrtum.create.content.kinetics.belt.BeltHelper;
import com.zurrtum.create.content.kinetics.belt.BeltPart;
import com.zurrtum.create.content.kinetics.belt.BeltShapes;
import com.zurrtum.create.content.kinetics.belt.BeltSlicer;
import com.zurrtum.create.content.kinetics.belt.BeltSlope;
import com.zurrtum.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.zurrtum.create.content.kinetics.belt.transport.BeltMovementHandler;
import com.zurrtum.create.content.kinetics.belt.transport.BeltTunnelInteractionHandler;
import com.zurrtum.create.content.logistics.box.PackageEntity;
import com.zurrtum.create.content.logistics.box.PackageItem;
import com.zurrtum.create.content.logistics.funnel.FunnelBlock;
import com.zurrtum.create.content.logistics.tunnel.BeltTunnelBlock;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.block.ProperWaterloggedBlock;
import com.zurrtum.create.foundation.item.ItemHelper;
import com.zurrtum.create.infrastructure.items.ItemInventoryProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.DebugLevelSource;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class BeltBlock
extends HorizontalKineticBlock
implements IBE<BeltBlockEntity>,
SpecialBlockItemRequirement,
TransformableBlock,
ProperWaterloggedBlock,
ItemInventoryProvider<BeltBlockEntity> {
    public static final EnumProperty<BeltSlope> SLOPE = EnumProperty.create((String)"slope", BeltSlope.class);
    public static final EnumProperty<BeltPart> PART = EnumProperty.create((String)"part", BeltPart.class);
    public static final BooleanProperty CASING = BooleanProperty.create((String)"casing");

    public BeltBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(SLOPE, (Comparable)((Object)BeltSlope.HORIZONTAL))).setValue(PART, (Comparable)((Object)BeltPart.START))).setValue((Property)CASING, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public Container getInventory(LevelAccessor world, BlockPos pos, BlockState state, BeltBlockEntity blockEntity, Direction context) {
        if (!BeltBlock.canTransportObjects(blockEntity.getBlockState())) {
            return null;
        }
        if (!blockEntity.isRemoved() && blockEntity.itemHandler == null) {
            blockEntity.initializeItemHandler();
        }
        return blockEntity.itemHandler;
    }

    @Override
    protected boolean areStatesKineticallyEquivalent(BlockState oldState, BlockState newState) {
        return super.areStatesKineticallyEquivalent(oldState, newState) && oldState.getValue(PART) == newState.getValue(PART);
    }

    @Override
    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        if (face.getAxis() != this.getRotationAxis(state)) {
            return false;
        }
        return this.getBlockEntityOptional((BlockGetter)world, pos).map(BeltBlockEntity::hasPulley).orElse(false);
    }

    @Override
    public Direction.Axis getRotationAxis(BlockState state) {
        if (state.getValue(SLOPE) == BeltSlope.SIDEWAYS) {
            return Direction.Axis.Y;
        }
        return ((Direction)state.getValue((Property)HORIZONTAL_FACING)).getClockWise().getAxis();
    }

    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state, boolean includeData) {
        return AllItems.BELT_CONNECTOR.getDefaultInstance();
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        List drops = super.getDrops(state, builder);
        BlockEntity blockEntity = (BlockEntity)builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (blockEntity instanceof BeltBlockEntity && ((BeltBlockEntity)blockEntity).hasPulley()) {
            drops.addAll(AllBlocks.SHAFT.defaultBlockState().getDrops(builder));
        }
        return drops;
    }

    public void spawnAfterBreak(BlockState state, ServerLevel worldIn, BlockPos pos, ItemStack p_220062_4_, boolean b) {
        BeltBlockEntity controllerBE = BeltHelper.getControllerBE((LevelAccessor)worldIn, pos);
        if (controllerBE != null) {
            controllerBE.getInventory().ejectAll();
        }
    }

    public void updateEntityMovementAfterFallOn(BlockGetter worldIn, Entity entityIn) {
        super.updateEntityMovementAfterFallOn(worldIn, entityIn);
        BlockPos entityPosition = entityIn.blockPosition();
        BlockPos beltPos = null;
        if (worldIn.getBlockState(entityPosition).is((Block)AllBlocks.BELT)) {
            beltPos = entityPosition;
        } else if (worldIn.getBlockState(entityPosition.below()).is((Block)AllBlocks.BELT)) {
            beltPos = entityPosition.below();
        }
        if (beltPos == null) {
            return;
        }
        if (!(worldIn instanceof Level)) {
            return;
        }
        Level world = (Level)worldIn;
        this.entityInside(worldIn.getBlockState(beltPos), world, beltPos, entityIn, InsideBlockEffectApplier.NOOP, false);
    }

    public void entityInside(BlockState state, Level worldIn, BlockPos pos, Entity entityIn, InsideBlockEffectApplier handler, boolean bl) {
        if (!BeltBlock.canTransportObjects(state)) {
            return;
        }
        if (entityIn instanceof Player) {
            Player player = (Player)entityIn;
            if (player.isShiftKeyDown() && !player.getItemBySlot(EquipmentSlot.FEET).is((Item)AllItems.CARDBOARD_BOOTS)) {
                return;
            }
            if (player.getAbilities().flying) {
                return;
            }
        }
        if (DivingBootsItem.isWornBy(entityIn)) {
            return;
        }
        BeltBlockEntity belt = BeltHelper.getSegmentBE((LevelAccessor)worldIn, pos);
        if (belt == null) {
            return;
        }
        ItemStack asItem = ItemHelper.fromItemEntity(entityIn);
        if (!asItem.isEmpty()) {
            if (worldIn.isClientSide()) {
                return;
            }
            if (entityIn.getDeltaMovement().y > 0.0) {
                return;
            }
            Vec3 targetLocation = VecHelper.getCenterOf((Vec3i)pos).add(0.0, 0.3125, 0.0);
            if (!PackageEntity.centerPackage(entityIn, targetLocation)) {
                return;
            }
            if (BeltTunnelInteractionHandler.getTunnelOnPosition(worldIn, pos) != null) {
                return;
            }
            this.withBlockEntityDo((BlockGetter)worldIn, pos, be -> {
                Container inventory = ItemHelper.getInventory(worldIn, pos, state, be, null);
                if (inventory == null) {
                    return;
                }
                int insert = inventory.insert(asItem);
                if (asItem.getCount() == insert) {
                    entityIn.discard();
                } else if (entityIn instanceof ItemEntity) {
                    ItemEntity itemEntity = (ItemEntity)entityIn;
                    if (insert != 0) {
                        asItem.shrink(insert);
                        itemEntity.setItem(asItem);
                    }
                }
            });
            return;
        }
        BeltBlockEntity controller = BeltHelper.getControllerBE((LevelAccessor)worldIn, pos);
        if (controller == null || controller.passengers == null) {
            return;
        }
        if (controller.passengers.containsKey(entityIn)) {
            BeltMovementHandler.TransportedEntityInfo info = controller.passengers.get(entityIn);
            if (info.getTicksSinceLastCollision() != 0 || pos.equals((Object)entityIn.blockPosition())) {
                info.refresh(pos, state);
            }
        } else {
            controller.passengers.put(entityIn, new BeltMovementHandler.TransportedEntityInfo(pos, state));
            entityIn.setOnGround(true);
        }
    }

    public static boolean canTransportObjects(BlockState state) {
        if (!state.is((Block)AllBlocks.BELT)) {
            return false;
        }
        BeltSlope slope = (BeltSlope)((Object)state.getValue(SLOPE));
        return slope != BeltSlope.VERTICAL && slope != BeltSlope.SIDEWAYS;
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        SoundType soundType;
        boolean isHand;
        if (player.isShiftKeyDown() || !player.mayBuild()) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        boolean isWrench = stack.is((Item)AllItems.WRENCH);
        boolean isConnector = stack.is((Item)AllItems.BELT_CONNECTOR);
        boolean isShaft = stack.is((Item)AllItems.SHAFT);
        boolean isDye = stack.is(AllItemTags.DYES);
        boolean hasWater = !stack.isEmpty() && GenericItemEmptying.emptyItem(level, stack, true).getFirst().getFluid().isSame((Fluid)Fluids.WATER);
        boolean bl = isHand = stack.isEmpty() && hand == InteractionHand.MAIN_HAND;
        if (isDye || hasWater) {
            return this.onBlockEntityUseItemOn((BlockGetter)level, pos, be -> be.applyColor(AllItemTags.getDyeColor(stack)) ? InteractionResult.SUCCESS : InteractionResult.TRY_WITH_EMPTY_HAND);
        }
        if (isConnector) {
            return BeltSlicer.useConnector(state, level, pos, player, hand, hitResult, new BeltSlicer.Feedback());
        }
        if (isWrench) {
            return BeltSlicer.useWrench(state, level, pos, player, hand, hitResult, new BeltSlicer.Feedback());
        }
        BeltBlockEntity belt = BeltHelper.getSegmentBE((LevelAccessor)level, pos);
        if (belt == null) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        if (PackageItem.isPackage(stack)) {
            ItemStack toInsert = stack.copy();
            Container handler = ItemHelper.getInventory(level, belt.getBlockPos(), null);
            if (handler == null) {
                return InteractionResult.TRY_WITH_EMPTY_HAND;
            }
            int insert = handler.insert(toInsert);
            if (insert != 0) {
                stack.shrink(insert);
                return InteractionResult.SUCCESS;
            }
        }
        if (isHand) {
            BeltBlockEntity controllerBelt = belt.getControllerBE();
            if (controllerBelt == null) {
                return InteractionResult.TRY_WITH_EMPTY_HAND;
            }
            if (level.isClientSide()) {
                return InteractionResult.SUCCESS;
            }
            MutableBoolean success = new MutableBoolean(false);
            controllerBelt.getInventory().applyToEachWithin((float)belt.index + 0.5f, 0.55f, transportedItemStack -> {
                player.getInventory().placeItemBackInInventory(transportedItemStack.stack);
                success.setTrue();
                return TransportedItemStackHandlerBehaviour.TransportedResult.removeItem();
            });
            if (success.isTrue()) {
                level.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, 1.0f + level.random.nextFloat());
            }
        }
        if (isShaft) {
            if (state.getValue(PART) != BeltPart.MIDDLE) {
                return InteractionResult.TRY_WITH_EMPTY_HAND;
            }
            if (level.isClientSide()) {
                return InteractionResult.SUCCESS;
            }
            if (!player.isCreative()) {
                stack.shrink(1);
            }
            KineticBlockEntity.switchToBlockState(level, pos, (BlockState)state.setValue(PART, (Comparable)((Object)BeltPart.PULLEY)));
            return InteractionResult.SUCCESS;
        }
        if (stack.is((Item)AllItems.BRASS_CASING)) {
            this.withBlockEntityDo((BlockGetter)level, pos, be -> be.setCasingType(BeltBlockEntity.CasingType.BRASS));
            this.updateCoverProperty((LevelReader)level, pos, level.getBlockState(pos));
            soundType = AllBlocks.BRASS_CASING.defaultBlockState().getSoundType();
            level.playSound(null, pos, soundType.getPlaceSound(), SoundSource.BLOCKS, (soundType.getVolume() + 1.0f) / 2.0f, soundType.getPitch() * 0.8f);
            return InteractionResult.SUCCESS;
        }
        if (stack.is((Item)AllItems.ANDESITE_CASING)) {
            this.withBlockEntityDo((BlockGetter)level, pos, be -> be.setCasingType(BeltBlockEntity.CasingType.ANDESITE));
            this.updateCoverProperty((LevelReader)level, pos, level.getBlockState(pos));
            soundType = AllBlocks.ANDESITE_CASING.defaultBlockState().getSoundType();
            level.playSound(null, pos, soundType.getPlaceSound(), SoundSource.BLOCKS, (soundType.getVolume() + 1.0f) / 2.0f, soundType.getPitch() * 0.8f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.TRY_WITH_EMPTY_HAND;
    }

    @Override
    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        Level world = context.getLevel();
        Player player = context.getPlayer();
        BlockPos pos = context.getClickedPos();
        if (((Boolean)state.getValue((Property)CASING)).booleanValue()) {
            if (world.isClientSide()) {
                return InteractionResult.SUCCESS;
            }
            this.withBlockEntityDo((BlockGetter)world, pos, be -> be.setCasingType(BeltBlockEntity.CasingType.NONE));
            return InteractionResult.SUCCESS;
        }
        if (state.getValue(PART) == BeltPart.PULLEY) {
            if (world.isClientSide()) {
                return InteractionResult.SUCCESS;
            }
            KineticBlockEntity.switchToBlockState(world, pos, (BlockState)state.setValue(PART, (Comparable)((Object)BeltPart.MIDDLE)));
            if (player != null && !player.isCreative()) {
                player.getInventory().placeItemBackInInventory(AllItems.SHAFT.getDefaultInstance());
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{SLOPE, PART, CASING, WATERLOGGED});
        super.createBlockStateDefinition(builder);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return BeltShapes.getShape(state);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (state.getBlock() != this) {
            return Shapes.empty();
        }
        VoxelShape shape = this.getShape(state, worldIn, pos, context);
        if (!(context instanceof EntityCollisionContext)) {
            return shape;
        }
        return this.getBlockEntityOptional(worldIn, pos).map(be -> {
            Entity entity = ((EntityCollisionContext)context).getEntity();
            if (entity == null) {
                return shape;
            }
            BeltBlockEntity controller = be.getControllerBE();
            if (controller == null) {
                return shape;
            }
            if (controller.passengers == null || !controller.passengers.containsKey(entity)) {
                return BeltShapes.getCollisionShape(state);
            }
            return shape;
        }).orElse(shape);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void initBelt(Level world, BlockPos pos) {
        ServerLevel serverWorld;
        if (world.isClientSide()) {
            return;
        }
        if (world instanceof ServerLevel && (serverWorld = (ServerLevel)world).getChunkSource().getGenerator() instanceof DebugLevelSource) {
            return;
        }
        BlockState state = world.getBlockState(pos);
        if (!state.is((Block)AllBlocks.BELT)) {
            return;
        }
        int limit = 1000;
        BlockPos currentPos = pos;
        while (limit-- > 0) {
            BlockState currentState = world.getBlockState(currentPos);
            if (!currentState.is((Block)AllBlocks.BELT)) {
                world.destroyBlock(pos, true);
                return;
            }
            BlockPos nextSegmentPosition = BeltBlock.nextSegmentPosition(currentState, currentPos, false);
            if (nextSegmentPosition == null) break;
            if (!world.isLoaded(nextSegmentPosition)) {
                return;
            }
            currentPos = nextSegmentPosition;
        }
        int index = 0;
        List<BlockPos> beltChain = BeltBlock.getBeltChain((LevelReader)world, currentPos);
        if (beltChain.size() < 2) {
            world.destroyBlock(currentPos, true);
            return;
        }
        Iterator<BlockPos> iterator = beltChain.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                return;
            }
            BlockPos beltPos = iterator.next();
            BlockEntity blockEntity = world.getBlockEntity(beltPos);
            BlockState currentState = world.getBlockState(beltPos);
            if (!(blockEntity instanceof BeltBlockEntity)) break;
            BeltBlockEntity be = (BeltBlockEntity)blockEntity;
            if (!currentState.is((Block)AllBlocks.BELT)) break;
            be.setController(currentPos);
            be.beltLength = beltChain.size();
            be.index = index;
            be.attachKinetics();
            be.setChanged();
            be.sendData();
            if (be.isController() && !BeltBlock.canTransportObjects(currentState)) {
                be.getInventory().ejectAll();
            }
            ++index;
        }
        world.destroyBlock(currentPos, true);
    }

    public void affectNeighborsAfterRemoval(BlockState state, ServerLevel world, BlockPos pos, boolean isMoving) {
        super.affectNeighborsAfterRemoval(state, world, pos, isMoving);
        if (world.isClientSide()) {
            return;
        }
        if (isMoving) {
            return;
        }
        for (boolean forward : Iterate.trueAndFalse) {
            BlockState currentState;
            BlockPos currentPos = BeltBlock.nextSegmentPosition(state, pos, forward);
            if (currentPos == null || !(currentState = world.getBlockState(currentPos)).is((Block)AllBlocks.BELT)) continue;
            boolean hasPulley = false;
            BlockEntity blockEntity = world.getBlockEntity(currentPos);
            if (blockEntity instanceof BeltBlockEntity) {
                BeltBlockEntity belt = (BeltBlockEntity)blockEntity;
                if (belt.isController()) {
                    belt.getInventory().ejectAll();
                }
                hasPulley = belt.hasPulley();
            }
            world.removeBlockEntity(currentPos);
            BlockState shaftState = (BlockState)AllBlocks.SHAFT.defaultBlockState().setValue((Property)BlockStateProperties.AXIS, (Comparable)this.getRotationAxis(currentState));
            world.setBlock(currentPos, ProperWaterloggedBlock.withWater((LevelReader)world, hasPulley ? shaftState : Blocks.AIR.defaultBlockState(), currentPos), 3);
            world.levelEvent(2001, currentPos, Block.getId((BlockState)currentState));
        }
    }

    public BlockState updateShape(BlockState state, LevelReader world, ScheduledTickAccess tickView, BlockPos pos, Direction side, BlockPos p_196271_6_, BlockState p_196271_3_, RandomSource random) {
        this.updateWater(world, tickView, state, pos);
        if (side.getAxis().isHorizontal()) {
            this.updateTunnelConnections((LevelAccessor)world, pos.above());
        }
        if (side == Direction.UP) {
            this.updateCoverProperty(world, pos, state);
        }
        return state;
    }

    public void updateCoverProperty(LevelReader world, BlockPos pos, BlockState state) {
        if (world.isClientSide()) {
            return;
        }
        if (((Boolean)state.getValue((Property)CASING)).booleanValue() && state.getValue(SLOPE) == BeltSlope.HORIZONTAL) {
            this.withBlockEntityDo((BlockGetter)world, pos, bbe -> bbe.setCovered(BeltBlock.isBlockCoveringBelt(world, pos.above())));
        }
    }

    public static boolean isBlockCoveringBelt(LevelReader world, BlockPos pos) {
        BlockState blockState = world.getBlockState(pos);
        VoxelShape collisionShape = blockState.getCollisionShape((BlockGetter)world, pos);
        if (collisionShape.isEmpty()) {
            return false;
        }
        AABB bounds = collisionShape.bounds();
        if (bounds.getXsize() < 0.5 || bounds.getZsize() < 0.5) {
            return false;
        }
        if (bounds.minY > 0.0) {
            return false;
        }
        if (blockState.is((Block)AllBlocks.CRUSHING_WHEEL_CONTROLLER)) {
            return false;
        }
        if (FunnelBlock.isFunnel(blockState) && FunnelBlock.getFunnelFacing(blockState) != Direction.UP) {
            return false;
        }
        return !(blockState.getBlock() instanceof BeltTunnelBlock);
    }

    private void updateTunnelConnections(LevelAccessor world, BlockPos pos) {
        Block tunnelBlock = world.getBlockState(pos).getBlock();
        if (tunnelBlock instanceof BeltTunnelBlock) {
            ((BeltTunnelBlock)tunnelBlock).updateTunnel(world, pos);
        }
    }

    public static List<BlockPos> getBeltChain(LevelReader world, BlockPos controllerPos) {
        BlockState state;
        LinkedList<BlockPos> positions = new LinkedList<BlockPos>();
        BlockState blockState = world.getBlockState(controllerPos);
        if (!blockState.is((Block)AllBlocks.BELT)) {
            return positions;
        }
        int limit = 1000;
        BlockPos current = controllerPos;
        while (limit-- > 0 && current != null && (state = world.getBlockState(current)).is((Block)AllBlocks.BELT)) {
            positions.add(current);
            current = BeltBlock.nextSegmentPosition(state, current, true);
        }
        return positions;
    }

    public static BlockPos nextSegmentPosition(BlockState state, BlockPos pos, boolean forward) {
        int offset;
        Direction direction = (Direction)state.getValue((Property)HORIZONTAL_FACING);
        BeltSlope slope = (BeltSlope)((Object)state.getValue(SLOPE));
        BeltPart part = (BeltPart)((Object)state.getValue(PART));
        int n = offset = forward ? 1 : -1;
        if (part == BeltPart.END && forward || part == BeltPart.START && !forward) {
            return null;
        }
        if (slope == BeltSlope.VERTICAL) {
            return pos.above(direction.getAxisDirection() == Direction.AxisDirection.POSITIVE ? offset : -offset);
        }
        pos = pos.relative(direction, offset);
        if (slope != BeltSlope.HORIZONTAL && slope != BeltSlope.SIDEWAYS) {
            return pos.above(slope == BeltSlope.UPWARD ? offset : -offset);
        }
        return pos;
    }

    @Override
    public Class<BeltBlockEntity> getBlockEntityClass() {
        return BeltBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends BeltBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.BELT;
    }

    @Override
    public ItemRequirement getRequiredItems(BlockState state, BlockEntity be) {
        ArrayList<ItemStack> required = new ArrayList<ItemStack>();
        if (state.getValue(PART) != BeltPart.MIDDLE) {
            required.add(AllItems.SHAFT.getDefaultInstance());
        }
        if (state.getValue(PART) == BeltPart.START) {
            required.add(AllItems.BELT_CONNECTOR.getDefaultInstance());
        }
        if (required.isEmpty()) {
            return ItemRequirement.NONE;
        }
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, required);
    }

    @Override
    public BlockState rotate(BlockState state, Rotation rot) {
        BlockState rotate = super.rotate(state, rot);
        if (state.getValue(SLOPE) != BeltSlope.VERTICAL) {
            return rotate;
        }
        if (((Direction)state.getValue((Property)HORIZONTAL_FACING)).getAxisDirection() != ((Direction)rotate.getValue((Property)HORIZONTAL_FACING)).getAxisDirection()) {
            if (state.getValue(PART) == BeltPart.START) {
                return (BlockState)rotate.setValue(PART, (Comparable)((Object)BeltPart.END));
            }
            if (state.getValue(PART) == BeltPart.END) {
                return (BlockState)rotate.setValue(PART, (Comparable)((Object)BeltPart.START));
            }
        }
        return rotate;
    }

    @Override
    public BlockState transform(BlockState state, StructureTransform transform) {
        if (transform.mirror != null) {
            state = this.mirror(state, transform.mirror);
        }
        if (transform.rotationAxis == Direction.Axis.Y) {
            return this.rotate(state, transform.rotation);
        }
        return this.transformInner(state, transform);
    }

    protected BlockState transformInner(BlockState state, StructureTransform transform) {
        boolean diagonal;
        boolean halfTurn = transform.rotation == Rotation.CLOCKWISE_180;
        Direction initialDirection = (Direction)state.getValue((Property)HORIZONTAL_FACING);
        boolean bl = diagonal = state.getValue(SLOPE) == BeltSlope.DOWNWARD || state.getValue(SLOPE) == BeltSlope.UPWARD;
        if (!diagonal) {
            for (int i = 0; i < transform.rotation.ordinal(); ++i) {
                Direction direction = (Direction)state.getValue((Property)HORIZONTAL_FACING);
                BeltSlope slope = (BeltSlope)((Object)state.getValue(SLOPE));
                boolean vertical = slope == BeltSlope.VERTICAL;
                boolean horizontal = slope == BeltSlope.HORIZONTAL;
                boolean sideways = slope == BeltSlope.SIDEWAYS;
                Direction newDirection = direction.getOpposite();
                BeltSlope newSlope = BeltSlope.VERTICAL;
                if (vertical) {
                    if (direction.getAxis() == transform.rotationAxis) {
                        newDirection = direction.getCounterClockWise();
                        newSlope = BeltSlope.SIDEWAYS;
                    } else {
                        newSlope = BeltSlope.HORIZONTAL;
                        newDirection = direction;
                        if (direction.getAxis() == Direction.Axis.Z) {
                            newDirection = direction.getOpposite();
                        }
                    }
                }
                if (sideways) {
                    newDirection = direction;
                    if (direction.getAxis() == transform.rotationAxis) {
                        newSlope = BeltSlope.HORIZONTAL;
                    } else {
                        newDirection = direction.getCounterClockWise();
                    }
                }
                if (horizontal) {
                    newDirection = direction;
                    if (direction.getAxis() == transform.rotationAxis) {
                        newSlope = BeltSlope.SIDEWAYS;
                    } else if (direction.getAxis() != Direction.Axis.Z) {
                        newDirection = direction.getOpposite();
                    }
                }
                state = (BlockState)state.setValue((Property)HORIZONTAL_FACING, (Comparable)newDirection);
                state = (BlockState)state.setValue(SLOPE, (Comparable)((Object)newSlope));
            }
        } else if (initialDirection.getAxis() != transform.rotationAxis) {
            for (int i = 0; i < transform.rotation.ordinal(); ++i) {
                Direction direction = (Direction)state.getValue((Property)HORIZONTAL_FACING);
                Direction newDirection = direction.getOpposite();
                BeltSlope slope = (BeltSlope)((Object)state.getValue(SLOPE));
                boolean upward = slope == BeltSlope.UPWARD;
                boolean downward = slope == BeltSlope.DOWNWARD;
                state = direction.getAxisDirection() == Direction.AxisDirection.POSITIVE ^ downward ^ direction.getAxis() == Direction.Axis.Z ? (BlockState)state.setValue(SLOPE, (Comparable)((Object)(upward ? BeltSlope.DOWNWARD : BeltSlope.UPWARD))) : (BlockState)state.setValue((Property)HORIZONTAL_FACING, (Comparable)newDirection);
            }
        } else if (halfTurn) {
            boolean vertical;
            Direction direction = (Direction)state.getValue((Property)HORIZONTAL_FACING);
            Direction newDirection = direction.getOpposite();
            BeltSlope slope = (BeltSlope)((Object)state.getValue(SLOPE));
            boolean bl2 = vertical = slope == BeltSlope.VERTICAL;
            if (diagonal) {
                state = (BlockState)state.setValue(SLOPE, (Comparable)((Object)(slope == BeltSlope.UPWARD ? BeltSlope.DOWNWARD : (slope == BeltSlope.DOWNWARD ? BeltSlope.UPWARD : slope))));
            } else if (vertical) {
                state = (BlockState)state.setValue((Property)HORIZONTAL_FACING, (Comparable)newDirection);
            }
        }
        return state;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public FluidState getFluidState(BlockState pState) {
        return this.fluidState(pState);
    }
}

