/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.belt;

import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.kinetics.belt.BeltBlock;
import com.zurrtum.create.content.kinetics.belt.BeltBlockEntity;
import com.zurrtum.create.content.kinetics.belt.BeltSlope;
import com.zurrtum.create.foundation.fluid.FluidHelper;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class BeltHelper {
    public static Map<Item, Boolean> uprightCache = new Object2BooleanOpenHashMap();
    public static final ResourceManagerReloadListener LISTENER = resourceManager -> uprightCache.clear();

    public static boolean isItemUpright(ItemStack stack) {
        return uprightCache.computeIfAbsent(stack.getItem(), item -> (FluidHelper.hasFluidInventory(stack) || stack.is(AllItemTags.UPRIGHT_ON_BELT)) && !stack.is(AllItemTags.NOT_UPRIGHT_ON_BELT));
    }

    public static BeltBlockEntity getSegmentBE(LevelAccessor world, BlockPos pos) {
        Level l;
        if (world instanceof Level && !(l = (Level)world).isLoaded(pos)) {
            return null;
        }
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (!(blockEntity instanceof BeltBlockEntity)) {
            return null;
        }
        return (BeltBlockEntity)blockEntity;
    }

    public static BeltBlockEntity getControllerBE(LevelAccessor world, BlockPos pos) {
        BeltBlockEntity segment = BeltHelper.getSegmentBE(world, pos);
        if (segment == null) {
            return null;
        }
        BlockPos controllerPos = segment.controller;
        if (controllerPos == null) {
            return null;
        }
        return BeltHelper.getSegmentBE(world, controllerPos);
    }

    public static BeltBlockEntity getBeltForOffset(BeltBlockEntity controller, float offset) {
        return BeltHelper.getBeltAtSegment(controller, (int)Math.floor(offset));
    }

    public static BeltBlockEntity getBeltAtSegment(BeltBlockEntity controller, int segment) {
        BlockPos pos = BeltHelper.getPositionForOffset(controller, segment);
        BlockEntity be = controller.getLevel().getBlockEntity(pos);
        if (be == null || !(be instanceof BeltBlockEntity)) {
            return null;
        }
        return (BeltBlockEntity)be;
    }

    public static BlockPos getPositionForOffset(BeltBlockEntity controller, int offset) {
        BlockPos pos = controller.getBlockPos();
        Vec3i vec = controller.getBeltFacing().getUnitVec3i();
        BeltSlope slope = (BeltSlope)((Object)controller.getBlockState().getValue(BeltBlock.SLOPE));
        int verticality = slope == BeltSlope.DOWNWARD ? -1 : (slope == BeltSlope.UPWARD ? 1 : 0);
        return pos.offset(offset * vec.getX(), Mth.clamp((int)offset, (int)0, (int)(controller.beltLength - 1)) * verticality, offset * vec.getZ());
    }

    public static Vec3 getVectorForOffset(BeltBlockEntity controller, float offset) {
        float verticalMovement;
        BeltSlope slope = (BeltSlope)((Object)controller.getBlockState().getValue(BeltBlock.SLOPE));
        float f = slope == BeltSlope.DOWNWARD ? -1.0f : (verticalMovement = slope == BeltSlope.UPWARD ? 1.0f : 0.0f);
        if ((double)offset < 0.5) {
            verticalMovement = 0.0f;
        }
        verticalMovement *= Math.min(offset, (float)controller.beltLength - 0.5f) - 0.5f;
        Vec3 vec = VecHelper.getCenterOf((Vec3i)controller.getBlockPos());
        Vec3 horizontalMovement = Vec3.atLowerCornerOf((Vec3i)controller.getBeltFacing().getUnitVec3i()).scale((double)(offset - 0.5f));
        if (slope == BeltSlope.VERTICAL) {
            horizontalMovement = Vec3.ZERO;
        }
        vec = vec.add(horizontalMovement).add(0.0, (double)verticalMovement, 0.0);
        return vec;
    }

    public static Vec3 getVectorForOffset(BlockPos pos, BeltSlope slope, int verticality, int beltLength, Vec3i directionVec, float offset) {
        float verticalMovement = verticality;
        if ((double)offset < 0.5) {
            verticalMovement = 0.0f;
        }
        verticalMovement *= Math.min(offset, (float)beltLength - 0.5f) - 0.5f;
        Vec3 vec = VecHelper.getCenterOf((Vec3i)pos);
        Vec3 horizontalMovement = Vec3.atLowerCornerOf((Vec3i)directionVec).scale((double)(offset - 0.5f));
        if (slope == BeltSlope.VERTICAL) {
            horizontalMovement = Vec3.ZERO;
        }
        vec = vec.add(horizontalMovement).add(0.0, (double)verticalMovement, 0.0);
        return vec;
    }

    public static Vec3 getBeltVector(BlockState state) {
        BeltSlope slope = (BeltSlope)((Object)state.getValue(BeltBlock.SLOPE));
        int verticality = slope == BeltSlope.DOWNWARD ? -1 : (slope == BeltSlope.UPWARD ? 1 : 0);
        Vec3 horizontalMovement = Vec3.atLowerCornerOf((Vec3i)((Direction)state.getValue((Property)BeltBlock.HORIZONTAL_FACING)).getUnitVec3i());
        if (slope == BeltSlope.VERTICAL) {
            return new Vec3(0.0, (double)((Direction)state.getValue((Property)BeltBlock.HORIZONTAL_FACING)).getAxisDirection().getStep(), 0.0);
        }
        return new Vec3(0.0, (double)verticality, 0.0).add(horizontalMovement);
    }
}

