/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.belt.transport;

import com.zurrtum.create.content.kinetics.belt.transport.BeltInventory;
import com.zurrtum.create.content.kinetics.belt.transport.TransportedItemStack;
import com.zurrtum.create.infrastructure.items.ItemInventory;
import net.minecraft.world.item.ItemStack;

public class ItemHandlerBeltSegment
implements ItemInventory {
    private final BeltInventory beltInventory;
    private final int offset;

    public ItemHandlerBeltSegment(BeltInventory beltInventory, int offset) {
        this.beltInventory = beltInventory;
        this.offset = offset;
    }

    public int getContainerSize() {
        return 1;
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        return this.beltInventory.canInsertAt(this.offset);
    }

    @Override
    public boolean isEmpty() {
        TransportedItemStack transported = this.beltInventory.getStackAtOffset(this.offset);
        return transported == null || transported.stack.isEmpty();
    }

    public ItemStack getItem(int slot) {
        if (slot != 0) {
            return ItemStack.EMPTY;
        }
        TransportedItemStack stackAtOffset = this.beltInventory.getStackAtOffset(this.offset);
        if (stackAtOffset == null) {
            return ItemStack.EMPTY;
        }
        return stackAtOffset.stack;
    }

    @Override
    public ItemStack removeItem(int slot, int amount) {
        if (slot != 0) {
            return ItemStack.EMPTY;
        }
        TransportedItemStack transported = this.beltInventory.getStackAtOffset(this.offset);
        if (transported == null) {
            return ItemStack.EMPTY;
        }
        amount = Math.min(amount, transported.stack.getCount());
        ItemStack extracted = transported.stack.split(amount);
        if (transported.stack.isEmpty()) {
            this.beltInventory.toRemove.add(transported);
        } else {
            this.setChanged();
        }
        return extracted;
    }

    @Override
    public ItemStack removeItemNoUpdate(int slot) {
        if (slot != 0) {
            return ItemStack.EMPTY;
        }
        TransportedItemStack transported = this.beltInventory.getStackAtOffset(this.offset);
        if (transported == null) {
            return ItemStack.EMPTY;
        }
        this.beltInventory.toRemove.add(transported);
        ItemStack stack = transported.stack;
        transported.stack = ItemStack.EMPTY;
        return stack;
    }

    public void setItem(int slot, ItemStack stack) {
        if (slot != 0) {
            return;
        }
        if (stack.isEmpty()) {
            TransportedItemStack transported = this.beltInventory.getStackAtOffset(this.offset);
            if (transported == null || transported.stack.isEmpty()) {
                return;
            }
            this.beltInventory.toRemove.add(transported);
            transported.stack = stack;
        } else {
            TransportedItemStack newStack = new TransportedItemStack(stack);
            newStack.insertedAt = this.offset;
            newStack.prevBeltPosition = newStack.beltPosition = (float)this.offset + 0.5f + (float)(this.beltInventory.beltMovementPositive ? -1 : 1) / 16.0f;
            this.beltInventory.addItem(newStack);
        }
    }

    @Override
    public void setChanged() {
        this.beltInventory.belt.notifyUpdate();
    }

    public int getMaxStackSize(ItemStack stack) {
        return Math.min(stack.getMaxStackSize(), 64);
    }
}

