/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.chainDrive;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class ChainGearshiftBlockEntity
extends KineticBlockEntity {
    int signal = 0;
    boolean signalChanged;

    public ChainGearshiftBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.ADJUSTABLE_CHAIN_GEARSHIFT, pos, state);
        this.setLazyTickRate(40);
    }

    @Override
    public void write(ValueOutput view, boolean clientPacket) {
        view.putInt("Signal", this.signal);
        super.write(view, clientPacket);
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        this.signal = view.getIntOr("Signal", 0);
        super.read(view, clientPacket);
    }

    public float getModifier() {
        return this.getModifierForSignal(this.signal);
    }

    public void neighbourChanged() {
        if (!this.hasLevel()) {
            return;
        }
        int power = this.level.getBestNeighborSignal(this.worldPosition);
        if (power != this.signal) {
            this.signalChanged = true;
        }
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        this.neighbourChanged();
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level.isClientSide()) {
            return;
        }
        if (this.signalChanged) {
            this.signalChanged = false;
            this.analogSignalChanged(this.level.getBestNeighborSignal(this.worldPosition));
        }
    }

    protected void analogSignalChanged(int newSignal) {
        this.detachKinetics();
        this.removeSource();
        this.signal = newSignal;
        this.attachKinetics();
    }

    protected float getModifierForSignal(int newPower) {
        if (newPower == 0) {
            return 1.0f;
        }
        return 1.0f + (float)(newPower + 1) / 16.0f;
    }
}

