/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.crafter;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.kinetics.base.HorizontalKineticBlock;
import com.zurrtum.create.content.kinetics.crafter.CrafterHelper;
import com.zurrtum.create.content.kinetics.crafter.MechanicalCrafterBlock;
import com.zurrtum.create.content.kinetics.crafter.MechanicalCrafterBlockEntity;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import com.zurrtum.create.infrastructure.items.SidedItemInventory;
import com.zurrtum.create.infrastructure.transfer.SlotRangeCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.Nullable;

public class ConnectedInputHandler {
    public static boolean shouldConnect(Level world, BlockPos pos, Direction face, Direction direction) {
        BlockState refState = world.getBlockState(pos);
        if (!refState.hasProperty(HorizontalKineticBlock.HORIZONTAL_FACING)) {
            return false;
        }
        Direction refDirection = (Direction)refState.getValue(HorizontalKineticBlock.HORIZONTAL_FACING);
        if (direction.getAxis() == refDirection.getAxis()) {
            return false;
        }
        if (face == refDirection) {
            return false;
        }
        BlockState neighbour = world.getBlockState(pos.relative(direction));
        if (!neighbour.is((Block)AllBlocks.MECHANICAL_CRAFTER)) {
            return false;
        }
        return refDirection == neighbour.getValue(HorizontalKineticBlock.HORIZONTAL_FACING);
    }

    public static void toggleConnection(Level world, BlockPos pos, BlockPos pos2) {
        BlockPos controllerPos2;
        MechanicalCrafterBlockEntity crafter1 = CrafterHelper.getCrafter((BlockAndTintGetter)world, pos);
        MechanicalCrafterBlockEntity crafter2 = CrafterHelper.getCrafter((BlockAndTintGetter)world, pos2);
        if (crafter1 == null || crafter2 == null) {
            return;
        }
        BlockPos controllerPos1 = crafter1.getBlockPos().offset((Vec3i)crafter1.input.data.getFirst());
        if (controllerPos1.equals((Object)(controllerPos2 = crafter2.getBlockPos().offset((Vec3i)crafter2.input.data.getFirst())))) {
            MechanicalCrafterBlockEntity controller = CrafterHelper.getCrafter((BlockAndTintGetter)world, controllerPos1);
            Set<BlockPos> positions = controller.input.data.stream().map(arg_0 -> ((BlockPos)controllerPos1).offset(arg_0)).collect(Collectors.toSet());
            LinkedList<BlockPos> frontier = new LinkedList<BlockPos>();
            ArrayList<BlockPos> splitGroup = new ArrayList<BlockPos>();
            frontier.add(pos2);
            positions.remove(pos2);
            positions.remove(pos);
            while (!frontier.isEmpty()) {
                BlockPos current = (BlockPos)frontier.removeFirst();
                for (Direction direction : Iterate.directions) {
                    BlockPos next = current.relative(direction);
                    if (!positions.remove(next)) continue;
                    splitGroup.add(next);
                    frontier.add(next);
                }
            }
            ConnectedInputHandler.initAndAddAll(world, crafter1, positions);
            ConnectedInputHandler.initAndAddAll(world, crafter2, splitGroup);
            crafter1.setChanged();
            crafter1.connectivityChanged();
            crafter2.setChanged();
            crafter2.connectivityChanged();
            return;
        }
        if (!crafter1.input.isController) {
            crafter1 = CrafterHelper.getCrafter((BlockAndTintGetter)world, controllerPos1);
        }
        if (!crafter2.input.isController) {
            crafter2 = CrafterHelper.getCrafter((BlockAndTintGetter)world, controllerPos2);
        }
        if (crafter1 == null || crafter2 == null) {
            return;
        }
        ConnectedInputHandler.connectControllers(world, crafter1, crafter2);
        world.setBlock(crafter1.getBlockPos(), crafter1.getBlockState(), 3);
        crafter1.setChanged();
        crafter1.connectivityChanged();
        crafter2.setChanged();
        crafter2.connectivityChanged();
    }

    public static void initAndAddAll(Level world, MechanicalCrafterBlockEntity crafter, Collection<BlockPos> positions) {
        crafter.input = new ConnectedInput();
        positions.forEach(splitPos -> ConnectedInputHandler.modifyAndUpdate(world, splitPos, input -> {
            input.attachTo(crafter.getBlockPos(), (BlockPos)splitPos);
            crafter.input.data.add(splitPos.subtract((Vec3i)crafter.getBlockPos()));
        }));
    }

    public static void connectControllers(Level world, MechanicalCrafterBlockEntity crafter1, MechanicalCrafterBlockEntity crafter2) {
        crafter1.input.data.forEach(offset -> {
            BlockPos connectedPos = crafter1.getBlockPos().offset((Vec3i)offset);
            ConnectedInputHandler.modifyAndUpdate(world, connectedPos, input -> {});
        });
        crafter2.input.data.forEach(offset -> {
            if (offset.equals((Object)BlockPos.ZERO)) {
                return;
            }
            BlockPos connectedPos = crafter2.getBlockPos().offset((Vec3i)offset);
            ConnectedInputHandler.modifyAndUpdate(world, connectedPos, input -> {
                input.attachTo(crafter1.getBlockPos(), connectedPos);
                crafter1.input.data.add(BlockPos.ZERO.subtract((Vec3i)input.data.getFirst()));
            });
        });
        crafter2.input.attachTo(crafter1.getBlockPos(), crafter2.getBlockPos());
        crafter1.input.data.add(BlockPos.ZERO.subtract((Vec3i)crafter2.input.data.getFirst()));
    }

    private static void modifyAndUpdate(Level world, BlockPos pos, Consumer<ConnectedInput> callback) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (!(blockEntity instanceof MechanicalCrafterBlockEntity)) {
            return;
        }
        MechanicalCrafterBlockEntity crafter = (MechanicalCrafterBlockEntity)blockEntity;
        callback.accept(crafter.input);
        crafter.setChanged();
        crafter.connectivityChanged();
    }

    public static class ConnectedInput {
        private static final Comparator<BlockPos> Y_COMPARATOR = Comparator.comparingInt(Vec3i::getY).reversed();
        private static final Comparator<BlockPos> NORTH_COMPARATOR = Y_COMPARATOR.thenComparing(Comparator.comparingInt(Vec3i::getX).reversed());
        private static final Comparator<BlockPos> SOUTH_COMPARATOR = Y_COMPARATOR.thenComparingInt(Vec3i::getX);
        private static final Comparator<BlockPos> EAST_COMPARATOR = Y_COMPARATOR.thenComparing(Comparator.comparingInt(Vec3i::getZ).reversed());
        private static final Comparator<BlockPos> WEST_COMPARATOR = Y_COMPARATOR.thenComparingInt(Vec3i::getZ);
        boolean isController = true;
        List<BlockPos> data = Collections.synchronizedList(new ArrayList());

        public ConnectedInput() {
            this.data.add(BlockPos.ZERO);
        }

        public void attachTo(BlockPos controllerPos, BlockPos myPos) {
            this.isController = false;
            this.data.clear();
            this.data.add(controllerPos.subtract((Vec3i)myPos));
        }

        public Container getItemHandler(Level world, BlockPos pos) {
            return new ConnectedInventory(this.getInventories(world, pos));
        }

        public MechanicalCrafterBlockEntity.CrafterItemHandler[] getInventories(Level world, BlockPos pos) {
            if (!this.isController) {
                BlockPos controllerPos = pos.offset((Vec3i)this.data.getFirst());
                ConnectedInput input = CrafterHelper.getInput((BlockAndTintGetter)world, controllerPos);
                if (input == this || input == null || !input.isController) {
                    return new MechanicalCrafterBlockEntity.CrafterItemHandler[0];
                }
                return input.getInventories(world, controllerPos);
            }
            Comparator<BlockPos> invOrdering = switch ((Direction)world.getBlockState(pos).getValueOrElse((Property)MechanicalCrafterBlock.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)) {
                case Direction.NORTH -> NORTH_COMPARATOR;
                case Direction.EAST -> EAST_COMPARATOR;
                case Direction.WEST -> WEST_COMPARATOR;
                default -> SOUTH_COMPARATOR;
            };
            return (MechanicalCrafterBlockEntity.CrafterItemHandler[])this.data.stream().sorted(invOrdering).map(l -> CrafterHelper.getCrafter((BlockAndTintGetter)world, pos.offset((Vec3i)l))).filter(Objects::nonNull).map(MechanicalCrafterBlockEntity::getInventory).toArray(MechanicalCrafterBlockEntity.CrafterItemHandler[]::new);
        }

        public void write(ValueOutput view) {
            view.putBoolean("Controller", this.isController);
            view.store("Data", CreateCodecs.BLOCK_POS_LIST_CODEC, this.data);
        }

        public void read(ValueInput view) {
            this.isController = view.getBooleanOr("Controller", false);
            this.data.clear();
            view.read("Data", CreateCodecs.BLOCK_POS_LIST_CODEC).ifPresent(this.data::addAll);
            if (this.data.isEmpty()) {
                this.isController = true;
                this.data.add(BlockPos.ZERO);
            }
        }
    }

    private static class ConnectedInventory
    implements SidedItemInventory {
        private final MechanicalCrafterBlockEntity.CrafterItemHandler[] itemHandler;
        private final int[] slots;
        private final int size;

        private ConnectedInventory(MechanicalCrafterBlockEntity.CrafterItemHandler[] itemHandler) {
            this.itemHandler = itemHandler;
            this.size = itemHandler.length;
            this.slots = SlotRangeCache.get(this.size);
        }

        public int[] getSlotsForFace(Direction side) {
            return this.slots;
        }

        public boolean canPlaceItemThroughFace(int slot, ItemStack stack, @Nullable Direction dir) {
            return this.itemHandler[slot].canPlaceItemThroughFace(0, stack, dir);
        }

        public boolean canTakeItemThroughFace(int slot, ItemStack stack, Direction dir) {
            return false;
        }

        public ItemStack onExtract(ItemStack stack) {
            return this.removeMaxSize(stack, MechanicalCrafterBlockEntity.CrafterItemHandler.LIMIT);
        }

        public int getMaxStackSize() {
            return 1;
        }

        public int getContainerSize() {
            return this.size;
        }

        public ItemStack getItem(int slot) {
            if (slot >= this.size) {
                return ItemStack.EMPTY;
            }
            return this.itemHandler[slot].getStack();
        }

        public void setItem(int slot, ItemStack stack) {
            if (slot >= this.size) {
                return;
            }
            MechanicalCrafterBlockEntity.CrafterItemHandler handler = this.itemHandler[slot];
            handler.setStack(stack);
            handler.setChanged();
        }
    }
}

