/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.crafter;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.api.contraption.transformable.TransformableBlockEntity;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.catnip.math.BlockFace;
import com.zurrtum.create.catnip.math.Pointing;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.contraptions.StructureTransform;
import com.zurrtum.create.content.kinetics.base.HorizontalKineticBlock;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.zurrtum.create.content.kinetics.crafter.ConnectedInputHandler;
import com.zurrtum.create.content.kinetics.crafter.MechanicalCrafterBlock;
import com.zurrtum.create.content.kinetics.crafter.RecipeGridHandler;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.edgeInteraction.EdgeInteractionBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import com.zurrtum.create.infrastructure.items.SidedItemInventory;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class MechanicalCrafterBlockEntity
extends KineticBlockEntity
implements TransformableBlockEntity {
    protected CrafterItemHandler inventory;
    public RecipeGridHandler.GroupedItems groupedItems = new RecipeGridHandler.GroupedItems();
    protected ConnectedInputHandler.ConnectedInput input = new ConnectedInputHandler.ConnectedInput();
    @Nullable
    protected Container invCap;
    protected boolean reRender;
    public Phase phase;
    public int countDown;
    public boolean covered;
    protected boolean wasPoweredBefore;
    public RecipeGridHandler.GroupedItems groupedItemsBeforeCraft;
    private InvManipulationBehaviour inserting;
    private ItemStack scriptedResult = ItemStack.EMPTY;

    public MechanicalCrafterBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.MECHANICAL_CRAFTER, pos, state);
        this.setLazyTickRate(20);
        this.phase = Phase.IDLE;
        this.groupedItemsBeforeCraft = new RecipeGridHandler.GroupedItems();
        this.inventory = new CrafterItemHandler();
        this.wasPoweredBefore = true;
    }

    public Container getInvCapability() {
        if (this.invCap == null) {
            this.invCap = this.input.getItemHandler(this.getLevel(), this.getBlockPos());
        }
        return this.invCap;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        super.addBehaviours(behaviours);
        this.inserting = new InvManipulationBehaviour(this, this::getTargetFace);
        behaviours.add(this.inserting);
        behaviours.add(new EdgeInteractionBehaviour(this, ConnectedInputHandler::toggleConnection).connectivity(ConnectedInputHandler::shouldConnect).require(item -> item.builtInRegistryHolder().is(AllItemTags.TOOLS_WRENCH)));
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.CRAFTER, AllAdvancements.CRAFTER_LAZY);
    }

    @Override
    public void onSpeedChanged(float previousSpeed) {
        super.onSpeedChanged(previousSpeed);
        if (!Mth.equal((float)this.getSpeed(), (float)0.0f)) {
            this.award(AllAdvancements.CRAFTER);
            if (Math.abs(this.getSpeed()) < 5.0f) {
                this.award(AllAdvancements.CRAFTER_LAZY);
            }
        }
    }

    public void blockChanged() {
        this.removeBehaviour(InvManipulationBehaviour.TYPE);
        this.inserting = new InvManipulationBehaviour(this, this::getTargetFace);
        this.attachBehaviourLate(this.inserting);
    }

    public BlockFace getTargetFace(Level world, BlockPos pos, BlockState state) {
        return new BlockFace(pos, MechanicalCrafterBlock.getTargetDirection(state));
    }

    public Direction getTargetDirection() {
        return MechanicalCrafterBlock.getTargetDirection(this.getBlockState());
    }

    @Override
    public void writeSafe(ValueOutput view) {
        super.writeSafe(view);
        if (this.input == null) {
            return;
        }
        this.input.write(view.child("ConnectedInput"));
    }

    @Override
    public void write(ValueOutput view, boolean clientPacket) {
        this.inventory.write(view);
        this.input.write(view.child("ConnectedInput"));
        if (this.groupedItemsBeforeCraft != null) {
            view.store("GroupedItemsBeforeCraft", RecipeGridHandler.GroupedItems.CODEC, (Object)this.groupedItemsBeforeCraft);
            this.groupedItemsBeforeCraft = null;
        }
        view.store("GroupedItems", RecipeGridHandler.GroupedItems.CODEC, (Object)this.groupedItems);
        view.putString("Phase", this.phase.name());
        view.putInt("CountDown", this.countDown);
        view.putBoolean("Cover", this.covered);
        super.write(view, clientPacket);
        if (clientPacket && this.reRender) {
            view.putBoolean("Redraw", true);
            this.reRender = false;
        }
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        Phase phaseBefore = this.phase;
        RecipeGridHandler.GroupedItems before = this.groupedItems;
        this.inventory.read(view);
        this.input.read(view.childOrEmpty("ConnectedInput"));
        this.groupedItems = (RecipeGridHandler.GroupedItems)view.read("GroupedItems", RecipeGridHandler.GroupedItems.CODEC).orElseThrow();
        this.phase = Phase.IDLE;
        String name = view.getStringOr("Phase", "");
        for (Phase phase : Phase.values()) {
            if (!phase.name().equals(name)) continue;
            this.phase = phase;
        }
        this.countDown = view.getIntOr("CountDown", 0);
        this.covered = view.getBooleanOr("Cover", false);
        super.read(view, clientPacket);
        if (!clientPacket) {
            return;
        }
        if (view.getBooleanOr("Redraw", false)) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 16);
        }
        if (phaseBefore != this.phase && this.phase == Phase.CRAFTING) {
            this.groupedItemsBeforeCraft = view.read("GroupedItemsBeforeCraft", RecipeGridHandler.GroupedItems.CODEC).orElse(before);
        }
        if (phaseBefore == Phase.EXPORTING && this.phase == Phase.WAITING) {
            if (before.onlyEmptyItems()) {
                return;
            }
            Direction facing = (Direction)this.getBlockState().getValue((Property)MechanicalCrafterBlock.HORIZONTAL_FACING);
            Vec3 vec = Vec3.atLowerCornerOf((Vec3i)facing.getUnitVec3i()).scale(0.75).add(VecHelper.getCenterOf((Vec3i)this.worldPosition));
            Direction targetDirection = MechanicalCrafterBlock.getTargetDirection(this.getBlockState());
            vec = vec.add(Vec3.atLowerCornerOf((Vec3i)targetDirection.getUnitVec3i()).scale(1.0));
            this.level.addParticle((ParticleOptions)ParticleTypes.CRIT, vec.x, vec.y, vec.z, 0.0, 0.0, 0.0);
        }
    }

    public int getCountDownSpeed() {
        if (this.getSpeed() == 0.0f) {
            return 0;
        }
        return Mth.clamp((int)((int)Math.abs(this.getSpeed())), (int)4, (int)250);
    }

    @Override
    public void tick() {
        boolean runLogic;
        super.tick();
        if (this.phase == Phase.ACCEPTING) {
            return;
        }
        boolean onClient = this.level.isClientSide();
        boolean bl = runLogic = !onClient || this.isVirtual();
        if (this.wasPoweredBefore != this.level.hasNeighborSignal(this.worldPosition)) {
            this.wasPoweredBefore = this.level.hasNeighborSignal(this.worldPosition);
            if (this.wasPoweredBefore) {
                if (!runLogic) {
                    return;
                }
                this.checkCompletedRecipe(true);
            }
        }
        if (this.phase == Phase.ASSEMBLING) {
            this.countDown -= this.getCountDownSpeed();
            if (this.countDown < 0) {
                ItemStack result;
                this.countDown = 0;
                if (!runLogic) {
                    return;
                }
                if (RecipeGridHandler.getTargetingCrafter(this) != null) {
                    this.phase = Phase.EXPORTING;
                    this.countDown = this.groupedItems.onlyEmptyItems() ? 0 : 1000;
                    this.sendData();
                    return;
                }
                ItemStack itemStack = result = this.isVirtual() ? this.scriptedResult : RecipeGridHandler.tryToApplyRecipe((ServerLevel)this.level, this.groupedItems);
                if (result != null) {
                    ArrayList containers = new ArrayList();
                    this.groupedItems.grid.values().forEach(stack -> {
                        ItemStack remainder = stack.getItem().getCraftingRemainder();
                        if (!remainder.isEmpty()) {
                            containers.add(remainder);
                        }
                    });
                    this.groupedItemsBeforeCraft = this.groupedItems;
                    this.groupedItems = new RecipeGridHandler.GroupedItems(result);
                    for (int i = 0; i < containers.size(); ++i) {
                        ItemStack stack2 = (ItemStack)containers.get(i);
                        RecipeGridHandler.GroupedItems container = new RecipeGridHandler.GroupedItems();
                        container.grid.put(Pair.of(i, 0), stack2);
                        container.mergeOnto(this.groupedItems, Pointing.LEFT);
                    }
                    this.phase = Phase.CRAFTING;
                    this.countDown = 2000;
                    this.sendData();
                    return;
                }
                this.ejectWholeGrid();
                return;
            }
        }
        if (this.phase == Phase.EXPORTING) {
            this.countDown -= this.getCountDownSpeed();
            if (this.countDown < 0) {
                this.countDown = 0;
                if (!runLogic) {
                    return;
                }
                MechanicalCrafterBlockEntity targetingCrafter = RecipeGridHandler.getTargetingCrafter(this);
                if (targetingCrafter == null) {
                    this.ejectWholeGrid();
                    return;
                }
                boolean empty = this.groupedItems.onlyEmptyItems();
                Pointing pointing = (Pointing)((Object)this.getBlockState().getValue(MechanicalCrafterBlock.POINTING));
                this.groupedItems.mergeOnto(targetingCrafter.groupedItems, pointing);
                this.groupedItems = new RecipeGridHandler.GroupedItems();
                float pitch = (float)(targetingCrafter.groupedItems.grid.size() * 1) / 16.0f + 0.5f;
                if (!empty) {
                    AllSoundEvents.CRAFTER_CLICK.playOnServer(this.level, (Vec3i)this.worldPosition, 1.0f, pitch);
                }
                this.phase = Phase.WAITING;
                this.countDown = 0;
                this.sendData();
                targetingCrafter.continueIfAllPrecedingFinished();
                targetingCrafter.sendData();
                return;
            }
        }
        if (this.phase == Phase.CRAFTING) {
            if (onClient) {
                Direction facing = (Direction)this.getBlockState().getValue((Property)MechanicalCrafterBlock.HORIZONTAL_FACING);
                float progress = (float)this.countDown / 2000.0f;
                Vec3 facingVec = Vec3.atLowerCornerOf((Vec3i)facing.getUnitVec3i());
                Vec3 vec = facingVec.scale(0.65).add(VecHelper.getCenterOf((Vec3i)this.worldPosition));
                Vec3 offset = VecHelper.offsetRandomly(Vec3.ZERO, this.level.random, 0.125f).multiply(VecHelper.axisAlingedPlaneOf(facingVec)).normalize().scale((double)(progress * 0.5f)).add(vec);
                if (progress > 0.5f) {
                    this.level.addParticle((ParticleOptions)ParticleTypes.CRIT, offset.x, offset.y, offset.z, 0.0, 0.0, 0.0);
                }
                if (!this.groupedItemsBeforeCraft.grid.isEmpty() && progress < 0.5f && this.groupedItems.grid.containsKey(Pair.of(0, 0))) {
                    ItemStack stack3 = this.groupedItems.grid.get(Pair.of(0, 0));
                    this.groupedItemsBeforeCraft = new RecipeGridHandler.GroupedItems();
                    for (int i = 0; i < 10; ++i) {
                        Vec3 randVec = VecHelper.offsetRandomly(Vec3.ZERO, this.level.random, 0.125f).multiply(VecHelper.axisAlingedPlaneOf(facingVec)).normalize().scale(0.25);
                        Vec3 offset2 = randVec.add(vec);
                        randVec = randVec.scale((double)0.35f);
                        this.level.addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, stack3), offset2.x, offset2.y, offset2.z, randVec.x, randVec.y, randVec.z);
                    }
                }
            }
            int prev = this.countDown;
            this.countDown -= this.getCountDownSpeed();
            if (this.countDown < 1000 && prev >= 1000) {
                AllSoundEvents.CRAFTER_CLICK.playOnServer(this.level, (Vec3i)this.worldPosition, 1.0f, 2.0f);
                AllSoundEvents.CRAFTER_CRAFT.playOnServer(this.level, (Vec3i)this.worldPosition);
            }
            if (this.countDown < 0) {
                this.countDown = 0;
                if (!runLogic) {
                    return;
                }
                this.tryInsert();
                return;
            }
        }
        if (this.phase == Phase.INSERTING && runLogic && this.isTargetingBelt()) {
            this.tryInsert();
        }
    }

    protected boolean isTargetingBelt() {
        DirectBeltInputBehaviour behaviour = this.getTargetingBelt();
        return behaviour != null && behaviour.canInsertFromSide(this.getTargetDirection());
    }

    protected DirectBeltInputBehaviour getTargetingBelt() {
        BlockPos targetPos = this.worldPosition.relative(this.getTargetDirection());
        return BlockEntityBehaviour.get((BlockGetter)this.level, targetPos, DirectBeltInputBehaviour.TYPE);
    }

    public void tryInsert() {
        if (!this.inserting.hasInventory() && !this.isTargetingBelt()) {
            this.ejectWholeGrid();
            return;
        }
        boolean chagedPhase = this.phase != Phase.INSERTING;
        LinkedList<Pair<Integer, Integer>> inserted = new LinkedList<Pair<Integer, Integer>>();
        DirectBeltInputBehaviour behaviour = this.getTargetingBelt();
        for (Map.Entry<Pair<Integer, Integer>, ItemStack> entry : this.groupedItems.grid.entrySet()) {
            ItemStack remainder;
            Pair<Integer, Integer> pair = entry.getKey();
            ItemStack stack = entry.getValue();
            BlockFace face = this.getTargetFace(this.level, this.worldPosition, this.getBlockState());
            ItemStack itemStack = remainder = behaviour == null ? this.inserting.insert(stack.copy()) : behaviour.handleInsertion(stack, face.getFace(), false);
            if (!remainder.isEmpty()) {
                stack.setCount(remainder.getCount());
                continue;
            }
            inserted.add(pair);
        }
        inserted.forEach(this.groupedItems.grid::remove);
        if (this.groupedItems.grid.isEmpty()) {
            this.ejectWholeGrid();
        } else {
            this.phase = Phase.INSERTING;
        }
        if (!inserted.isEmpty() || chagedPhase) {
            this.sendData();
        }
    }

    public void ejectWholeGrid() {
        List<MechanicalCrafterBlockEntity> chain = RecipeGridHandler.getAllCraftersOfChain(this);
        if (chain == null) {
            return;
        }
        chain.forEach(MechanicalCrafterBlockEntity::eject);
    }

    public void eject() {
        BlockState blockState = this.getBlockState();
        boolean present = blockState.is((Block)AllBlocks.MECHANICAL_CRAFTER);
        Vec3 vec = present ? Vec3.atLowerCornerOf((Vec3i)((Direction)blockState.getValue(HorizontalKineticBlock.HORIZONTAL_FACING)).getUnitVec3i()).scale(0.75) : Vec3.ZERO;
        Vec3 ejectPos = VecHelper.getCenterOf((Vec3i)this.worldPosition).add(vec);
        this.groupedItems.grid.forEach((pair, stack) -> this.dropItem(ejectPos, (ItemStack)stack));
        if (!this.inventory.getStack().isEmpty()) {
            this.dropItem(ejectPos, this.inventory.onExtract(this.inventory.getStack()));
        }
        this.phase = Phase.IDLE;
        this.groupedItems = new RecipeGridHandler.GroupedItems();
        this.inventory.setStack(ItemStack.EMPTY);
        this.sendData();
    }

    public void dropItem(Vec3 ejectPos, ItemStack stack) {
        ItemEntity itemEntity = new ItemEntity(this.level, ejectPos.x, ejectPos.y, ejectPos.z, stack);
        itemEntity.setDefaultPickUpDelay();
        this.level.addFreshEntity((Entity)itemEntity);
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.level.isClientSide() && !this.isVirtual()) {
            return;
        }
        if (this.phase == Phase.IDLE && this.craftingItemPresent()) {
            this.checkCompletedRecipe(false);
        }
        if (this.phase == Phase.INSERTING) {
            this.tryInsert();
        }
    }

    public boolean craftingItemPresent() {
        return !this.inventory.getStack().isEmpty();
    }

    public boolean craftingItemOrCoverPresent() {
        return !this.inventory.getStack().isEmpty() || this.covered;
    }

    public void checkCompletedRecipe(boolean poweredStart) {
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (this.level.isClientSide() && !this.isVirtual()) {
            return;
        }
        List<MechanicalCrafterBlockEntity> chain = RecipeGridHandler.getAllCraftersOfChainIf(this, poweredStart ? MechanicalCrafterBlockEntity::craftingItemPresent : MechanicalCrafterBlockEntity::craftingItemOrCoverPresent, poweredStart);
        if (chain == null) {
            return;
        }
        chain.forEach(MechanicalCrafterBlockEntity::begin);
    }

    protected void begin() {
        this.phase = Phase.ACCEPTING;
        this.groupedItems = new RecipeGridHandler.GroupedItems(this.inventory.onExtract(this.inventory.getStack()));
        this.inventory.setStack(ItemStack.EMPTY);
        if (RecipeGridHandler.getPrecedingCrafters(this).isEmpty()) {
            this.phase = Phase.ASSEMBLING;
            this.countDown = 1;
        }
        this.sendData();
    }

    protected void continueIfAllPrecedingFinished() {
        List<MechanicalCrafterBlockEntity> preceding = RecipeGridHandler.getPrecedingCrafters(this);
        for (MechanicalCrafterBlockEntity blockEntity : preceding) {
            if (blockEntity.phase == Phase.WAITING) continue;
            return;
        }
        this.phase = Phase.ASSEMBLING;
        this.countDown = 1;
    }

    public void connectivityChanged() {
        this.reRender = true;
        this.sendData();
        this.invCap = null;
    }

    public CrafterItemHandler getInventory() {
        return this.inventory;
    }

    public void setScriptedResult(ItemStack scriptedResult) {
        this.scriptedResult = scriptedResult;
    }

    public ConnectedInputHandler.ConnectedInput getInput() {
        return this.input;
    }

    @Override
    public void transform(BlockEntity be, StructureTransform transform) {
        this.input.data.replaceAll(transform::applyWithoutOffset);
        this.notifyUpdate();
    }

    public static enum Phase {
        IDLE,
        ACCEPTING,
        ASSEMBLING,
        EXPORTING,
        WAITING,
        CRAFTING,
        INSERTING;

    }

    public class CrafterItemHandler
    implements SidedItemInventory {
        public static final Optional<Integer> LIMIT = Optional.of(1);
        private static final int[] SLOTS = new int[]{0};
        private ItemStack stack = ItemStack.EMPTY;

        public int[] getSlotsForFace(Direction side) {
            return SLOTS;
        }

        public boolean canPlaceItemThroughFace(int slot, ItemStack stack, @Nullable Direction dir) {
            return MechanicalCrafterBlockEntity.this.phase == Phase.IDLE && !MechanicalCrafterBlockEntity.this.covered;
        }

        public boolean canTakeItemThroughFace(int slot, ItemStack stack, Direction dir) {
            return false;
        }

        public ItemStack onExtract(ItemStack stack) {
            return this.removeMaxSize(stack, LIMIT);
        }

        public int getMaxStackSize() {
            return 1;
        }

        public int getContainerSize() {
            return 1;
        }

        public ItemStack getItem(int slot) {
            if (slot != 0) {
                return ItemStack.EMPTY;
            }
            return this.stack;
        }

        public void setItem(int slot, ItemStack stack) {
            if (slot == 0) {
                this.setStack(stack);
            }
        }

        @Override
        public void setChanged() {
            MechanicalCrafterBlockEntity.this.notifyUpdate();
            if (this.stack.isEmpty()) {
                return;
            }
            if (MechanicalCrafterBlockEntity.this.phase == Phase.IDLE) {
                MechanicalCrafterBlockEntity.this.checkCompletedRecipe(false);
            }
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public void setStack(ItemStack stack) {
            if (!stack.isEmpty()) {
                MechanicalCrafterBlockEntity.this.getLevel().playSound(null, MechanicalCrafterBlockEntity.this.getBlockPos(), SoundEvents.ITEM_FRAME_ADD_ITEM, SoundSource.BLOCKS, 0.25f, 0.5f);
            }
            if (stack != ItemStack.EMPTY) {
                this.setMaxSize(stack, LIMIT);
            }
            this.stack = stack;
        }

        public void write(ValueOutput view) {
            view.store("Stack", ItemStack.OPTIONAL_CODEC, (Object)this.stack);
        }

        public void read(ValueInput view) {
            this.stack = view.read("Stack", ItemStack.OPTIONAL_CODEC).orElse(ItemStack.EMPTY);
        }
    }
}

