/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.crafter;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.AllRecipeSerializers;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.foundation.recipe.CreateRecipe;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.Level;

public record MechanicalCraftingRecipe(ShapedRecipePattern raw, ItemStack result, boolean symmetrical) implements CreateRecipe<CraftingInput>
{
    public boolean matches(CraftingInput input, Level worldIn) {
        if (this.symmetrical) {
            return this.raw.matches(input);
        }
        if (input.ingredientCount() != this.raw.ingredientCount) {
            return false;
        }
        int width = this.raw.width();
        if (input.width() != width) {
            return false;
        }
        int height = this.raw.height();
        if (input.height() != height) {
            return false;
        }
        List ingredients = this.raw.ingredients();
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                ItemStack itemStack;
                Optional optional = (Optional)ingredients.get(j + i * width);
                if (Ingredient.testOptionalIngredient((Optional)optional, (ItemStack)(itemStack = input.getItem(j, i)))) continue;
                return false;
            }
        }
        return true;
    }

    public ItemStack assemble(CraftingInput craftingRecipeInput, HolderLookup.Provider wrapperLookup) {
        return this.result.copy();
    }

    public RecipeType<MechanicalCraftingRecipe> getType() {
        return AllRecipeTypes.MECHANICAL_CRAFTING;
    }

    public RecipeSerializer<MechanicalCraftingRecipe> getSerializer() {
        return AllRecipeSerializers.MECHANICAL_CRAFTING;
    }

    public static class Serializer
    implements RecipeSerializer<MechanicalCraftingRecipe> {
        public static final MapCodec<ShapedRecipePattern.Data> DATA_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.strictUnboundedMap((Codec)Codec.STRING.xmap(key -> Character.valueOf(key.charAt(0)), String::valueOf), (Codec)Ingredient.CODEC).fieldOf("key").forGetter(ShapedRecipePattern.Data::key), (App)Codec.STRING.listOf().fieldOf("pattern").forGetter(ShapedRecipePattern.Data::pattern)).apply((Applicative)instance, ShapedRecipePattern.Data::new));
        public static final MapCodec<ShapedRecipePattern> RAW_CODEC = DATA_CODEC.flatXmap(ShapedRecipePattern::unpack, recipe -> recipe.data.map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Cannot encode unpacked recipe")));
        public static final MapCodec<MechanicalCraftingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RAW_CODEC.forGetter(MechanicalCraftingRecipe::raw), (App)ItemStack.CODEC.fieldOf("result").forGetter(MechanicalCraftingRecipe::result), (App)Codec.BOOL.optionalFieldOf("accept_mirrored", (Object)false).forGetter(MechanicalCraftingRecipe::symmetrical)).apply((Applicative)instance, MechanicalCraftingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, MechanicalCraftingRecipe> PACKET_CODEC = StreamCodec.composite((StreamCodec)ShapedRecipePattern.STREAM_CODEC, MechanicalCraftingRecipe::raw, (StreamCodec)ItemStack.STREAM_CODEC, MechanicalCraftingRecipe::result, (StreamCodec)ByteBufCodecs.BOOL, MechanicalCraftingRecipe::symmetrical, MechanicalCraftingRecipe::new);

        public MapCodec<MechanicalCraftingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, MechanicalCraftingRecipe> streamCodec() {
            return PACKET_CODEC;
        }
    }
}

