/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.crafter;

import com.google.common.base.Predicates;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.catnip.math.Pointing;
import com.zurrtum.create.content.kinetics.base.HorizontalKineticBlock;
import com.zurrtum.create.content.kinetics.crafter.CrafterHelper;
import com.zurrtum.create.content.kinetics.crafter.MechanicalCrafterBlock;
import com.zurrtum.create.content.kinetics.crafter.MechanicalCrafterBlockEntity;
import com.zurrtum.create.content.kinetics.crafter.MechanicalCraftingRecipe;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.FireworkRocketRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class RecipeGridHandler {
    public static List<MechanicalCrafterBlockEntity> getAllCraftersOfChain(MechanicalCrafterBlockEntity root) {
        return RecipeGridHandler.getAllCraftersOfChainIf(root, (Predicate<MechanicalCrafterBlockEntity>)Predicates.alwaysTrue());
    }

    public static List<MechanicalCrafterBlockEntity> getAllCraftersOfChainIf(MechanicalCrafterBlockEntity root, Predicate<MechanicalCrafterBlockEntity> test) {
        return RecipeGridHandler.getAllCraftersOfChainIf(root, test, false);
    }

    public static List<MechanicalCrafterBlockEntity> getAllCraftersOfChainIf(MechanicalCrafterBlockEntity root, Predicate<MechanicalCrafterBlockEntity> test, boolean poweredStart) {
        ArrayList<MechanicalCrafterBlockEntity> crafters = new ArrayList<MechanicalCrafterBlockEntity>();
        ArrayList<Pair<MechanicalCrafterBlockEntity, Object>> frontier = new ArrayList<Pair<MechanicalCrafterBlockEntity, Object>>();
        HashSet<MechanicalCrafterBlockEntity> visited = new HashSet<MechanicalCrafterBlockEntity>();
        frontier.add(Pair.of(root, null));
        boolean empty = false;
        boolean allEmpty = true;
        while (!frontier.isEmpty()) {
            Pair pair = (Pair)frontier.removeFirst();
            MechanicalCrafterBlockEntity current = (MechanicalCrafterBlockEntity)pair.getFirst();
            MechanicalCrafterBlockEntity last = (MechanicalCrafterBlockEntity)pair.getSecond();
            if (visited.contains(current)) {
                return null;
            }
            if (!test.test(current)) {
                empty = true;
            } else {
                allEmpty = false;
            }
            crafters.add(current);
            visited.add(current);
            MechanicalCrafterBlockEntity target = RecipeGridHandler.getTargetingCrafter(current);
            if (target != last && target != null) {
                frontier.add(Pair.of(target, current));
            }
            for (MechanicalCrafterBlockEntity preceding : RecipeGridHandler.getPrecedingCrafters(current)) {
                if (preceding == last) continue;
                frontier.add(Pair.of(preceding, current));
            }
        }
        return empty && !poweredStart || allEmpty ? null : crafters;
    }

    public static MechanicalCrafterBlockEntity getTargetingCrafter(MechanicalCrafterBlockEntity crafter) {
        BlockState state = crafter.getBlockState();
        if (!RecipeGridHandler.isCrafter(state)) {
            return null;
        }
        BlockPos targetPos = crafter.getBlockPos().relative(MechanicalCrafterBlock.getTargetDirection(state));
        MechanicalCrafterBlockEntity targetBE = CrafterHelper.getCrafter((BlockAndTintGetter)crafter.getLevel(), targetPos);
        if (targetBE == null) {
            return null;
        }
        BlockState targetState = targetBE.getBlockState();
        if (!RecipeGridHandler.isCrafter(targetState)) {
            return null;
        }
        if (state.getValue(HorizontalKineticBlock.HORIZONTAL_FACING) != targetState.getValue(HorizontalKineticBlock.HORIZONTAL_FACING)) {
            return null;
        }
        return targetBE;
    }

    public static List<MechanicalCrafterBlockEntity> getPrecedingCrafters(MechanicalCrafterBlockEntity crafter) {
        BlockPos pos = crafter.getBlockPos();
        Level world = crafter.getLevel();
        ArrayList<MechanicalCrafterBlockEntity> crafters = new ArrayList<MechanicalCrafterBlockEntity>();
        BlockState blockState = crafter.getBlockState();
        if (!RecipeGridHandler.isCrafter(blockState)) {
            return crafters;
        }
        Direction blockFacing = (Direction)blockState.getValue(HorizontalKineticBlock.HORIZONTAL_FACING);
        Direction blockPointing = MechanicalCrafterBlock.getTargetDirection(blockState);
        for (Direction facing : Iterate.directions) {
            MechanicalCrafterBlockEntity be;
            BlockPos neighbourPos;
            BlockState neighbourState;
            if (blockFacing.getAxis() == facing.getAxis() || blockPointing == facing || !RecipeGridHandler.isCrafter(neighbourState = world.getBlockState(neighbourPos = pos.relative(facing))) || MechanicalCrafterBlock.getTargetDirection(neighbourState) != facing.getOpposite() || blockFacing != neighbourState.getValue(HorizontalKineticBlock.HORIZONTAL_FACING) || (be = CrafterHelper.getCrafter((BlockAndTintGetter)world, neighbourPos)) == null) continue;
            crafters.add(be);
        }
        return crafters;
    }

    private static boolean isCrafter(BlockState state) {
        return state.is((Block)AllBlocks.MECHANICAL_CRAFTER);
    }

    public static ItemStack tryToApplyRecipe(ServerLevel world, GroupedItems items) {
        items.calcStats();
        CraftingInput craftingInput = items.toCraftingInput();
        ItemStack result = null;
        RegistryAccess registryAccess = world.registryAccess();
        RecipeManager recipeManager = world.recipeAccess();
        if (((Boolean)AllConfigs.server().recipes.allowRegularCraftingInCrafter.get()).booleanValue()) {
            result = recipeManager.recipes.getRecipesFor(RecipeType.CRAFTING, (RecipeInput)craftingInput, (Level)world).filter(r -> RecipeGridHandler.isRecipeAllowed((RecipeHolder<CraftingRecipe>)r, craftingInput)).findFirst().map(r -> ((CraftingRecipe)r.value()).assemble((RecipeInput)craftingInput, (HolderLookup.Provider)registryAccess)).orElse(null);
        }
        if (result == null) {
            result = recipeManager.getRecipeFor(AllRecipeTypes.MECHANICAL_CRAFTING, (RecipeInput)craftingInput, (Level)world).map(r -> ((MechanicalCraftingRecipe)r.value()).assemble(craftingInput, (HolderLookup.Provider)registryAccess)).orElse(null);
        }
        return result;
    }

    public static boolean isRecipeAllowed(RecipeHolder<CraftingRecipe> recipe, CraftingInput craftingInput) {
        if (recipe.value() instanceof FireworkRocketRecipe) {
            int numItems = 0;
            for (int i = 0; i < craftingInput.size(); ++i) {
                if (craftingInput.getItem(i).isEmpty()) continue;
                ++numItems;
            }
            if (numItems > (Integer)AllConfigs.server().recipes.maxFireworkIngredientsInCrafter.get()) {
                return false;
            }
        }
        return !AllRecipeTypes.shouldIgnoreInAutomation(recipe);
    }

    public static class GroupedItems {
        public static final Codec<Map<Pair<Integer, Integer>, ItemStack>> GRID_CODEC = CreateCodecs.getCodecMap(Pair.codec(Codec.INT, Codec.INT), ItemStack.OPTIONAL_CODEC);
        public static final Codec<GroupedItems> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)GRID_CODEC.fieldOf("Grid").forGetter(i -> i.grid)).apply((Applicative)instance, GroupedItems::new));
        public Map<Pair<Integer, Integer>, ItemStack> grid = new HashMap<Pair<Integer, Integer>, ItemStack>();
        public int minX;
        public int minY;
        int maxX;
        int maxY;
        public int width;
        public int height;
        boolean statsReady;

        public GroupedItems() {
        }

        public GroupedItems(ItemStack stack) {
            this.grid.put(Pair.of(0, 0), stack);
        }

        public GroupedItems(Map<Pair<Integer, Integer>, ItemStack> grid) {
            this.grid.putAll(grid);
        }

        public void mergeOnto(GroupedItems other, Pointing pointing) {
            int xOffset;
            int n = pointing == Pointing.LEFT ? 1 : (xOffset = pointing == Pointing.RIGHT ? -1 : 0);
            int yOffset = pointing == Pointing.DOWN ? 1 : (pointing == Pointing.UP ? -1 : 0);
            this.grid.forEach((pair, stack) -> other.grid.put(Pair.of((Integer)pair.getFirst() + xOffset, (Integer)pair.getSecond() + yOffset), (ItemStack)stack));
            other.statsReady = false;
        }

        public void write(ValueOutput view) {
            ValueOutput.ValueOutputList list = view.childrenList("Grid");
            this.grid.forEach((pair, stack) -> {
                ValueOutput entry = list.addChild();
                entry.putInt("x", ((Integer)pair.getFirst()).intValue());
                entry.putInt("y", ((Integer)pair.getSecond()).intValue());
                entry.store("item", ItemStack.OPTIONAL_CODEC, stack);
            });
        }

        public static GroupedItems read(ValueInput view) {
            GroupedItems items = new GroupedItems();
            ValueInput.ValueInputList list = view.childrenListOrEmpty("Grid");
            list.forEach(entry -> {
                int x = entry.getIntOr("x", 0);
                int y = entry.getIntOr("y", 0);
                ItemStack stack = entry.read("item", ItemStack.OPTIONAL_CODEC).orElse(ItemStack.EMPTY);
                items.grid.put(Pair.of(x, y), stack);
            });
            return items;
        }

        public void calcStats() {
            if (this.statsReady) {
                return;
            }
            this.statsReady = true;
            this.minX = 0;
            this.minY = 0;
            this.maxX = 0;
            this.maxY = 0;
            for (Pair<Integer, Integer> pair : this.grid.keySet()) {
                int x = pair.getFirst();
                int y = pair.getSecond();
                this.minX = Math.min(this.minX, x);
                this.minY = Math.min(this.minY, y);
                this.maxX = Math.max(this.maxX, x);
                this.maxY = Math.max(this.maxY, y);
            }
            this.width = this.maxX - this.minX + 1;
            this.height = this.maxY - this.minY + 1;
        }

        public boolean onlyEmptyItems() {
            for (ItemStack stack : this.grid.values()) {
                if (stack.isEmpty()) continue;
                return false;
            }
            return true;
        }

        public CraftingInput toCraftingInput() {
            ItemStack stack;
            ArrayList<ItemStack> list = new ArrayList<ItemStack>(this.width * this.height);
            int minX = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            int minY = Integer.MAX_VALUE;
            int maxY = Integer.MIN_VALUE;
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    int xp = x + this.minX;
                    int yp = y + this.minY;
                    stack = this.grid.get(Pair.of(xp, yp));
                    if (stack == null || stack.isEmpty()) continue;
                    minX = Math.min(minX, xp);
                    maxX = Math.max(maxX, xp);
                    minY = Math.min(minY, yp);
                    maxY = Math.max(maxY, yp);
                }
            }
            int w = maxX - minX + 1;
            int h = maxY - minY + 1;
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    stack = this.grid.get(Pair.of(x + minX, maxY - y));
                    list.add(stack == null ? ItemStack.EMPTY : stack.copy());
                }
            }
            return new CraftingInput(w, h, list);
        }
    }
}

