/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.crank;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.content.kinetics.crank.HandCrankBlock;
import com.zurrtum.create.content.kinetics.crank.HandCrankBlockEntity;
import com.zurrtum.create.content.kinetics.crank.ValveHandleBlockEntity;
import com.zurrtum.create.foundation.utility.BlockHelper;
import java.lang.runtime.SwitchBootstraps;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ValveHandleBlock
extends HandCrankBlock {
    public final DyeColor color;

    public static ValveHandleBlock copper(BlockBehaviour.Properties properties) {
        return new ValveHandleBlock(properties, null);
    }

    public static Function<BlockBehaviour.Properties, ValveHandleBlock> dyed(DyeColor color) {
        return properties -> new ValveHandleBlock((BlockBehaviour.Properties)properties, color);
    }

    private ValveHandleBlock(BlockBehaviour.Properties properties, DyeColor color) {
        super(properties);
        this.color = color;
    }

    @Override
    public VoxelShape getShape(BlockState pState, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return AllShapes.VALVE_HANDLE.get((Direction)pState.getValue((Property)FACING));
    }

    public static ValveHandleBlock getColorBlock(DyeColor color) {
        DyeColor dyeColor = color;
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"WHITE", "ORANGE", "MAGENTA", "LIGHT_BLUE", "YELLOW", "LIME", "PINK", "GRAY", "LIGHT_GRAY", "CYAN", "PURPLE", "BLUE", "BROWN", "GREEN", "RED", "BLACK"}, (DyeColor)dyeColor, n)) {
            default -> throw new MatchException(null, null);
            case -1 -> AllBlocks.COPPER_VALVE_HANDLE;
            case 0 -> AllBlocks.WHITE_VALVE_HANDLE;
            case 1 -> AllBlocks.ORANGE_VALVE_HANDLE;
            case 2 -> AllBlocks.MAGENTA_VALVE_HANDLE;
            case 3 -> AllBlocks.LIGHT_BLUE_VALVE_HANDLE;
            case 4 -> AllBlocks.YELLOW_VALVE_HANDLE;
            case 5 -> AllBlocks.LIME_VALVE_HANDLE;
            case 6 -> AllBlocks.PINK_VALVE_HANDLE;
            case 7 -> AllBlocks.GRAY_VALVE_HANDLE;
            case 8 -> AllBlocks.LIGHT_GRAY_VALVE_HANDLE;
            case 9 -> AllBlocks.CYAN_VALVE_HANDLE;
            case 10 -> AllBlocks.PURPLE_VALVE_HANDLE;
            case 11 -> AllBlocks.BLUE_VALVE_HANDLE;
            case 12 -> AllBlocks.BROWN_VALVE_HANDLE;
            case 13 -> AllBlocks.GREEN_VALVE_HANDLE;
            case 14 -> AllBlocks.RED_VALVE_HANDLE;
            case 15 -> AllBlocks.BLACK_VALVE_HANDLE;
        };
    }

    public void clicked(Level level, BlockPos pos, BlockState state, Player player, InteractionHand hand) {
        ItemStack heldItem = player.getItemInHand(hand);
        this.useItemOn(heldItem, state, level, pos, player, hand, null);
    }

    @Override
    protected InteractionResult useItemOn(ItemStack heldItem, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        DyeColor color = AllItemTags.getDyeColor(heldItem);
        if (color != null && color != this.color) {
            if (!level.isClientSide()) {
                level.setBlockAndUpdate(pos, BlockHelper.copyProperties(state, ValveHandleBlock.getColorBlock(color).defaultBlockState()));
            }
            return InteractionResult.SUCCESS;
        }
        this.onBlockEntityUse((BlockGetter)level, pos, hcbe -> {
            ValveHandleBlockEntity vhbe;
            return hcbe instanceof ValveHandleBlockEntity && (vhbe = (ValveHandleBlockEntity)hcbe).activate(player.isShiftKeyDown()) ? InteractionResult.SUCCESS : InteractionResult.PASS;
        });
        return InteractionResult.SUCCESS;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        return super.useWithoutItem(state, world, pos, player, hit);
    }

    @Override
    public BlockEntityType<? extends HandCrankBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.VALVE_HANDLE;
    }
}

