/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.crusher;

import com.mojang.serialization.MapCodec;
import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.kinetics.crusher.CrushingWheelBlockEntity;
import com.zurrtum.create.content.kinetics.crusher.CrushingWheelControllerBlockEntity;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import com.zurrtum.create.infrastructure.items.ItemInventoryProvider;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class CrushingWheelControllerBlock
extends DirectionalBlock
implements IBE<CrushingWheelControllerBlockEntity>,
ItemInventoryProvider<CrushingWheelControllerBlockEntity> {
    public static final BooleanProperty VALID = BooleanProperty.create((String)"valid");
    public static final MapCodec<CrushingWheelControllerBlock> CODEC = CrushingWheelControllerBlock.simpleCodec(CrushingWheelControllerBlock::new);

    public CrushingWheelControllerBlock(BlockBehaviour.Properties p_i48440_1_) {
        super(p_i48440_1_);
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    protected float getDestroyProgress(BlockState state, Player player, BlockGetter world, BlockPos pos) {
        return 0.0f;
    }

    @Override
    public Container getInventory(LevelAccessor world, BlockPos pos, BlockState state, CrushingWheelControllerBlockEntity blockEntity, Direction context) {
        return blockEntity.inventory;
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        return false;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{VALID});
        builder.add(new Property[]{FACING});
        super.createBlockStateDefinition(builder);
    }

    public void entityInside(BlockState state, Level worldIn, BlockPos pos, Entity entityIn, InsideBlockEffectApplier handler, boolean bl) {
        if (!((Boolean)state.getValue((Property)VALID)).booleanValue()) {
            return;
        }
        Direction facing = (Direction)state.getValue((Property)FACING);
        Direction.Axis axis = facing.getAxis();
        this.checkEntityForProcessing(worldIn, pos, entityIn);
        this.withBlockEntityDo((BlockGetter)worldIn, pos, be -> {
            if (be.processingEntity == entityIn) {
                entityIn.makeStuckInBlock(state, new Vec3(axis == Direction.Axis.X ? (double)0.05f : 0.25, axis == Direction.Axis.Y ? (double)0.05f : 0.25, axis == Direction.Axis.Z ? (double)0.05f : 0.25));
            }
        });
    }

    public void checkEntityForProcessing(Level worldIn, BlockPos pos, Entity entityIn) {
        Optional<BlockPos> value;
        CrushingWheelControllerBlockEntity be = (CrushingWheelControllerBlockEntity)this.getBlockEntity((BlockGetter)worldIn, pos);
        if (be == null) {
            return;
        }
        if (be.crushingspeed == 0.0f) {
            return;
        }
        if (entityIn instanceof ItemEntity && (value = AllSynchedDatas.BYPASS_CRUSHING_WHEEL.get(entityIn)).isPresent() && pos.equals((Object)value.get())) {
            return;
        }
        if (be.isOccupied()) {
            return;
        }
        if (entityIn instanceof Player) {
            Player player = (Player)entityIn;
            if (player.isCreative()) {
                return;
            }
            if (entityIn.level().getDifficulty() == Difficulty.PEACEFUL) {
                return;
            }
        }
        be.startCrushing(entityIn);
    }

    public void updateEntityMovementAfterFallOn(BlockGetter worldIn, Entity entityIn) {
        super.updateEntityMovementAfterFallOn(worldIn, entityIn);
    }

    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        if (!((Boolean)stateIn.getValue((Property)VALID)).booleanValue()) {
            return;
        }
        if (rand.nextInt(1) != 0) {
            return;
        }
        double d0 = (float)pos.getX() + rand.nextFloat();
        double d1 = (float)pos.getY() + rand.nextFloat();
        double d2 = (float)pos.getZ() + rand.nextFloat();
        worldIn.addParticle((ParticleOptions)ParticleTypes.CRIT, d0, d1, d2, 0.0, 0.0, 0.0);
    }

    public BlockState updateShape(BlockState stateIn, LevelReader worldIn, ScheduledTickAccess tickView, BlockPos currentPos, Direction facing, BlockPos facingPos, BlockState facingState, RandomSource random) {
        this.updateSpeed(stateIn, worldIn, currentPos);
        return stateIn;
    }

    public void updateSpeed(BlockState state, LevelReader world, BlockPos pos) {
        this.withBlockEntityDo((BlockGetter)world, pos, be -> {
            if (!((Boolean)state.getValue((Property)VALID)).booleanValue()) {
                if (be.crushingspeed != 0.0f) {
                    be.crushingspeed = 0.0f;
                    be.sendData();
                }
                return;
            }
            for (Direction d : Iterate.directions) {
                BlockEntity adjBE;
                BlockState neighbour = world.getBlockState(pos.relative(d));
                if (!neighbour.is((Block)AllBlocks.CRUSHING_WHEEL) || neighbour.getValue((Property)BlockStateProperties.AXIS) == d.getAxis() || !((adjBE = world.getBlockEntity(pos.relative(d))) instanceof CrushingWheelBlockEntity)) continue;
                CrushingWheelBlockEntity cwbe = (CrushingWheelBlockEntity)adjBE;
                be.crushingspeed = Math.abs(cwbe.getSpeed() / 50.0f);
                be.sendData();
                cwbe.award(AllAdvancements.CRUSHING_WHEEL);
                if (!(Math.abs(cwbe.getSpeed()) > (float)((Integer)AllConfigs.server().kinetics.maxRotationSpeed.get() - 1))) break;
                cwbe.award(AllAdvancements.CRUSHER_MAXED);
                break;
            }
        });
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Optional<BlockPos> value;
        VoxelShape standardShape = AllShapes.CRUSHING_WHEEL_CONTROLLER_COLLISION.get((Direction)state.getValue((Property)FACING));
        if (!((Boolean)state.getValue((Property)VALID)).booleanValue()) {
            return standardShape;
        }
        if (!(context instanceof EntityCollisionContext)) {
            return standardShape;
        }
        EntityCollisionContext entityShapeContext = (EntityCollisionContext)context;
        Entity entity = entityShapeContext.getEntity();
        if (entity == null) {
            return standardShape;
        }
        if (entity instanceof ItemEntity && state.getValue((Property)FACING) != Direction.UP && (value = AllSynchedDatas.BYPASS_CRUSHING_WHEEL.get(entity)).isPresent() && pos.equals((Object)value.get())) {
            return Shapes.empty();
        }
        CrushingWheelControllerBlockEntity be = (CrushingWheelControllerBlockEntity)this.getBlockEntity(worldIn, pos);
        if (be != null && be.processingEntity == entity) {
            return Shapes.empty();
        }
        return standardShape;
    }

    @Override
    public Class<CrushingWheelControllerBlockEntity> getBlockEntityClass() {
        return CrushingWheelControllerBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends CrushingWheelControllerBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.CRUSHING_WHEEL_CONTROLLER;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    @NotNull
    protected MapCodec<? extends DirectionalBlock> codec() {
        return CODEC;
    }
}

