/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.crusher;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllDamageSources;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.zurrtum.create.content.kinetics.crusher.AbstractCrushingRecipe;
import com.zurrtum.create.content.kinetics.crusher.CrushingWheelControllerBlock;
import com.zurrtum.create.content.processing.recipe.ProcessingInventory;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.item.ItemHelper;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class CrushingWheelControllerBlockEntity
extends SmartBlockEntity {
    public Entity processingEntity;
    public UUID entityUUID;
    protected boolean searchForEntity;
    public ProcessingInventory inventory = new ProcessingInventory(this::itemInserted, d -> this.processingEntity == null);
    public float crushingspeed;

    public CrushingWheelControllerBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.CRUSHING_WHEEL_CONTROLLER, pos, state);
    }

    @Override
    public void preRemoveSideEffects(BlockPos pos, BlockState oldState) {
        super.preRemoveSideEffects(pos, oldState);
        Containers.dropContents((Level)this.level, (BlockPos)pos, (Container)this.inventory);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        behaviours.add(new DirectBeltInputBehaviour(this).onlyInsertWhen(this::supportsDirectBeltInput));
    }

    private boolean supportsDirectBeltInput(Direction side) {
        BlockState blockState = this.getBlockState();
        if (blockState == null) {
            return false;
        }
        Direction direction = (Direction)blockState.getValue((Property)CrushingWheelControllerBlock.FACING);
        return direction == Direction.DOWN || direction == side;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.searchForEntity) {
            this.searchForEntity = false;
            List search = this.level.getEntities((Entity)null, new AABB(this.getBlockPos()), e -> this.entityUUID.equals(e.getUUID()));
            if (search.isEmpty()) {
                this.clear();
            } else {
                this.processingEntity = (Entity)search.getFirst();
            }
        }
        if (!this.isOccupied()) {
            return;
        }
        if (this.crushingspeed == 0.0f) {
            return;
        }
        float speed = this.crushingspeed * 4.0f;
        Vec3 centerPos = VecHelper.getCenterOf((Vec3i)this.worldPosition);
        Direction facing = (Direction)this.getBlockState().getValue((Property)CrushingWheelControllerBlock.FACING);
        int offset = facing.getAxisDirection().getStep();
        Vec3 outSpeed = new Vec3((facing.getAxis() == Direction.Axis.X ? 0.25 : 0.0) * (double)offset, offset == 1 ? (facing.getAxis() == Direction.Axis.Y ? 0.5 : 0.0) : 0.0, (facing.getAxis() == Direction.Axis.Z ? 0.25 : 0.0) * (double)offset);
        Vec3 outPos = centerPos.add((double)(facing.getAxis() == Direction.Axis.X ? 0.55f * (float)offset : 0.0f), (double)(facing.getAxis() == Direction.Axis.Y ? 0.55f * (float)offset : 0.0f), (double)(facing.getAxis() == Direction.Axis.Z ? 0.55f * (float)offset : 0.0f));
        if (!this.hasEntity()) {
            BlockPos nextPos;
            DirectBeltInputBehaviour behaviour;
            float processingSpeed = Mth.clamp((float)(speed / (!this.inventory.appliedRecipe ? (float)Math.log(this.inventory.getItem(0).getCount()) / (float)Math.log(2.0) : 1.0f)), (float)0.25f, (float)20.0f);
            this.inventory.remainingTime -= processingSpeed;
            this.spawnParticles(this.inventory.getItem(0));
            if (this.level.isClientSide()) {
                return;
            }
            if (this.inventory.remainingTime < 20.0f && !this.inventory.appliedRecipe) {
                this.applyRecipe();
                this.inventory.appliedRecipe = true;
                this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 18);
                return;
            }
            if (this.inventory.remainingTime > 0.0f) {
                return;
            }
            this.inventory.remainingTime = 0.0f;
            if (facing != Direction.UP && (behaviour = BlockEntityBehaviour.get((BlockGetter)this.level, nextPos = this.worldPosition.below().relative(facing, facing.getAxis() == Direction.Axis.Y ? 0 : 1), DirectBeltInputBehaviour.TYPE)) != null) {
                boolean changed = false;
                if (!behaviour.canInsertFromSide(facing)) {
                    return;
                }
                int size = this.inventory.getContainerSize();
                for (int slot = 0; slot < size; ++slot) {
                    ItemStack remainder;
                    ItemStack stack = this.inventory.getItem(slot);
                    if (stack.isEmpty() || ItemStack.matches((ItemStack)(remainder = behaviour.handleInsertion(stack, facing, false)), (ItemStack)stack)) continue;
                    this.inventory.setItem(slot, remainder);
                    changed = true;
                }
                if (changed) {
                    this.setChanged();
                    this.sendData();
                }
                return;
            }
            int size = this.inventory.getContainerSize();
            for (int slot = 0; slot < size; ++slot) {
                ItemStack stack = this.inventory.getItem(slot);
                if (stack.isEmpty()) continue;
                ItemEntity entityIn = new ItemEntity(this.level, outPos.x, outPos.y, outPos.z, stack);
                entityIn.setDeltaMovement(outSpeed);
                AllSynchedDatas.BYPASS_CRUSHING_WHEEL.set((Entity)entityIn, Optional.of(this.worldPosition));
                this.level.addFreshEntity((Entity)entityIn);
            }
            this.inventory.clearContent();
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 18);
            return;
        }
        if (!this.processingEntity.isAlive() || !this.processingEntity.getBoundingBox().intersects(new AABB(this.worldPosition).inflate(0.5))) {
            this.clear();
            return;
        }
        double xMotion = ((double)((float)this.worldPosition.getX() + 0.5f) - this.processingEntity.getX()) / 2.0;
        double zMotion = ((double)((float)this.worldPosition.getZ() + 0.5f) - this.processingEntity.getZ()) / 2.0;
        if (this.processingEntity.isShiftKeyDown()) {
            zMotion = 0.0;
            xMotion = 0.0;
        }
        double movement = Math.max(-speed / 4.0f, -0.5f) * (float)(-offset);
        this.processingEntity.setDeltaMovement(new Vec3(facing.getAxis() == Direction.Axis.X ? movement : xMotion, facing.getAxis() == Direction.Axis.Y ? movement : 0.0, facing.getAxis() == Direction.Axis.Z ? movement : zMotion));
        if (this.level.isClientSide()) {
            return;
        }
        Entity remainder = this.processingEntity;
        if (!(remainder instanceof ItemEntity)) {
            Vec3 entityOutPos = outPos.add(facing.getAxis() == Direction.Axis.X ? (double)(0.5f * (float)offset) : 0.0, facing.getAxis() == Direction.Axis.Y ? (double)(0.5f * (float)offset) : 0.0, facing.getAxis() == Direction.Axis.Z ? (double)(0.5f * (float)offset) : 0.0);
            int crusherDamage = (Integer)AllConfigs.server().kinetics.crushingDamage.get();
            if (this.processingEntity instanceof LivingEntity && ((LivingEntity)this.processingEntity).getHealth() - (float)crusherDamage <= 0.0f && ((LivingEntity)this.processingEntity).hurtTime <= 0) {
                this.processingEntity.setPosRaw(entityOutPos.x, entityOutPos.y, entityOutPos.z);
            }
            this.processingEntity.hurtServer((ServerLevel)this.level, AllDamageSources.get((Level)this.level).crush, (float)crusherDamage);
            if (!this.processingEntity.isAlive()) {
                this.processingEntity.setPosRaw(entityOutPos.x, entityOutPos.y, entityOutPos.z);
            }
            return;
        }
        ItemEntity itemEntity = (ItemEntity)remainder;
        itemEntity.setPickUpDelay(20);
        if (facing.getAxis() == Direction.Axis.Y) {
            if (this.processingEntity.getY() * (double)(-offset) < (centerPos.y - 0.25) * (double)(-offset)) {
                this.intakeItem(itemEntity);
            }
        } else if (facing.getAxis() == Direction.Axis.Z) {
            if (this.processingEntity.getZ() * (double)(-offset) < (centerPos.z - 0.25) * (double)(-offset)) {
                this.intakeItem(itemEntity);
            }
        } else if (this.processingEntity.getX() * (double)(-offset) < (centerPos.x - 0.25) * (double)(-offset)) {
            this.intakeItem(itemEntity);
        }
    }

    private void intakeItem(ItemEntity itemEntity) {
        this.inventory.clearContent();
        this.inventory.setItem(0, itemEntity.getItem().copy());
        this.itemInserted(this.inventory.getItem(0));
        itemEntity.discard();
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 18);
    }

    protected void spawnParticles(ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return;
        }
        Object particleData = stack.getItem() instanceof BlockItem ? new BlockParticleOption(ParticleTypes.BLOCK, ((BlockItem)stack.getItem()).getBlock().defaultBlockState()) : new ItemParticleOption(ParticleTypes.ITEM, stack);
        RandomSource r = this.level.random;
        int x = this.worldPosition.getX();
        int y = this.worldPosition.getY();
        int z = this.worldPosition.getZ();
        for (int i = 0; i < 4; ++i) {
            this.level.addParticle((ParticleOptions)particleData, (double)((float)x + r.nextFloat()), (double)((float)y + r.nextFloat()), (double)((float)z + r.nextFloat()), 0.0, 0.0, 0.0);
        }
    }

    private void applyRecipe() {
        AbstractCrushingRecipe recipe = this.findRecipe();
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        if (recipe != null) {
            ItemStack item = this.inventory.getItem(0);
            SingleRecipeInput input = new SingleRecipeInput(item);
            int rolls = item.getCount();
            this.inventory.clearContent();
            ItemStack recipeRemainder = item.getItem().getCraftingRemainder();
            if (recipeRemainder.isEmpty()) {
                recipeRemainder = null;
            }
            for (int roll = 0; roll < rolls; ++roll) {
                List<ItemStack> rolledResults = recipe.assemble(input, this.level.random);
                for (ItemStack stack : rolledResults) {
                    ItemHelper.addToList(stack, list);
                }
                if (recipeRemainder == null) continue;
                ItemHelper.addToList(recipeRemainder, list);
            }
            int max = Math.min(list.size(), this.inventory.getContainerSize() - 1);
            for (int slot = 0; slot < max; ++slot) {
                this.inventory.setItem(slot + 1, (ItemStack)list.get(slot));
            }
        } else {
            this.inventory.clearContent();
        }
    }

    public AbstractCrushingRecipe findRecipe() {
        SingleRecipeInput input;
        RecipeManager recipeManager = ((ServerLevel)this.level).recipeAccess();
        AbstractCrushingRecipe crushingRecipe = recipeManager.getRecipeFor(AllRecipeTypes.CRUSHING, (RecipeInput)(input = new SingleRecipeInput(this.inventory.getItem(0))), this.level).map(RecipeHolder::value).orElse(null);
        if (crushingRecipe == null) {
            crushingRecipe = recipeManager.getRecipeFor(AllRecipeTypes.MILLING, (RecipeInput)input, this.level).map(RecipeHolder::value).orElse(null);
        }
        return crushingRecipe;
    }

    @Override
    public void write(ValueOutput view, boolean clientPacket) {
        if (this.hasEntity()) {
            view.store("Entity", UUIDUtil.CODEC, (Object)this.entityUUID);
        }
        this.inventory.write(view);
        view.putFloat("Speed", this.crushingspeed);
        super.write(view, clientPacket);
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        super.read(view, clientPacket);
        view.read("Entity", UUIDUtil.CODEC).ifPresent(uuid -> {
            if (!this.isOccupied()) {
                this.entityUUID = uuid;
                this.searchForEntity = true;
            }
        });
        this.crushingspeed = view.getFloatOr("Speed", 0.0f);
        this.inventory.read(view);
    }

    public void startCrushing(Entity entity) {
        this.processingEntity = entity;
        this.entityUUID = entity.getUUID();
    }

    private void itemInserted(ItemStack stack) {
        AbstractCrushingRecipe recipe = this.findRecipe();
        this.inventory.remainingTime = recipe != null ? (float)recipe.time() : 100.0f;
        this.inventory.appliedRecipe = false;
    }

    public void clear() {
        this.processingEntity = null;
        this.entityUUID = null;
    }

    public boolean isOccupied() {
        return this.hasEntity() || !this.inventory.isEmpty();
    }

    public boolean hasEntity() {
        return this.processingEntity != null;
    }
}

