/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.deployer;

import com.mojang.authlib.GameProfile;
import com.zurrtum.create.content.kinetics.deployer.DeployerPlayer;
import com.zurrtum.create.infrastructure.player.FakePlayerEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;

public class DeployerFakePlayer
extends FakePlayerEntity
implements DeployerPlayer {
    public Pair<BlockPos, Float> blockBreakingProgress;
    private ItemStack spawnedItemEffects;
    public boolean placedTracks;
    public boolean onMinecartContraption;

    public DeployerFakePlayer(ServerLevel world, GameProfile profile) {
        super(world, profile);
        this.gameMode.setGameModeForPlayer(GameType.SURVIVAL, null);
    }

    @Override
    public ServerPlayerGameMode getInteractionManager() {
        return this.gameMode;
    }

    @Override
    public Pair<BlockPos, Float> getBlockBreakingProgress() {
        return this.blockBreakingProgress;
    }

    @Override
    public void setBlockBreakingProgress(Pair<BlockPos, Float> blockBreakingProgress) {
        this.blockBreakingProgress = blockBreakingProgress;
    }

    @Override
    public ItemStack getSpawnedItemEffects() {
        return this.spawnedItemEffects;
    }

    @Override
    public void setSpawnedItemEffects(ItemStack spawnedItemEffects) {
        this.spawnedItemEffects = spawnedItemEffects;
    }

    @Override
    public boolean getPlacedTracks() {
        return this.placedTracks;
    }

    @Override
    public void setPlacedTracks(boolean placedTracks) {
        this.placedTracks = placedTracks;
    }

    @Override
    public boolean isOnMinecartContraption() {
        return this.onMinecartContraption;
    }

    @Override
    public void setOnMinecartContraption(boolean onMinecartContraption) {
        this.onMinecartContraption = onMinecartContraption;
    }

    public Component getDisplayName() {
        return Component.translatable((String)"create.block.deployer.damage_source_name");
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return super.getDefaultDimensions(pose).withEyeHeight(0.0f);
    }

    public Vec3 position() {
        Vec3 pos = super.position();
        return new Vec3(pos.x, pos.y, pos.z);
    }

    public float getCurrentItemAttackStrengthDelay() {
        return 0.015625f;
    }

    public boolean canEat(boolean ignoreHunger) {
        return false;
    }

    public boolean canBeAffected(MobEffectInstance effect) {
        return false;
    }

    public boolean doesEmitEquipEvent(EquipmentSlot slot) {
        return false;
    }

    public void remove(Entity.RemovalReason reason) {
        ServerLevel world = this.level();
        if (this.blockBreakingProgress != null && !world.isClientSide()) {
            world.destroyBlockProgress(this.getId(), (BlockPos)this.blockBreakingProgress.getKey(), -1);
        }
        super.remove(reason);
    }
}

