/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.deployer;

import com.zurrtum.create.content.kinetics.deployer.DeployerBlockEntity;
import com.zurrtum.create.content.kinetics.deployer.DeployerPlayer;
import com.zurrtum.create.infrastructure.items.SidedItemInventory;
import com.zurrtum.create.infrastructure.transfer.SlotRangeCache;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class DeployerItemHandler
implements SidedItemInventory {
    private final DeployerBlockEntity be;
    private final DeployerPlayer player;

    public DeployerItemHandler(DeployerBlockEntity be) {
        this.be = be;
        this.player = be.player;
    }

    public int[] getSlotsForFace(Direction side) {
        return SlotRangeCache.get(this.be.overflowItems.size() + 1);
    }

    public boolean canPlaceItemThroughFace(int slot, ItemStack stack, @Nullable Direction dir) {
        if (slot != 0 || this.player == null) {
            return false;
        }
        if (this.be.filtering.getFilter().isEmpty()) {
            return true;
        }
        return this.be.filtering.test(stack);
    }

    public boolean canTakeItemThroughFace(int slot, ItemStack stack, Direction dir) {
        if (slot != 0) {
            return true;
        }
        if (this.player == null) {
            return false;
        }
        if (this.be.filtering.getFilter().isEmpty()) {
            return true;
        }
        return !this.be.filtering.test(this.player.cast().getMainHandItem());
    }

    public int getContainerSize() {
        return 1 + this.be.overflowItems.size();
    }

    public ItemStack getItem(int slot) {
        int size = this.be.overflowItems.size();
        if (slot > size) {
            return ItemStack.EMPTY;
        }
        if (slot == 0) {
            return this.player == null ? ItemStack.EMPTY : this.player.cast().getMainHandItem();
        }
        return this.be.overflowItems.get(slot - 1);
    }

    public void setItem(int slot, ItemStack stack) {
        int size = this.be.overflowItems.size();
        if (slot > size) {
            return;
        }
        if (slot == 0) {
            this.player.cast().setItemInHand(InteractionHand.MAIN_HAND, stack);
        } else {
            this.be.overflowItems.set(slot - 1, stack);
        }
    }

    @Override
    public void setChanged() {
        this.be.overflowItems.removeIf(ItemStack::isEmpty);
        this.be.notifyUpdate();
    }
}

