/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.deployer;

import com.mojang.authlib.GameProfile;
import com.zurrtum.create.api.entity.FakePlayerHandler;
import com.zurrtum.create.content.kinetics.deployer.DeployerFabricFakePlayer;
import com.zurrtum.create.content.kinetics.deployer.DeployerFakePlayer;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public interface DeployerPlayer {
    public static final UUID FALLBACK_ID = UUID.fromString("9e2faded-cafe-4ec2-c314-dad129ae971d");

    public static DeployerPlayer create(ServerLevel world, @Nullable UUID owner, @Nullable String name) {
        GameProfile profile = new GameProfile(owner == null ? FALLBACK_ID : owner, owner == null || name == null ? "Deployer" : name);
        if (FakePlayerHandler.FABRIC) {
            return new DeployerFabricFakePlayer(world, profile);
        }
        return new DeployerFakePlayer(world, profile);
    }

    public Pair<BlockPos, Float> getBlockBreakingProgress();

    public void setBlockBreakingProgress(Pair<BlockPos, Float> var1);

    public ItemStack getSpawnedItemEffects();

    public void setSpawnedItemEffects(ItemStack var1);

    public ServerPlayerGameMode getInteractionManager();

    public boolean getPlacedTracks();

    public void setPlacedTracks(boolean var1);

    public boolean isOnMinecartContraption();

    public void setOnMinecartContraption(boolean var1);

    default public ServerPlayer cast() {
        return (ServerPlayer)this;
    }
}

