/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.flywheel;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.phys.AABB;

public class FlywheelBlockEntity
extends KineticBlockEntity {
    public LerpedFloat visualSpeed = LerpedFloat.linear();
    public float angle;

    public FlywheelBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.FLYWHEEL, pos, state);
    }

    @Override
    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().inflate(2.0);
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        super.read(view, clientPacket);
        if (clientPacket) {
            this.visualSpeed.chase(this.getGeneratedSpeed(), 0.015625, LerpedFloat.Chaser.EXP);
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level.isClientSide()) {
            return;
        }
        float targetSpeed = this.getSpeed();
        this.visualSpeed.updateChaseTarget(targetSpeed);
        this.visualSpeed.tickChaser();
        this.angle += this.visualSpeed.getValue() * 3.0f / 10.0f;
        this.angle %= 360.0f;
    }
}

