/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.gauge;

import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public abstract class GaugeBlockEntity
extends KineticBlockEntity {
    public float dialTarget;
    public float dialState;
    public float prevDialState;
    public int color;

    public GaugeBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    @Override
    public void write(ValueOutput view, boolean clientPacket) {
        view.putFloat("Value", this.dialTarget);
        view.putInt("Color", this.color);
        super.write(view, clientPacket);
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        this.dialTarget = view.getFloatOr("Value", 0.0f);
        this.color = view.getIntOr("Color", 0);
        super.read(view, clientPacket);
    }

    @Override
    public void tick() {
        super.tick();
        this.prevDialState = this.dialState;
        this.dialState += (this.dialTarget - this.dialState) * 0.125f;
        if (this.dialState > 1.0f && this.level.random.nextFloat() < 0.5f) {
            this.dialState -= (this.dialState - 1.0f) * this.level.random.nextFloat();
        }
    }
}

