/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.gearbox;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.zurrtum.create.content.kinetics.gearbox.GearboxBlockEntity;
import com.zurrtum.create.foundation.block.IBE;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;

public class GearboxBlock
extends RotatedPillarKineticBlock
implements IBE<GearboxBlockEntity> {
    public GearboxBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        if (((Direction.Axis)state.getValue((Property)AXIS)).isVertical()) {
            return super.getDrops(state, builder);
        }
        return List.of(new ItemStack((ItemLike)AllItems.VERTICAL_GEARBOX));
    }

    protected ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state, boolean includeData) {
        if (((Direction.Axis)state.getValue((Property)AXIS)).isVertical()) {
            return super.getCloneItemStack(world, pos, state, includeData);
        }
        return AllItems.VERTICAL_GEARBOX.getDefaultInstance();
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)AXIS, (Comparable)Direction.Axis.Y);
    }

    @Override
    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face.getAxis() != state.getValue((Property)AXIS);
    }

    @Override
    public Direction.Axis getRotationAxis(BlockState state) {
        return (Direction.Axis)state.getValue((Property)AXIS);
    }

    @Override
    public Class<GearboxBlockEntity> getBlockEntityClass() {
        return GearboxBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends GearboxBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.GEARBOX;
    }
}

