/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.mechanicalArm;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.content.kinetics.base.KineticBlock;
import com.zurrtum.create.content.kinetics.mechanicalArm.ArmBlockEntity;
import com.zurrtum.create.content.kinetics.simpleRelays.ICogWheel;
import com.zurrtum.create.foundation.block.IBE;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;

public class ArmBlock
extends KineticBlock
implements IBE<ArmBlockEntity>,
ICogWheel {
    public static final BooleanProperty CEILING = BooleanProperty.create((String)"ceiling");

    public ArmBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)CEILING, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_206840_1_) {
        super.createBlockStateDefinition(p_206840_1_.add(new Property[]{CEILING}));
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)CEILING, (Comparable)Boolean.valueOf(ctx.getClickedFace() == Direction.DOWN));
    }

    public VoxelShape getShape(BlockState state, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        return (Boolean)state.getValue((Property)CEILING) != false ? AllShapes.MECHANICAL_ARM_CEILING : AllShapes.MECHANICAL_ARM;
    }

    @Override
    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, world, pos, oldState, isMoving);
        this.withBlockEntityDo((BlockGetter)world, pos, ArmBlockEntity::redstoneUpdate);
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block p_220069_4_, @Nullable Orientation wireOrientation, boolean p_220069_6_) {
        this.withBlockEntityDo((BlockGetter)world, pos, ArmBlockEntity::redstoneUpdate);
    }

    @Override
    public Direction.Axis getRotationAxis(BlockState state) {
        return Direction.Axis.Y;
    }

    @Override
    public Class<ArmBlockEntity> getBlockEntityClass() {
        return ArmBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends ArmBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.MECHANICAL_ARM;
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        InteractionResult gogglesResult;
        if (stack.is((Item)AllItems.GOGGLES) && (gogglesResult = this.onBlockEntityUseItemOn((BlockGetter)level, pos, ate -> {
            if (ate.goggles) {
                return InteractionResult.TRY_WITH_EMPTY_HAND;
            }
            ate.goggles = true;
            ate.notifyUpdate();
            return InteractionResult.SUCCESS;
        })).consumesAction()) {
            return gogglesResult;
        }
        MutableBoolean success = new MutableBoolean(false);
        this.withBlockEntityDo((BlockGetter)level, pos, be -> {
            if (be.heldItem.isEmpty()) {
                return;
            }
            success.setTrue();
            if (level.isClientSide()) {
                return;
            }
            player.getInventory().placeItemBackInInventory(be.heldItem);
            be.heldItem = ItemStack.EMPTY;
            be.phase = ArmBlockEntity.Phase.SEARCH_INPUTS;
            be.setChanged();
            be.sendData();
        });
        return success.booleanValue() ? InteractionResult.SUCCESS : InteractionResult.TRY_WITH_EMPTY_HAND;
    }
}

