/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.mechanicalArm;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.Create;
import com.zurrtum.create.api.contraption.transformable.TransformableBlockEntity;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.content.contraptions.StructureTransform;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.mechanicalArm.AllArmInteractionPointTypes;
import com.zurrtum.create.content.kinetics.mechanicalArm.ArmAngleTarget;
import com.zurrtum.create.content.kinetics.mechanicalArm.ArmBlock;
import com.zurrtum.create.content.kinetics.mechanicalArm.ArmInteractionPoint;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue.ServerScrollOptionBehaviour;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class ArmBlockEntity
extends KineticBlockEntity
implements TransformableBlockEntity {
    public Codec<ArmInteractionPoint> pointCodec;
    public List<ArmInteractionPoint> inputs = new ArrayList<ArmInteractionPoint>();
    public List<ArmInteractionPoint> outputs = new ArrayList<ArmInteractionPoint>();
    public ListTag interactionPointTag = null;
    float chasedPointProgress;
    int chasedPointIndex;
    public ItemStack heldItem = ItemStack.EMPTY;
    public Phase phase = Phase.SEARCH_INPUTS;
    public boolean goggles;
    ArmAngleTarget previousTarget = ArmAngleTarget.NO_TARGET;
    public LerpedFloat lowerArmAngle;
    public LerpedFloat upperArmAngle;
    public LerpedFloat baseAngle = LerpedFloat.angular();
    public LerpedFloat headAngle;
    LerpedFloat clawAngle;
    float previousBaseAngle;
    boolean updateInteractionPoints;
    public int tooltipWarmup;
    protected ServerScrollOptionBehaviour<SelectionMode> selectionMode;
    protected int lastInputIndex = -1;
    protected int lastOutputIndex = -1;
    protected boolean redstoneLocked;

    public ArmBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.MECHANICAL_ARM, pos, state);
        this.baseAngle.startWithValue(this.previousTarget.baseAngle);
        this.lowerArmAngle = LerpedFloat.angular();
        this.lowerArmAngle.startWithValue(this.previousTarget.lowerArmAngle);
        this.upperArmAngle = LerpedFloat.angular();
        this.upperArmAngle.startWithValue(this.previousTarget.upperArmAngle);
        this.headAngle = LerpedFloat.angular();
        this.headAngle.startWithValue(this.previousTarget.headAngle);
        this.clawAngle = LerpedFloat.angular();
        this.previousBaseAngle = this.previousTarget.baseAngle;
        this.updateInteractionPoints = true;
        this.redstoneLocked = false;
        this.tooltipWarmup = 15;
        this.goggles = false;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        super.addBehaviours(behaviours);
        this.selectionMode = new ServerScrollOptionBehaviour<SelectionMode>(SelectionMode.class, this);
        behaviours.add(this.selectionMode);
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.ARM_BLAZE_BURNER, AllAdvancements.ARM_MANY_TARGETS, AllAdvancements.MECHANICAL_ARM, AllAdvancements.MUSICAL_ARM);
    }

    @Override
    public void tick() {
        super.tick();
        this.initInteractionPoints();
        boolean targetReached = this.tickMovementProgress();
        if (this.tooltipWarmup > 0) {
            --this.tooltipWarmup;
        }
        if (this.chasedPointProgress < 1.0f) {
            ArmInteractionPoint point;
            if (this.phase == Phase.MOVE_TO_INPUT && (point = this.getTargetedInteractionPoint()) != null) {
                point.keepAlive();
            }
            return;
        }
        if (this.level.isClientSide()) {
            return;
        }
        if (this.phase == Phase.MOVE_TO_INPUT) {
            this.collectItem();
        } else if (this.phase == Phase.MOVE_TO_OUTPUT) {
            this.depositItem();
        } else if (this.phase == Phase.SEARCH_INPUTS || this.phase == Phase.DANCING) {
            this.searchForItem();
        }
        if (targetReached) {
            this.lazyTick();
        }
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.level.isClientSide()) {
            return;
        }
        if (this.chasedPointProgress < 0.5f) {
            return;
        }
        if (this.phase == Phase.SEARCH_INPUTS || this.phase == Phase.DANCING) {
            this.checkForMusic();
        }
        if (this.phase == Phase.SEARCH_OUTPUTS) {
            this.searchForDestination();
        }
    }

    private void checkForMusic() {
        boolean hasMusic = this.checkForMusicAmong(this.inputs) || this.checkForMusicAmong(this.outputs);
        if (hasMusic != (this.phase == Phase.DANCING)) {
            this.phase = hasMusic ? Phase.DANCING : Phase.SEARCH_INPUTS;
            this.setChanged();
            this.sendData();
        }
    }

    @Override
    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().inflate(3.0);
    }

    private boolean checkForMusicAmong(List<ArmInteractionPoint> list) {
        for (ArmInteractionPoint armInteractionPoint : list) {
            BlockState state;
            if (!(armInteractionPoint instanceof AllArmInteractionPointTypes.JukeboxPoint) || !((Boolean)(state = this.level.getBlockState(armInteractionPoint.getPos())).getValueOrElse((Property)JukeboxBlock.HAS_RECORD, (Comparable)Boolean.valueOf(false))).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private boolean tickMovementProgress() {
        boolean targetReachedPreviously = this.chasedPointProgress >= 1.0f;
        this.chasedPointProgress += Math.min(256.0f, Math.abs(this.getSpeed())) / 1024.0f;
        if (this.chasedPointProgress > 1.0f) {
            this.chasedPointProgress = 1.0f;
        }
        if (!this.level.isClientSide()) {
            return !targetReachedPreviously && this.chasedPointProgress >= 1.0f;
        }
        ArmInteractionPoint targetedInteractionPoint = this.getTargetedInteractionPoint();
        ArmAngleTarget previousTarget = this.previousTarget;
        ArmAngleTarget target = targetedInteractionPoint == null ? ArmAngleTarget.NO_TARGET : targetedInteractionPoint.getTargetAngles(this.worldPosition, this.isOnCeiling());
        this.baseAngle.setValue(AngleHelper.angleLerp(this.chasedPointProgress, this.previousBaseAngle, target == ArmAngleTarget.NO_TARGET ? (double)this.previousBaseAngle : (double)target.baseAngle));
        if (this.chasedPointProgress < 0.5f) {
            target = ArmAngleTarget.NO_TARGET;
        } else {
            previousTarget = ArmAngleTarget.NO_TARGET;
        }
        float progress = this.chasedPointProgress == 1.0f ? 1.0f : this.chasedPointProgress % 0.5f * 2.0f;
        this.lowerArmAngle.setValue(Mth.lerp((float)progress, (float)previousTarget.lowerArmAngle, (float)target.lowerArmAngle));
        this.upperArmAngle.setValue(Mth.lerp((float)progress, (float)previousTarget.upperArmAngle, (float)target.upperArmAngle));
        this.headAngle.setValue(AngleHelper.angleLerp(progress, previousTarget.headAngle % 360.0f, target.headAngle % 360.0f));
        return false;
    }

    protected boolean isOnCeiling() {
        BlockState state = this.getBlockState();
        return this.hasLevel() && (Boolean)state.getValueOrElse((Property)ArmBlock.CEILING, (Comparable)Boolean.valueOf(false)) != false;
    }

    @Override
    public void destroy() {
        super.destroy();
        if (!this.heldItem.isEmpty()) {
            Block.popResource((Level)this.level, (BlockPos)this.worldPosition, (ItemStack)this.heldItem);
        }
    }

    @Nullable
    private ArmInteractionPoint getTargetedInteractionPoint() {
        if (this.chasedPointIndex == -1) {
            return null;
        }
        if (this.phase == Phase.MOVE_TO_INPUT && this.chasedPointIndex < this.inputs.size()) {
            return this.inputs.get(this.chasedPointIndex);
        }
        if (this.phase == Phase.MOVE_TO_OUTPUT && this.chasedPointIndex < this.outputs.size()) {
            return this.outputs.get(this.chasedPointIndex);
        }
        return null;
    }

    protected void searchForItem() {
        int scanRange;
        if (this.redstoneLocked) {
            return;
        }
        boolean foundInput = false;
        int startIndex = this.selectionMode.get() == SelectionMode.PREFER_FIRST ? 0 : this.lastInputIndex + 1;
        int n = scanRange = this.selectionMode.get() == SelectionMode.FORCED_ROUND_ROBIN ? this.lastInputIndex + 2 : this.inputs.size();
        if (scanRange > this.inputs.size()) {
            scanRange = this.inputs.size();
        }
        block0: for (int i = startIndex; i < scanRange; ++i) {
            ArmInteractionPoint armInteractionPoint = this.inputs.get(i);
            if (!armInteractionPoint.isValid()) continue;
            for (int j = 0; j < armInteractionPoint.getSlotCount(this); ++j) {
                if (this.getDistributableAmount(armInteractionPoint, j) == 0) continue;
                this.selectIndex(true, i);
                foundInput = true;
                break block0;
            }
        }
        if (!foundInput && this.selectionMode.get() == SelectionMode.ROUND_ROBIN) {
            this.lastInputIndex = -1;
        }
        if (this.lastInputIndex == this.inputs.size() - 1) {
            this.lastInputIndex = -1;
        }
    }

    protected void searchForDestination() {
        int scanRange;
        ItemStack held = this.heldItem.copy();
        boolean foundOutput = false;
        int startIndex = this.selectionMode.get() == SelectionMode.PREFER_FIRST ? 0 : this.lastOutputIndex + 1;
        int n = scanRange = this.selectionMode.get() == SelectionMode.FORCED_ROUND_ROBIN ? this.lastOutputIndex + 2 : this.outputs.size();
        if (scanRange > this.outputs.size()) {
            scanRange = this.outputs.size();
        }
        for (int i = startIndex; i < scanRange; ++i) {
            ItemStack remainder;
            ArmInteractionPoint armInteractionPoint = this.outputs.get(i);
            if (!armInteractionPoint.isValid() || ItemStack.matches((ItemStack)(remainder = armInteractionPoint.insert(this, held, true)), (ItemStack)this.heldItem)) continue;
            this.selectIndex(false, i);
            foundOutput = true;
            break;
        }
        if (!foundOutput && this.selectionMode.get() == SelectionMode.ROUND_ROBIN) {
            this.lastOutputIndex = -1;
        }
        if (this.lastOutputIndex == this.outputs.size() - 1) {
            this.lastOutputIndex = -1;
        }
    }

    private void selectIndex(boolean input, int index) {
        this.phase = input ? Phase.MOVE_TO_INPUT : Phase.MOVE_TO_OUTPUT;
        this.chasedPointIndex = index;
        this.chasedPointProgress = 0.0f;
        if (input) {
            this.lastInputIndex = index;
        } else {
            this.lastOutputIndex = index;
        }
        this.sendData();
        this.setChanged();
    }

    protected int getDistributableAmount(ArmInteractionPoint armInteractionPoint, int i) {
        ItemStack remainder;
        ItemStack stack = armInteractionPoint.extract(this, i, true);
        if (ItemStack.isSameItem((ItemStack)stack, (ItemStack)(remainder = this.simulateInsertion(stack)))) {
            return stack.getCount() - remainder.getCount();
        }
        return stack.getCount();
    }

    private ItemStack simulateInsertion(ItemStack stack) {
        for (ArmInteractionPoint armInteractionPoint : this.outputs) {
            if (armInteractionPoint.isValid()) {
                stack = armInteractionPoint.insert(this, stack, true);
            }
            if (!stack.isEmpty()) continue;
            break;
        }
        return stack;
    }

    protected void depositItem() {
        ArmInteractionPoint armInteractionPoint = this.getTargetedInteractionPoint();
        if (armInteractionPoint != null && armInteractionPoint.isValid()) {
            ItemStack remainder;
            ItemStack toInsert = this.heldItem.copy();
            this.heldItem = remainder = armInteractionPoint.insert(this, toInsert, false);
            if (armInteractionPoint instanceof AllArmInteractionPointTypes.JukeboxPoint && remainder.isEmpty()) {
                this.award(AllAdvancements.MUSICAL_ARM);
            }
        }
        this.phase = this.heldItem.isEmpty() ? Phase.SEARCH_INPUTS : Phase.SEARCH_OUTPUTS;
        this.chasedPointProgress = 0.0f;
        this.chasedPointIndex = -1;
        this.sendData();
        this.setChanged();
        if (!this.level.isClientSide()) {
            this.award(AllAdvancements.MECHANICAL_ARM);
        }
    }

    protected void collectItem() {
        ArmInteractionPoint armInteractionPoint = this.getTargetedInteractionPoint();
        if (armInteractionPoint != null && armInteractionPoint.isValid()) {
            for (int i = 0; i < armInteractionPoint.getSlotCount(this); ++i) {
                int amountExtracted = this.getDistributableAmount(armInteractionPoint, i);
                if (amountExtracted == 0) continue;
                ItemStack prevHeld = this.heldItem;
                this.heldItem = armInteractionPoint.extract(this, i, amountExtracted, false);
                this.phase = Phase.SEARCH_OUTPUTS;
                this.chasedPointProgress = 0.0f;
                this.chasedPointIndex = -1;
                this.sendData();
                this.setChanged();
                if (!ItemStack.isSameItem((ItemStack)this.heldItem, (ItemStack)prevHeld)) {
                    this.level.playSound(null, this.worldPosition, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 0.125f, 0.5f + this.level.random.nextFloat() * 0.25f);
                }
                return;
            }
        }
        this.phase = Phase.SEARCH_INPUTS;
        this.chasedPointProgress = 0.0f;
        this.chasedPointIndex = -1;
        this.sendData();
        this.setChanged();
    }

    public void redstoneUpdate() {
        if (this.level.isClientSide()) {
            return;
        }
        boolean blockPowered = this.level.hasNeighborSignal(this.worldPosition);
        if (blockPowered == this.redstoneLocked) {
            return;
        }
        this.redstoneLocked = blockPowered;
        this.sendData();
        if (!this.redstoneLocked) {
            this.searchForItem();
        }
    }

    @Override
    public void transform(BlockEntity be, StructureTransform transform) {
        if (this.interactionPointTag == null) {
            return;
        }
        for (Tag tag : this.interactionPointTag) {
            ArmInteractionPoint.transformPos((CompoundTag)tag, transform);
        }
        this.notifyUpdate();
    }

    protected boolean isAreaActuallyLoaded(BlockPos center, int range) {
        if (!this.level.hasChunksAt(center.offset(-range, -range, -range), center.offset(range, range, range))) {
            return false;
        }
        if (this.level.isClientSide()) {
            int minY = center.getY() - range;
            int maxY = center.getY() + range;
            if (maxY < this.level.getMinY() || minY >= this.level.getMaxY()) {
                return false;
            }
            int minX = center.getX() - range;
            int minZ = center.getZ() - range;
            int maxX = center.getX() + range;
            int maxZ = center.getZ() + range;
            int minChunkX = SectionPos.blockToSectionCoord((int)minX);
            int maxChunkX = SectionPos.blockToSectionCoord((int)maxX);
            int minChunkZ = SectionPos.blockToSectionCoord((int)minZ);
            int maxChunkZ = SectionPos.blockToSectionCoord((int)maxZ);
            ChunkSource chunkSource = this.level.getChunkSource();
            for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
                for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                    if (chunkSource.hasChunk(chunkX, chunkZ)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected void initInteractionPoints() {
        if (!this.updateInteractionPoints || this.interactionPointTag == null) {
            return;
        }
        if (!this.isAreaActuallyLoaded(this.worldPosition, ArmBlockEntity.getRange() + 1)) {
            return;
        }
        this.inputs.clear();
        this.outputs.clear();
        boolean hasBlazeBurner = false;
        if (this.pointCodec == null) {
            this.pointCodec = ArmInteractionPoint.getCodec(this.level, this.worldPosition);
        }
        for (Tag tag : this.interactionPointTag) {
            BlockState state;
            ArmInteractionPoint point = this.decodePoint(tag);
            if (point == null || !point.type.canCreatePoint(this.level, point.pos, state = this.level.getBlockState(point.pos))) continue;
            if (point.getMode() == ArmInteractionPoint.Mode.DEPOSIT) {
                this.outputs.add(point);
            } else if (point.getMode() == ArmInteractionPoint.Mode.TAKE) {
                this.inputs.add(point);
            }
            hasBlazeBurner |= point instanceof AllArmInteractionPointTypes.BlazeBurnerPoint;
        }
        if (!this.level.isClientSide()) {
            if (this.outputs.size() >= 10) {
                this.award(AllAdvancements.ARM_MANY_TARGETS);
            }
            if (hasBlazeBurner) {
                this.award(AllAdvancements.ARM_BLAZE_BURNER);
            }
        }
        this.updateInteractionPoints = false;
        this.sendData();
        this.setChanged();
    }

    public void writeInteractionPoints(ValueOutput view) {
        ListTag list;
        if (this.pointCodec == null) {
            this.pointCodec = ArmInteractionPoint.getCodec(this.level, this.worldPosition);
        }
        if (this.updateInteractionPoints && this.interactionPointTag != null) {
            list = this.interactionPointTag;
        } else {
            list = new ListTag();
            ArmBlockEntity.appendEncodedPoints(this.inputs, this.pointCodec, list);
            ArmBlockEntity.appendEncodedPoints(this.outputs, this.pointCodec, list);
        }
        view.store("InteractionPoints", CreateCodecs.NBT_LIST_CODEC, (Object)list);
    }

    public static void appendEncodedPoints(List<ArmInteractionPoint> points, Codec<ArmInteractionPoint> pointCodec, ListTag list) {
        block4: for (ArmInteractionPoint point : points) {
            DataResult dataResult;
            Objects.requireNonNull(pointCodec.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)point));
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataResult.Success.class, DataResult.Error.class}, (Object)dataResult, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    DataResult.Success success = (DataResult.Success)dataResult;
                    list.add((Object)((Tag)success.value()));
                    continue block4;
                }
                case 1: 
            }
            DataResult.Error error = (DataResult.Error)dataResult;
            Create.LOGGER.warn("Failed to append value '{}' to list 'InteractionPoints': {}", (Object)point, (Object)error.message());
        }
    }

    public ArmInteractionPoint decodePoint(Tag tag) {
        DataResult dataResult = this.pointCodec.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag);
        Objects.requireNonNull(dataResult);
        DataResult dataResult2 = dataResult;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataResult.Success.class, DataResult.Error.class}, (Object)dataResult2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                DataResult.Success success = (DataResult.Success)dataResult2;
                yield (ArmInteractionPoint)success.value();
            }
            case 1 -> {
                DataResult.Error error = (DataResult.Error)dataResult2;
                Create.LOGGER.warn("Failed to decode value '{}' from field 'InteractionPoints': {}", (Object)tag, (Object)error.message());
                yield null;
            }
        };
    }

    @Override
    public void write(ValueOutput view, boolean clientPacket) {
        super.write(view, clientPacket);
        this.writeInteractionPoints(view);
        view.store("Phase", Phase.CODEC, (Object)this.phase);
        view.putBoolean("Powered", this.redstoneLocked);
        view.putBoolean("Goggles", this.goggles);
        if (!this.heldItem.isEmpty()) {
            view.store("HeldItem", ItemStack.CODEC, (Object)this.heldItem);
        }
        view.putInt("TargetPointIndex", this.chasedPointIndex);
        view.putFloat("MovementProgress", this.chasedPointProgress);
    }

    @Override
    public void writeSafe(ValueOutput view) {
        super.writeSafe(view);
        this.writeInteractionPoints(view);
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        int previousIndex = this.chasedPointIndex;
        Phase previousPhase = this.phase;
        ListTag interactionPointTagBefore = this.interactionPointTag;
        super.read(view, clientPacket);
        this.heldItem = view.read("HeldItem", ItemStack.CODEC).orElse(ItemStack.EMPTY);
        this.phase = view.read("Phase", Phase.CODEC).orElse(Phase.SEARCH_INPUTS);
        this.chasedPointIndex = view.getIntOr("TargetPointIndex", 0);
        this.chasedPointProgress = view.getFloatOr("MovementProgress", 0.0f);
        this.interactionPointTag = view.read("InteractionPoints", CreateCodecs.NBT_LIST_CODEC).orElseGet(ListTag::new);
        this.redstoneLocked = view.getBooleanOr("Powered", false);
        boolean hadGoggles = this.goggles;
        this.goggles = view.getBooleanOr("Goggles", false);
        if (!clientPacket) {
            return;
        }
        if (hadGoggles != this.goggles && this.level.isClientSide()) {
            AllClientHandle.INSTANCE.queueUpdate(this);
        }
        boolean ceiling = this.isOnCeiling();
        if (interactionPointTagBefore == null || interactionPointTagBefore.size() != this.interactionPointTag.size()) {
            this.updateInteractionPoints = true;
        }
        if (previousIndex != this.chasedPointIndex || previousPhase != this.phase) {
            ArmInteractionPoint targetedPoint;
            ArmInteractionPoint previousPoint = null;
            if (previousPhase == Phase.MOVE_TO_INPUT && previousIndex < this.inputs.size()) {
                previousPoint = this.inputs.get(previousIndex);
            }
            if (previousPhase == Phase.MOVE_TO_OUTPUT && previousIndex < this.outputs.size()) {
                previousPoint = this.outputs.get(previousIndex);
            }
            ArmAngleTarget armAngleTarget = this.previousTarget = previousPoint == null ? ArmAngleTarget.NO_TARGET : previousPoint.getTargetAngles(this.worldPosition, ceiling);
            if (previousPoint != null) {
                this.previousBaseAngle = this.previousTarget.baseAngle;
            }
            if ((targetedPoint = this.getTargetedInteractionPoint()) != null) {
                targetedPoint.updateCachedState();
            }
        }
    }

    public static int getRange() {
        return (Integer)AllConfigs.server().logistics.mechanicalArmRange.get();
    }

    public void setLevel(Level level) {
        super.setLevel(level);
        for (ArmInteractionPoint input : this.inputs) {
            input.setLevel(level);
        }
        for (ArmInteractionPoint output : this.outputs) {
            output.setLevel(level);
        }
    }

    public static enum Phase implements StringRepresentable
    {
        SEARCH_INPUTS,
        MOVE_TO_INPUT,
        SEARCH_OUTPUTS,
        MOVE_TO_OUTPUT,
        DANCING;

        public static final Codec<Phase> CODEC;

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromEnum(Phase::values);
        }
    }

    public static enum SelectionMode {
        ROUND_ROBIN,
        FORCED_ROUND_ROBIN,
        PREFER_FIRST;

    }
}

