/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.mechanicalArm;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.api.registry.CreateRegistries;
import com.zurrtum.create.catnip.codecs.stream.CatnipStreamCodecBuilders;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.catnip.nbt.NBTHelper;
import com.zurrtum.create.content.contraptions.StructureTransform;
import com.zurrtum.create.content.kinetics.mechanicalArm.ArmAngleTarget;
import com.zurrtum.create.content.kinetics.mechanicalArm.ArmBlockEntity;
import com.zurrtum.create.content.kinetics.mechanicalArm.ArmInteractionPointType;
import com.zurrtum.create.foundation.item.ItemHelper;
import io.netty.buffer.ByteBuf;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ArmInteractionPoint {
    protected final ArmInteractionPointType type;
    protected Level level;
    protected BlockPos pos;
    protected Mode mode = Mode.DEPOSIT;
    protected BlockState cachedState;
    protected Supplier<Container> cachedHandler;
    protected ArmAngleTarget cachedAngles;

    public static Codec<ArmInteractionPoint> getCodec(Level world, BlockPos anchor) {
        return RecordCodecBuilder.create(instance -> instance.group((App)CreateRegistries.ARM_INTERACTION_POINT_TYPE.byNameCodec().fieldOf("Type").forGetter(ArmInteractionPoint::getType), (App)BlockPos.CODEC.fieldOf("Pos").forGetter(point -> point.pos.subtract((Vec3i)anchor)), (App)Mode.CODEC.fieldOf("Mode").forGetter(ArmInteractionPoint::getMode)).apply((Applicative)instance, (type, pos, mode) -> {
            BlockState state;
            if (!type.canCreatePoint(world, pos = pos.offset((Vec3i)anchor), state = world.getBlockState(pos))) {
                return null;
            }
            ArmInteractionPoint point = type.createPoint(world, (BlockPos)pos, state);
            if (point == null) {
                return null;
            }
            point.mode = mode;
            return point;
        }));
    }

    public ArmInteractionPoint(ArmInteractionPointType type, Level level, BlockPos pos, BlockState state) {
        this.type = type;
        this.level = level;
        this.pos = pos;
        this.cachedState = state;
    }

    public ArmInteractionPointType getType() {
        return this.type;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public void relativePos(BlockPos pos) {
        this.pos = this.pos.subtract((Vec3i)pos);
    }

    public void absolutePos(BlockPos pos) {
        this.pos = this.pos.offset((Vec3i)pos);
    }

    public Mode getMode() {
        return this.mode;
    }

    public void cycleMode() {
        this.mode = this.mode == Mode.DEPOSIT ? Mode.TAKE : Mode.DEPOSIT;
    }

    protected Vec3 getInteractionPositionVector() {
        return VecHelper.getCenterOf((Vec3i)this.pos);
    }

    protected Direction getInteractionDirection() {
        return Direction.DOWN;
    }

    public ArmAngleTarget getTargetAngles(BlockPos armPos, boolean ceiling) {
        if (this.cachedAngles == null) {
            this.cachedAngles = new ArmAngleTarget(armPos, this.getInteractionPositionVector(), this.getInteractionDirection(), ceiling);
        }
        return this.cachedAngles;
    }

    public void updateCachedState() {
        this.cachedState = this.level.getBlockState(this.pos);
    }

    public boolean isValid() {
        this.updateCachedState();
        return this.type.canCreatePoint(this.level, this.pos, this.cachedState);
    }

    public void keepAlive() {
    }

    @Nullable
    protected Container getHandler(ArmBlockEntity armBlockEntity) {
        Level level;
        if (this.cachedHandler == null && (level = this.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockEntity be = this.level.getBlockEntity(this.pos);
            if (be == null) {
                return null;
            }
            this.cachedHandler = ItemHelper.getInventoryCache(serverLevel, this.pos, Direction.UP, (blockEntity, direction) -> !armBlockEntity.isRemoved());
        }
        return this.cachedHandler.get();
    }

    public ItemStack insert(ArmBlockEntity armBlockEntity, ItemStack stack, boolean simulate) {
        Container handler = this.getHandler(armBlockEntity);
        if (handler == null) {
            return stack;
        }
        int insert = simulate ? handler.countSpace(stack, Direction.UP) : handler.insert(stack, Direction.UP);
        if (insert == 0) {
            return stack;
        }
        int count = stack.getCount();
        if (insert == count) {
            return ItemStack.EMPTY;
        }
        return stack.copyWithCount(count - insert);
    }

    public ItemStack extract(ArmBlockEntity armBlockEntity, int slot, int amount, boolean simulate) {
        Container handler = this.getHandler(armBlockEntity);
        if (handler == null) {
            return ItemStack.EMPTY;
        }
        if (simulate) {
            return handler.count(stack -> true, amount, Direction.UP);
        }
        return handler.extract(stack -> true, amount, Direction.UP);
    }

    public ItemStack extract(ArmBlockEntity armBlockEntity, int slot, boolean simulate) {
        return this.extract(armBlockEntity, slot, 64, simulate);
    }

    public int getSlotCount(ArmBlockEntity armBlockEntity) {
        Container handler = this.getHandler(armBlockEntity);
        if (handler == null) {
            return 0;
        }
        return handler.getContainerSize();
    }

    protected void serialize(CompoundTag nbt, BlockPos anchor) {
        NBTHelper.writeEnum(nbt, "Mode", this.mode);
    }

    protected void deserialize(CompoundTag nbt, BlockPos anchor) {
        this.mode = NBTHelper.readEnum(nbt, "Mode", Mode.class);
    }

    public final CompoundTag serialize(BlockPos anchor) {
        Identifier key = CreateRegistries.ARM_INTERACTION_POINT_TYPE.getKey((Object)this.type);
        if (key == null) {
            throw new IllegalArgumentException("Could not get id for ArmInteractionPointType " + String.valueOf(this.type) + "!");
        }
        CompoundTag nbt = new CompoundTag();
        nbt.putString("Type", key.toString());
        nbt.store("Pos", BlockPos.CODEC, (Object)this.pos.subtract((Vec3i)anchor));
        this.serialize(nbt, anchor);
        return nbt;
    }

    @Nullable
    public static ArmInteractionPoint deserialize(CompoundTag nbt, Level level, BlockPos anchor) {
        BlockState state;
        Identifier id = Identifier.tryParse((String)nbt.getStringOr("Type", ""));
        if (id == null) {
            return null;
        }
        ArmInteractionPointType type = (ArmInteractionPointType)CreateRegistries.ARM_INTERACTION_POINT_TYPE.getValue(id);
        if (type == null) {
            return null;
        }
        BlockPos pos = NBTHelper.readBlockPos(nbt, "Pos").offset((Vec3i)anchor);
        if (!type.canCreatePoint(level, pos, state = level.getBlockState(pos))) {
            return null;
        }
        ArmInteractionPoint point = type.createPoint(level, pos, state);
        if (point == null) {
            return null;
        }
        point.deserialize(nbt, anchor);
        return point;
    }

    public static void transformPos(CompoundTag nbt, StructureTransform transform) {
        BlockPos pos = nbt.read("Pos", BlockPos.CODEC).orElse(BlockPos.ZERO);
        pos = transform.applyWithoutOffset(pos);
        nbt.store("Pos", BlockPos.CODEC, (Object)pos);
    }

    public static boolean isInteractable(Level level, BlockPos pos, BlockState state) {
        return ArmInteractionPointType.getPrimaryType(level, pos, state) != null;
    }

    @Nullable
    public static ArmInteractionPoint create(Level level, BlockPos pos, BlockState state) {
        ArmInteractionPointType type = ArmInteractionPointType.getPrimaryType(level, pos, state);
        if (type == null) {
            return null;
        }
        return type.createPoint(level, pos, state);
    }

    public static enum Mode implements StringRepresentable
    {
        DEPOSIT("create.mechanical_arm.deposit_to", 14532966),
        TAKE("create.mechanical_arm.extract_from", 8375776);

        public static final Codec<Mode> CODEC;
        public static final StreamCodec<ByteBuf, Mode> PACKET_CODEC;
        private final String translationKey;
        private final int color;

        private Mode(String translationKey, int color) {
            this.translationKey = translationKey;
            this.color = color;
        }

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public String getTranslationKey() {
            return this.translationKey;
        }

        public int getColor() {
            return this.color;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Mode::values);
            PACKET_CODEC = CatnipStreamCodecBuilders.ofEnum(Mode.class);
        }
    }
}

