/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.millstone;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.zurrtum.create.content.kinetics.millstone.MillingRecipe;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.infrastructure.items.SidedItemInventory;
import com.zurrtum.create.infrastructure.transfer.SlotRangeCache;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class MillstoneBlockEntity
extends KineticBlockEntity {
    public MillstoneInventoryHandler capability = new MillstoneInventoryHandler();
    public int timer;
    private MillingRecipe lastRecipe;

    public MillstoneBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.MILLSTONE, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        behaviours.add(new DirectBeltInputBehaviour(this));
        super.addBehaviours(behaviours);
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.MILLSTONE);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.getSpeed() == 0.0f) {
            return;
        }
        int size = this.capability.getContainerSize();
        for (int i = 1; i < size; ++i) {
            ItemStack stack = this.capability.getItem(i);
            if (stack.getCount() != this.capability.getMaxStackSize(stack)) continue;
            return;
        }
        if (this.timer > 0) {
            this.timer -= this.getProcessingSpeed();
            if (this.level.isClientSide()) {
                this.spawnParticles();
                return;
            }
            if (this.timer <= 0) {
                this.process();
            }
            return;
        }
        if (this.level.isClientSide()) {
            return;
        }
        ItemStack stack = this.capability.getItem(0);
        if (stack.isEmpty()) {
            return;
        }
        SingleRecipeInput input = new SingleRecipeInput(stack);
        if (this.lastRecipe == null || !this.lastRecipe.matches(input, this.level)) {
            Optional recipe = ((ServerLevel)this.level).recipeAccess().getRecipeFor(AllRecipeTypes.MILLING, (RecipeInput)input, this.level);
            if (recipe.isEmpty()) {
                this.timer = 100;
                this.sendData();
            } else {
                this.lastRecipe = (MillingRecipe)((RecipeHolder)recipe.get()).value();
                this.timer = this.lastRecipe.time();
                this.sendData();
            }
            return;
        }
        this.timer = this.lastRecipe.time();
        this.sendData();
    }

    @Override
    public void destroy() {
        super.destroy();
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)this.capability);
    }

    private void process() {
        ItemStack stack = this.capability.getItem(0);
        SingleRecipeInput input = new SingleRecipeInput(stack);
        if (this.lastRecipe == null || !this.lastRecipe.matches(input, this.level)) {
            Optional recipe = ((ServerLevel)this.level).recipeAccess().getRecipeFor(AllRecipeTypes.MILLING, (RecipeInput)input, this.level);
            if (recipe.isEmpty()) {
                return;
            }
            this.lastRecipe = (MillingRecipe)((RecipeHolder)recipe.get()).value();
        }
        ItemStack recipeRemainder = stack.getItem().getCraftingRemainder();
        stack.shrink(1);
        this.capability.setItem(0, stack);
        this.capability.outputAllowInsertion();
        List<ItemStack> list = this.lastRecipe.assemble(input, this.level.random);
        if (!recipeRemainder.isEmpty()) {
            list.add(recipeRemainder);
        }
        this.capability.insert(list);
        this.capability.outputForbidInsertion();
        this.award(AllAdvancements.MILLSTONE);
        this.sendData();
        this.setChanged();
    }

    public void spawnParticles() {
        ItemStack stackInSlot = this.capability.getItem(0);
        if (stackInSlot.isEmpty()) {
            return;
        }
        ItemParticleOption data = new ItemParticleOption(ParticleTypes.ITEM, stackInSlot);
        float angle = this.level.random.nextFloat() * 360.0f;
        Vec3 offset = new Vec3(0.0, 0.0, 0.5);
        offset = VecHelper.rotate(offset, angle, Direction.Axis.Y);
        Vec3 target = VecHelper.rotate(offset, this.getSpeed() > 0.0f ? 25.0 : -25.0, Direction.Axis.Y);
        Vec3 center = offset.add(VecHelper.getCenterOf((Vec3i)this.worldPosition));
        target = VecHelper.offsetRandomly(target.subtract(offset), this.level.random, 0.0078125f);
        this.level.addParticle((ParticleOptions)data, center.x, center.y, center.z, target.x, target.y, target.z);
    }

    @Override
    public void write(ValueOutput view, boolean clientPacket) {
        view.putInt("Timer", this.timer);
        this.capability.write(view);
        super.write(view, clientPacket);
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        this.timer = view.getIntOr("Timer", 0);
        this.capability.read(view);
        super.read(view, clientPacket);
    }

    public int getProcessingSpeed() {
        return Mth.clamp((int)((int)Math.abs(this.getSpeed() / 16.0f)), (int)1, (int)512);
    }

    private boolean canProcess(ItemStack stack) {
        SingleRecipeInput input = new SingleRecipeInput(stack);
        if (this.lastRecipe != null && this.lastRecipe.matches(input, this.level)) {
            return true;
        }
        Optional recipe = ((ServerLevel)this.level).recipeAccess().getRecipeFor(AllRecipeTypes.MILLING, (RecipeInput)input, this.level);
        if (recipe.isEmpty()) {
            return false;
        }
        this.lastRecipe = (MillingRecipe)((RecipeHolder)recipe.get()).value();
        return true;
    }

    public class MillstoneInventoryHandler
    implements SidedItemInventory {
        private static final int[] SLOTS = SlotRangeCache.get(10);
        private final NonNullList<ItemStack> stacks = NonNullList.withSize((int)10, (Object)ItemStack.EMPTY);
        private boolean check = true;

        public void outputAllowInsertion() {
            this.check = false;
        }

        public void outputForbidInsertion() {
            this.check = true;
        }

        public int getContainerSize() {
            return 10;
        }

        public int[] getSlotsForFace(Direction side) {
            return SLOTS;
        }

        public boolean canPlaceItem(int slot, ItemStack stack) {
            return !this.check || MillstoneBlockEntity.this.canProcess(stack);
        }

        public boolean canPlaceItemThroughFace(int slot, ItemStack stack, @Nullable Direction dir) {
            return this.check ? slot == 0 : slot > 0;
        }

        public boolean canTakeItemThroughFace(int slot, ItemStack stack, Direction dir) {
            return slot != 0;
        }

        public ItemStack getItem(int slot) {
            if (slot >= 10) {
                return ItemStack.EMPTY;
            }
            return (ItemStack)this.stacks.get(slot);
        }

        public void setItem(int slot, ItemStack stack) {
            if (slot >= 10) {
                return;
            }
            this.stacks.set(slot, (Object)stack);
        }

        @Override
        public void setChanged() {
            MillstoneBlockEntity.this.setChanged();
        }

        public void write(ValueOutput view) {
            ValueOutput.TypedOutputList list = view.list("Inventory", ItemStack.OPTIONAL_CODEC);
            list.add((Object)((ItemStack)this.stacks.getFirst()));
            for (int i = 1; i < 10; ++i) {
                ItemStack stack = (ItemStack)this.stacks.get(i);
                if (stack.isEmpty()) continue;
                list.add((Object)stack);
            }
        }

        public void read(ValueInput view) {
            int i;
            List list = view.listOrEmpty("Inventory", ItemStack.OPTIONAL_CODEC).stream().toList();
            this.setItem(0, (ItemStack)list.getFirst());
            int size = list.size();
            for (i = 1; i < size; ++i) {
                this.setItem(i, (ItemStack)list.get(i));
            }
            for (i = size; i < 10; ++i) {
                this.setItem(i, ItemStack.EMPTY);
            }
        }
    }
}

