/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.mixer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.AllRecipeSerializers;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.content.processing.basin.BasinInput;
import com.zurrtum.create.content.processing.basin.BasinRecipe;
import com.zurrtum.create.content.processing.recipe.SizedIngredient;
import com.zurrtum.create.foundation.fluid.FluidIngredient;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public record CompactingRecipe(ItemStack result, @Nullable FluidIngredient fluidIngredient, List<SizedIngredient> ingredients) implements BasinRecipe
{
    @Override
    public int getIngredientSize() {
        return (this.fluidIngredient == null ? 0 : 1) + this.ingredients.size();
    }

    @Override
    public List<SizedIngredient> getIngredients() {
        return this.ingredients;
    }

    @Override
    public List<FluidIngredient> getFluidIngredients() {
        return this.fluidIngredient == null ? List.of() : List.of(this.fluidIngredient);
    }

    public boolean matches(BasinInput input, Level world) {
        List<ItemStack> outputs = BasinRecipe.tryCraft(input, this.ingredients);
        if (outputs == null) {
            return false;
        }
        if (!BasinRecipe.matchFluidIngredient(input, this.fluidIngredient)) {
            return false;
        }
        outputs.add(this.result);
        return input.acceptOutputs(outputs, List.of(), true);
    }

    @Override
    public boolean apply(BasinInput input) {
        ArrayDeque<Runnable> changes = new ArrayDeque<Runnable>();
        List<ItemStack> outputs = BasinRecipe.prepareCraft(input, this.ingredients, changes);
        if (outputs == null) {
            return false;
        }
        if (!BasinRecipe.prepareFluidCraft(input, this.fluidIngredient, changes)) {
            return false;
        }
        outputs.add(this.result);
        if (!input.acceptOutputs(outputs, List.of(), true)) {
            return false;
        }
        changes.forEach(Runnable::run);
        return input.acceptOutputs(outputs, List.of(), false);
    }

    public RecipeSerializer<CompactingRecipe> getSerializer() {
        return AllRecipeSerializers.COMPACTING;
    }

    public RecipeType<CompactingRecipe> getType() {
        return AllRecipeTypes.COMPACTING;
    }

    public static class Serializer
    implements RecipeSerializer<CompactingRecipe> {
        public static final MapCodec<CompactingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.CODEC.fieldOf("result").forGetter(CompactingRecipe::result), (App)FluidIngredient.CODEC.optionalFieldOf("fluid_ingredient").forGetter(Serializer::getOptionalFluidIngredient), (App)SizedIngredient.getListCodec(1, 9).optionalFieldOf("ingredients", List.of()).forGetter(CompactingRecipe::ingredients)).apply((Applicative)instance, Serializer::createRecipe)).validate(recipe -> {
            if (recipe.fluidIngredient == null && recipe.ingredients.isEmpty()) {
                return DataResult.error(() -> "MixingRecipe must have a ingredient or a fluid ingredient");
            }
            return DataResult.success((Object)recipe);
        });
        public static final StreamCodec<RegistryFriendlyByteBuf, CompactingRecipe> PACKET_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, CompactingRecipe::result, (StreamCodec)FluidIngredient.PACKET_CODEC.apply(ByteBufCodecs::optional), Serializer::getOptionalFluidIngredient, (StreamCodec)SizedIngredient.PACKET_CODEC.apply(ByteBufCodecs.list()), CompactingRecipe::ingredients, Serializer::createRecipe);

        private static Optional<FluidIngredient> getOptionalFluidIngredient(CompactingRecipe recipe) {
            return Optional.ofNullable(recipe.fluidIngredient);
        }

        private static CompactingRecipe createRecipe(ItemStack result, Optional<FluidIngredient> fluidIngredient, List<SizedIngredient> ingredients) {
            return new CompactingRecipe(result, fluidIngredient.orElse(null), ingredients);
        }

        public MapCodec<CompactingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, CompactingRecipe> streamCodec() {
            return PACKET_CODEC;
        }
    }
}

