/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.mixer;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllParticleTypes;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.kinetics.press.MechanicalPressBlockEntity;
import com.zurrtum.create.content.processing.basin.BasinBlockEntity;
import com.zurrtum.create.content.processing.basin.BasinInventory;
import com.zurrtum.create.content.processing.basin.BasinOperatingBlockEntity;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import com.zurrtum.create.infrastructure.particle.FluidParticleData;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class MechanicalMixerBlockEntity
extends BasinOperatingBlockEntity {
    private static final Object shapelessOrMixingRecipesKey = new Object();
    public int runningTicks;
    public int processingTicks;
    public boolean running;

    public MechanicalMixerBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.MECHANICAL_MIXER, pos, state);
    }

    public float getRenderedHeadOffset(float partialTicks) {
        float offset = 0.0f;
        if (this.running) {
            if (this.runningTicks < 20) {
                int localTick = this.runningTicks;
                float num = ((float)localTick + partialTicks) / 20.0f;
                num = (2.0f - Mth.cos((double)((float)((double)num * Math.PI)))) / 2.0f;
                offset = num - 0.5f;
            } else if (this.runningTicks <= 20) {
                offset = 1.0f;
            } else {
                int localTick = 40 - this.runningTicks;
                float num = ((float)localTick - partialTicks) / 20.0f;
                num = (2.0f - Mth.cos((double)((float)((double)num * Math.PI)))) / 2.0f;
                offset = num - 0.5f;
            }
        }
        return offset + 0.4375f;
    }

    public float getRenderedHeadRotationSpeed(float partialTicks) {
        float speed = this.getSpeed();
        if (this.running) {
            if (this.runningTicks < 15) {
                return speed;
            }
            if (this.runningTicks <= 20) {
                return speed * 2.0f;
            }
            return speed;
        }
        return speed / 2.0f;
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.MIXER);
    }

    @Override
    protected AABB createRenderBoundingBox() {
        return new AABB(this.worldPosition).expandTowards(0.0, -1.5, 0.0);
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        this.running = view.getBooleanOr("Running", false);
        this.runningTicks = view.getIntOr("Ticks", 0);
        super.read(view, clientPacket);
        if (clientPacket && this.hasLevel()) {
            this.getBasin().ifPresent(bte -> bte.setAreFluidsMoving(this.running && this.runningTicks <= 20));
        }
    }

    @Override
    protected void write(ValueOutput view, boolean clientPacket) {
        view.putBoolean("Running", this.running);
        view.putInt("Ticks", this.runningTicks);
        super.write(view, clientPacket);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.runningTicks >= 40) {
            this.running = false;
            this.runningTicks = 0;
            this.basinChecker.scheduleUpdate();
            return;
        }
        float speed = Math.abs(this.getSpeed());
        if (this.running && this.level != null) {
            if (this.level.isClientSide() && this.runningTicks == 20) {
                this.renderParticles();
            }
            if ((!this.level.isClientSide() || this.isVirtual()) && this.runningTicks == 20) {
                if (this.processingTicks < 0) {
                    Couple<SmartFluidTankBehaviour> tanks;
                    float recipeSpeed = 1.0f;
                    this.processingTicks = Mth.clamp((int)(Mth.log2((int)((int)(512.0f / speed))) * Mth.ceil((float)(recipeSpeed * 15.0f)) + 1), (int)1, (int)512);
                    Optional<BasinBlockEntity> basin = this.getBasin();
                    if (!(!basin.isPresent() || ((SmartFluidTankBehaviour)(tanks = basin.get().getTanks()).getFirst()).isEmpty() && ((SmartFluidTankBehaviour)tanks.getSecond()).isEmpty())) {
                        this.level.playSound(null, this.worldPosition, SoundEvents.BUBBLE_COLUMN_WHIRLPOOL_AMBIENT, SoundSource.BLOCKS, 0.75f, speed < 65.0f ? 0.75f : 1.5f);
                    }
                } else {
                    --this.processingTicks;
                    if (this.processingTicks == 0) {
                        ++this.runningTicks;
                        this.processingTicks = -1;
                        this.applyBasinRecipe();
                        this.sendData();
                    }
                }
            }
            if (this.runningTicks != 20) {
                ++this.runningTicks;
            }
        }
    }

    public void renderParticles() {
        Optional<BasinBlockEntity> basin = this.getBasin();
        if (basin.isEmpty() || this.level == null) {
            return;
        }
        BasinInventory inv = basin.get().itemCapability;
        int size = inv.getContainerSize();
        for (int slot = 0; slot < size; ++slot) {
            ItemStack stackInSlot = inv.getItem(slot);
            if (stackInSlot.isEmpty()) continue;
            ItemParticleOption data = new ItemParticleOption(ParticleTypes.ITEM, stackInSlot);
            this.spillParticle((ParticleOptions)data);
        }
        for (SmartFluidTankBehaviour behaviour : basin.get().getTanks()) {
            if (behaviour == null) continue;
            for (SmartFluidTankBehaviour.TankSegment tankSegment : behaviour.getTanks()) {
                if (tankSegment.isEmpty(0.0f)) continue;
                FluidStack stack = tankSegment.getRenderedFluid();
                this.spillParticle(new FluidParticleData(AllParticleTypes.FLUID_PARTICLE, stack.getFluid(), stack.getComponentChanges()));
            }
        }
    }

    protected void spillParticle(ParticleOptions data) {
        float angle = this.level.random.nextFloat() * 360.0f;
        Vec3 offset = new Vec3(0.0, 0.0, 0.25);
        offset = VecHelper.rotate(offset, angle, Direction.Axis.Y);
        Vec3 target = VecHelper.rotate(offset, this.getSpeed() > 0.0f ? 25.0 : -25.0, Direction.Axis.Y).add(0.0, 0.25, 0.0);
        Vec3 center = offset.add(VecHelper.getCenterOf((Vec3i)this.worldPosition));
        target = VecHelper.offsetRandomly(target.subtract(offset), this.level.random, 0.0078125f);
        this.level.addParticle(data, center.x, center.y - 1.75, center.z, target.x, target.y, target.z);
    }

    @Override
    protected boolean matchStaticFilters(RecipeHolder<? extends Recipe<?>> recipe) {
        RecipeType type;
        Recipe r = recipe.value();
        if (r instanceof ShapelessRecipe) {
            ShapelessRecipe shapelessRecipe = (ShapelessRecipe)r;
            if (((Boolean)AllConfigs.server().recipes.allowShapelessInMixer.get()).booleanValue() && shapelessRecipe.ingredients.size() > 1 && !MechanicalPressBlockEntity.canCompress(r) && !AllRecipeTypes.shouldIgnoreInAutomation(recipe)) {
                return true;
            }
        }
        if ((type = r.getType()) == AllRecipeTypes.POTION && ((Boolean)AllConfigs.server().recipes.allowBrewingInMixer.get()).booleanValue()) {
            return true;
        }
        return type == AllRecipeTypes.MIXING;
    }

    @Override
    public void startProcessingBasin() {
        if (this.running && this.runningTicks <= 20) {
            return;
        }
        super.startProcessingBasin();
        this.running = true;
        this.runningTicks = 0;
    }

    @Override
    public boolean continueWithPreviousRecipe() {
        this.runningTicks = 20;
        return true;
    }

    @Override
    protected void onBasinRemoved() {
        if (!this.running) {
            return;
        }
        this.runningTicks = 40;
        this.running = false;
    }

    @Override
    protected Object getRecipeCacheKey() {
        return shapelessOrMixingRecipesKey;
    }

    @Override
    protected boolean isRunning() {
        return this.running;
    }

    @Override
    protected Optional<CreateTrigger> getProcessedRecipeTrigger() {
        return Optional.of(AllAdvancements.MIXER);
    }
}

