/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.mixer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.AllRecipeSerializers;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.content.fluids.potion.PotionFluidHandler;
import com.zurrtum.create.content.processing.basin.BasinInput;
import com.zurrtum.create.content.processing.basin.BasinRecipe;
import com.zurrtum.create.content.processing.recipe.HeatCondition;
import com.zurrtum.create.content.processing.recipe.SizedIngredient;
import com.zurrtum.create.foundation.fluid.FluidIngredient;
import com.zurrtum.create.infrastructure.component.BottleType;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public record PotionRecipe(FluidStack result, FluidIngredient fluidIngredient, Ingredient ingredient) implements BasinRecipe
{
    public static final List<Item> SUPPORTED_CONTAINERS = List.of(Items.POTION, Items.SPLASH_POTION, Items.LINGERING_POTION);
    public static ReloadData data;

    public static void register(Map<Identifier, Recipe<?>> map) {
        if (data == null) {
            return;
        }
        PotionBrewing potionBrewing = PotionBrewing.bootstrap((FeatureFlagSet)PotionRecipe.data.enabledFeatures);
        int recipeIndex = 0;
        ArrayList<Item> allowedSupportedContainers = new ArrayList<Item>();
        for (Item container : SUPPORTED_CONTAINERS) {
            if (!potionBrewing.isContainer(new ItemStack((ItemLike)container))) continue;
            allowedSupportedContainers.add(container);
        }
        for (Item container : allowedSupportedContainers) {
            BottleType bottleType = PotionFluidHandler.bottleTypeFromItem(container);
            for (PotionBrewing.Mix mix : potionBrewing.potionMixes) {
                FluidIngredient fromFluid = PotionFluidHandler.getFluidIngredientFromPotion(new PotionContents(mix.from()), bottleType, 81000);
                FluidStack toFluid = PotionFluidHandler.getFluidFromPotion(new PotionContents(mix.to()), bottleType, 81000);
                Identifier id = Identifier.fromNamespaceAndPath((String)"create", (String)("potion_mixing_vanilla_" + recipeIndex++));
                map.put(id, new PotionRecipe(toFluid, fromFluid, mix.ingredient()));
            }
        }
        for (PotionBrewing.Mix mix : potionBrewing.containerMixes) {
            Item to;
            Item from = (Item)mix.from().value();
            if (!allowedSupportedContainers.contains(from) || !allowedSupportedContainers.contains(to = (Item)mix.to().value())) continue;
            BottleType fromBottleType = PotionFluidHandler.bottleTypeFromItem(from);
            BottleType toBottleType = PotionFluidHandler.bottleTypeFromItem(to);
            Ingredient ingredient = mix.ingredient();
            List potions = PotionRecipe.data.registries.lookupOrThrow(Registries.POTION).listElements().toList();
            for (Holder.Reference potion : potions) {
                FluidIngredient fromFluid = PotionFluidHandler.getFluidIngredientFromPotion(new PotionContents((Holder)potion), fromBottleType, 81000);
                FluidStack toFluid = PotionFluidHandler.getFluidFromPotion(new PotionContents((Holder)potion), toBottleType, 81000);
                Identifier id = Identifier.fromNamespaceAndPath((String)"create", (String)("potion_mixing_vanilla_" + recipeIndex++));
                map.put(id, new PotionRecipe(toFluid, fromFluid, ingredient));
            }
        }
        data = null;
    }

    @Override
    public int getIngredientSize() {
        return 2;
    }

    @Override
    public List<SizedIngredient> getIngredients() {
        return List.of(new SizedIngredient(this.ingredient, 1));
    }

    @Override
    public List<FluidIngredient> getFluidIngredients() {
        return List.of(this.fluidIngredient);
    }

    public boolean matches(BasinInput input, Level world) {
        if (!HeatCondition.HEATED.testBlazeBurner(input.heat())) {
            return false;
        }
        List<ItemStack> outputs = BasinRecipe.tryCraft(input, this.ingredient);
        if (outputs == null) {
            return false;
        }
        if (!BasinRecipe.matchFluidIngredient(input, this.fluidIngredient)) {
            return false;
        }
        return input.acceptOutputs(outputs, List.of(this.result), true);
    }

    @Override
    public boolean apply(BasinInput input) {
        if (!HeatCondition.HEATED.testBlazeBurner(input.heat())) {
            return false;
        }
        ArrayDeque<Runnable> changes = new ArrayDeque<Runnable>();
        List<ItemStack> outputs = BasinRecipe.prepareCraft(input, this.ingredient, changes);
        if (outputs == null) {
            return false;
        }
        if (!BasinRecipe.prepareFluidCraft(input, this.fluidIngredient, changes)) {
            return false;
        }
        List<FluidStack> fluids = List.of(this.result);
        if (!input.acceptOutputs(outputs, fluids, true)) {
            return false;
        }
        changes.forEach(Runnable::run);
        return input.acceptOutputs(outputs, fluids, false);
    }

    public RecipeSerializer<PotionRecipe> getSerializer() {
        return AllRecipeSerializers.POTION;
    }

    public RecipeType<PotionRecipe> getType() {
        return AllRecipeTypes.POTION;
    }

    public record ReloadData(HolderLookup.Provider registries, FeatureFlagSet enabledFeatures) {
    }

    public static class Serializer
    implements RecipeSerializer<PotionRecipe> {
        public static final MapCodec<PotionRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)FluidStack.CODEC.fieldOf("result").forGetter(PotionRecipe::result), (App)FluidIngredient.CODEC.fieldOf("fluid_ingredient").forGetter(PotionRecipe::fluidIngredient), (App)Ingredient.CODEC.fieldOf("ingredient").forGetter(PotionRecipe::ingredient)).apply((Applicative)instance, PotionRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, PotionRecipe> PACKET_CODEC = StreamCodec.composite(FluidStack.PACKET_CODEC, PotionRecipe::result, FluidIngredient.PACKET_CODEC, PotionRecipe::fluidIngredient, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, PotionRecipe::ingredient, PotionRecipe::new);

        public MapCodec<PotionRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, PotionRecipe> streamCodec() {
            return PACKET_CODEC;
        }
    }
}

