/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.motor;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.zurrtum.create.content.kinetics.motor.CreativeMotorBlock;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue.ServerKineticScrollValueBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue.ServerScrollValueBehaviour;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class CreativeMotorBlockEntity
extends GeneratingKineticBlockEntity {
    public static final int DEFAULT_SPEED = 16;
    public static final int MAX_SPEED = 256;
    protected ServerScrollValueBehaviour generatedSpeed;

    public CreativeMotorBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.MOTOR, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        super.addBehaviours(behaviours);
        int max = 256;
        this.generatedSpeed = new ServerKineticScrollValueBehaviour(this);
        this.generatedSpeed.between(-max, max);
        this.generatedSpeed.setValue(16);
        this.generatedSpeed.withCallback(i -> this.updateGeneratedRotation());
        behaviours.add(this.generatedSpeed);
    }

    @Override
    public void initialize() {
        super.initialize();
        if (!this.hasSource() || this.getGeneratedSpeed() > this.getTheoreticalSpeed()) {
            this.updateGeneratedRotation();
        }
    }

    @Override
    public float getGeneratedSpeed() {
        if (!this.getBlockState().is((Block)AllBlocks.CREATIVE_MOTOR)) {
            return 0.0f;
        }
        return CreativeMotorBlockEntity.convertToDirection(this.generatedSpeed.getValue(), (Direction)this.getBlockState().getValue((Property)CreativeMotorBlock.FACING));
    }
}

