/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.press;

import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.kinetics.belt.behaviour.BeltProcessingBehaviour;
import com.zurrtum.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.zurrtum.create.content.kinetics.belt.transport.TransportedItemStack;
import com.zurrtum.create.content.kinetics.press.BeltPressingCallbacks;
import com.zurrtum.create.content.processing.basin.BasinBlock;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class PressingBehaviour
extends BeltProcessingBehaviour {
    public static final int CYCLE = 240;
    public static final int ENTITY_SCAN = 10;
    public List<ItemStack> particleItems = new ArrayList<ItemStack>();
    public PressingBehaviourSpecifics specifics;
    public int prevRunningTicks;
    public int runningTicks;
    public boolean running;
    public boolean finished;
    public Mode mode;
    int entityScanCooldown;

    public <T extends SmartBlockEntity> PressingBehaviour(T be) {
        super(be);
        this.specifics = (PressingBehaviourSpecifics)((Object)be);
        this.mode = Mode.WORLD;
        this.entityScanCooldown = 10;
        this.whenItemEnters((s, i) -> BeltPressingCallbacks.onItemReceived(s, i, this));
        this.whileItemHeld((s, i) -> BeltPressingCallbacks.whenItemHeld(s, i, this));
    }

    @Override
    public void read(ValueInput view, boolean clientPacket) {
        this.running = view.getBooleanOr("Running", false);
        this.mode = Mode.values()[view.getIntOr("Mode", 0)];
        this.finished = view.getBooleanOr("Finished", false);
        this.prevRunningTicks = this.runningTicks = view.getIntOr("Ticks", 0);
        super.read(view, clientPacket);
        if (clientPacket) {
            view.read("ParticleItems", CreateCodecs.ITEM_LIST_CODEC).ifPresent(this.particleItems::addAll);
            this.spawnParticles();
        }
    }

    @Override
    public void write(ValueOutput view, boolean clientPacket) {
        view.putBoolean("Running", this.running);
        view.putInt("Mode", this.mode.ordinal());
        view.putBoolean("Finished", this.finished);
        view.putInt("Ticks", this.runningTicks);
        super.write(view, clientPacket);
        if (clientPacket) {
            view.store("ParticleItems", CreateCodecs.ITEM_LIST_CODEC, this.particleItems);
            this.particleItems.clear();
        }
    }

    public float getRenderedHeadOffset(float partialTicks) {
        if (!this.running) {
            return 0.0f;
        }
        int runningTicks = Math.abs(this.runningTicks);
        float ticks = Mth.lerpInt((float)partialTicks, (int)this.prevRunningTicks, (int)runningTicks);
        if (runningTicks < 160) {
            return (float)Mth.clamp((double)Math.pow(ticks / 240.0f * 2.0f, 3.0), (double)0.0, (double)1.0);
        }
        return Mth.clamp((float)((240.0f - ticks) / 240.0f * 3.0f), (float)0.0f, (float)1.0f);
    }

    public void start(Mode mode) {
        this.mode = mode;
        this.running = true;
        this.prevRunningTicks = 0;
        this.runningTicks = 0;
        this.particleItems.clear();
        this.blockEntity.sendData();
    }

    public boolean inWorld() {
        return this.mode == Mode.WORLD;
    }

    public boolean onBasin() {
        return this.mode == Mode.BASIN;
    }

    @Override
    public void tick() {
        super.tick();
        Level level = this.getLevel();
        BlockPos worldPosition = this.getPos();
        if (!this.running || level == null) {
            if (level != null && !level.isClientSide()) {
                if (this.specifics.getKineticSpeed() == 0.0f) {
                    return;
                }
                if (this.entityScanCooldown > 0) {
                    --this.entityScanCooldown;
                }
                if (this.entityScanCooldown <= 0) {
                    this.entityScanCooldown = 10;
                    if (BlockEntityBehaviour.get((BlockGetter)level, worldPosition.below(2), TransportedItemStackHandlerBehaviour.TYPE) != null) {
                        return;
                    }
                    if (BasinBlock.isBasin((LevelReader)level, worldPosition.below(2))) {
                        return;
                    }
                    for (ItemEntity itemEntity : level.getEntitiesOfClass(ItemEntity.class, new AABB(worldPosition.below()).deflate(0.125))) {
                        if (!itemEntity.isAlive() || !itemEntity.onGround() || !this.specifics.tryProcessInWorld(itemEntity, true)) continue;
                        this.start(Mode.WORLD);
                        return;
                    }
                }
            }
            return;
        }
        if (level.isClientSide() && this.runningTicks == -120) {
            this.prevRunningTicks = 120;
            return;
        }
        if (this.runningTicks == 120 && this.specifics.getKineticSpeed() != 0.0f) {
            if (this.inWorld()) {
                this.applyInWorld();
            }
            if (this.onBasin()) {
                this.applyOnBasin();
            }
            if (level.getBlockState(worldPosition.below(2)).getSoundType() == SoundType.WOOL) {
                AllSoundEvents.MECHANICAL_PRESS_ACTIVATION_ON_BELT.playOnServer(level, (Vec3i)worldPosition);
            } else {
                AllSoundEvents.MECHANICAL_PRESS_ACTIVATION.playOnServer(level, (Vec3i)worldPosition, 0.5f, 0.75f + Math.abs(this.specifics.getKineticSpeed()) / 1024.0f);
            }
            if (!level.isClientSide()) {
                this.blockEntity.sendData();
            }
        }
        if (!level.isClientSide() && this.runningTicks > 240) {
            this.finished = true;
            this.running = false;
            this.particleItems.clear();
            this.specifics.onPressingCompleted();
            this.blockEntity.sendData();
            return;
        }
        this.prevRunningTicks = this.runningTicks;
        this.runningTicks += this.getRunningTickSpeed();
        if (this.prevRunningTicks < 120 && this.runningTicks >= 120) {
            this.runningTicks = 120;
            if (level.isClientSide() && !this.blockEntity.isVirtual()) {
                this.runningTicks = -120;
            }
        }
    }

    protected void applyOnBasin() {
        Level level = this.getLevel();
        if (level.isClientSide()) {
            return;
        }
        this.particleItems.clear();
        if (this.specifics.tryProcessInBasin(false)) {
            this.blockEntity.sendData();
        }
    }

    protected void applyInWorld() {
        Level level = this.getLevel();
        BlockPos worldPosition = this.getPos();
        AABB bb = new AABB(worldPosition.below(1));
        boolean bulk = this.specifics.canProcessInBulk();
        this.particleItems.clear();
        if (level.isClientSide()) {
            return;
        }
        for (Entity entity : level.getEntities(null, bb)) {
            if (!(entity instanceof ItemEntity)) continue;
            ItemEntity itemEntity = (ItemEntity)entity;
            if (!entity.isAlive() || !entity.onGround()) continue;
            this.entityScanCooldown = 0;
            if (this.specifics.tryProcessInWorld(itemEntity, false)) {
                this.blockEntity.sendData();
            }
            if (bulk) continue;
            break;
        }
    }

    public int getRunningTickSpeed() {
        float speed = this.specifics.getKineticSpeed();
        if (speed == 0.0f) {
            return 0;
        }
        return Mth.lerpInt((float)Mth.clamp((float)(Math.abs(speed) / 512.0f), (float)0.0f, (float)1.0f), (int)1, (int)60);
    }

    protected void spawnParticles() {
        if (this.particleItems.isEmpty()) {
            return;
        }
        BlockPos worldPosition = this.getPos();
        if (this.mode == Mode.BASIN) {
            this.particleItems.forEach(stack -> this.makeCompactingParticleEffect(VecHelper.getCenterOf((Vec3i)worldPosition.below(2)), (ItemStack)stack));
        }
        if (this.mode == Mode.BELT) {
            this.particleItems.forEach(stack -> this.makePressingParticleEffect(VecHelper.getCenterOf((Vec3i)worldPosition.below(2)).add(0.0, 0.5, 0.0), (ItemStack)stack));
        }
        if (this.mode == Mode.WORLD) {
            this.particleItems.forEach(stack -> this.makePressingParticleEffect(VecHelper.getCenterOf((Vec3i)worldPosition.below(1)).add(0.0, -0.25, 0.0), (ItemStack)stack));
        }
        this.particleItems.clear();
    }

    public void makePressingParticleEffect(Vec3 pos, ItemStack stack) {
        this.makePressingParticleEffect(pos, stack, this.specifics.getParticleAmount());
    }

    public void makePressingParticleEffect(Vec3 pos, ItemStack stack, int amount) {
        Level level = this.getLevel();
        if (level == null || !level.isClientSide()) {
            return;
        }
        for (int i = 0; i < amount; ++i) {
            Vec3 motion = VecHelper.offsetRandomly(Vec3.ZERO, level.random, 0.125f).multiply(1.0, 0.0, 1.0);
            motion = motion.add(0.0, amount != 1 ? 0.125 : 0.0625, 0.0);
            level.addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, stack), pos.x, pos.y - 0.25, pos.z, motion.x, motion.y, motion.z);
        }
    }

    public void makeCompactingParticleEffect(Vec3 pos, ItemStack stack) {
        Level level = this.getLevel();
        if (level == null || !level.isClientSide()) {
            return;
        }
        for (int i = 0; i < 20; ++i) {
            Vec3 motion = VecHelper.offsetRandomly(Vec3.ZERO, level.random, 0.175f).multiply(1.0, 0.0, 1.0);
            level.addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, stack), pos.x, pos.y, pos.z, motion.x, motion.y + 0.25, motion.z);
        }
    }

    public static interface PressingBehaviourSpecifics {
        public boolean tryProcessInBasin(boolean var1);

        public boolean tryProcessOnBelt(TransportedItemStack var1, List<ItemStack> var2, boolean var3);

        public boolean tryProcessInWorld(ItemEntity var1, boolean var2);

        public boolean canProcessInBulk();

        public void onPressingCompleted();

        public int getParticleAmount();

        public float getKineticSpeed();
    }

    public static enum Mode {
        WORLD(1.0f),
        BELT(1.1875f),
        BASIN(1.375f);

        public float headOffset;

        private Mode(float headOffset) {
            this.headOffset = headOffset;
        }
    }
}

