/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.saw;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllDamageSources;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.catnip.placement.IPlacementHelper;
import com.zurrtum.create.catnip.placement.PlacementHelpers;
import com.zurrtum.create.catnip.placement.PlacementOffset;
import com.zurrtum.create.content.kinetics.base.DirectionalAxisKineticBlock;
import com.zurrtum.create.content.kinetics.base.DirectionalKineticBlock;
import com.zurrtum.create.content.kinetics.drill.DrillBlock;
import com.zurrtum.create.content.kinetics.saw.SawBlockEntity;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.infrastructure.items.ItemInventoryProvider;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SawBlock
extends DirectionalAxisKineticBlock
implements IBE<SawBlockEntity>,
ItemInventoryProvider<SawBlockEntity> {
    public static final BooleanProperty FLIPPED = BooleanProperty.create((String)"flipped");
    private static final int placementHelperId = PlacementHelpers.register(new PlacementHelper());

    public SawBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public Container getInventory(LevelAccessor world, BlockPos pos, BlockState state, SawBlockEntity blockEntity, Direction context) {
        return blockEntity.inventory;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder.add(new Property[]{FLIPPED}));
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState stateForPlacement;
        Direction facing = (Direction)(stateForPlacement = super.getStateForPlacement(context)).getValue((Property)FACING);
        return (BlockState)stateForPlacement.setValue((Property)FLIPPED, (Comparable)Boolean.valueOf(facing.getAxis() == Direction.Axis.Y && context.getHorizontalDirection().getAxisDirection() == Direction.AxisDirection.POSITIVE));
    }

    @Override
    public BlockState getRotatedBlockState(BlockState originalState, Direction targetedFace) {
        BlockState newState = super.getRotatedBlockState(originalState, targetedFace);
        if (((Direction)newState.getValue((Property)FACING)).getAxis() != Direction.Axis.Y) {
            return newState;
        }
        if (targetedFace.getAxis() != Direction.Axis.Y) {
            return newState;
        }
        if (!((Boolean)originalState.getValue((Property)AXIS_ALONG_FIRST_COORDINATE)).booleanValue()) {
            newState = (BlockState)newState.cycle((Property)FLIPPED);
        }
        return newState;
    }

    @Override
    public BlockState rotate(BlockState state, Rotation rot) {
        BlockState newState = super.rotate(state, rot);
        if (((Direction)state.getValue((Property)FACING)).getAxis() != Direction.Axis.Y) {
            return newState;
        }
        if (rot.ordinal() % 2 == 1 && rot == Rotation.CLOCKWISE_90 != (Boolean)state.getValue((Property)AXIS_ALONG_FIRST_COORDINATE)) {
            newState = (BlockState)newState.cycle((Property)FLIPPED);
        }
        if (rot == Rotation.CLOCKWISE_180) {
            newState = (BlockState)newState.cycle((Property)FLIPPED);
        }
        return newState;
    }

    @Override
    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        BlockState newState = super.mirror(state, mirrorIn);
        if (((Direction)state.getValue((Property)FACING)).getAxis() != Direction.Axis.Y) {
            return newState;
        }
        boolean alongX = (Boolean)state.getValue((Property)AXIS_ALONG_FIRST_COORDINATE);
        if (alongX && mirrorIn == Mirror.FRONT_BACK) {
            newState = (BlockState)newState.cycle((Property)FLIPPED);
        }
        if (!alongX && mirrorIn == Mirror.LEFT_RIGHT) {
            newState = (BlockState)newState.cycle((Property)FLIPPED);
        }
        return newState;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return AllShapes.CASING_12PX.get((Direction)state.getValue((Property)FACING));
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        IPlacementHelper placementHelper = PlacementHelpers.get(placementHelperId);
        if (!player.isShiftKeyDown() && player.mayBuild() && placementHelper.matchesItem(stack) && placementHelper.getOffset(player, level, state, pos, hitResult).placeInWorld(level, (BlockItem)stack.getItem(), player, hand).consumesAction()) {
            return InteractionResult.SUCCESS;
        }
        if (player.isSpectator() || !stack.isEmpty()) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        if (state.getValueOrElse((Property)FACING, (Comparable)Direction.WEST) != Direction.UP) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        return this.onBlockEntityUseItemOn((BlockGetter)level, pos, be -> {
            if (!level.isClientSide()) {
                int size = be.inventory.getContainerSize();
                for (int i = 0; i < size; ++i) {
                    ItemStack heldItemStack = be.inventory.getItem(i);
                    if (heldItemStack.isEmpty()) continue;
                    player.getInventory().placeItemBackInInventory(heldItemStack);
                }
            }
            be.inventory.clearContent();
            be.notifyUpdate();
            return InteractionResult.SUCCESS;
        });
    }

    public void entityInside(BlockState state, Level worldIn, BlockPos pos, Entity entityIn, InsideBlockEffectApplier handler, boolean bl) {
        if (worldIn.isClientSide() || entityIn instanceof ItemEntity) {
            return;
        }
        if (!new AABB(pos).deflate((double)0.1f).intersects(entityIn.getBoundingBox())) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)worldIn, pos, be -> {
            if (be.getSpeed() == 0.0f) {
                return;
            }
            entityIn.hurtServer((ServerLevel)worldIn, AllDamageSources.get((Level)worldIn).saw, (float)DrillBlock.getDamage(be.getSpeed()));
        });
    }

    public void updateEntityMovementAfterFallOn(BlockGetter worldIn, Entity entityIn) {
        super.updateEntityMovementAfterFallOn(worldIn, entityIn);
        if (!(entityIn instanceof ItemEntity)) {
            return;
        }
        if (entityIn.level().isClientSide()) {
            return;
        }
        BlockPos pos = entityIn.blockPosition();
        this.withBlockEntityDo((BlockGetter)entityIn.level(), pos, be -> {
            if (be.getSpeed() == 0.0f) {
                return;
            }
            be.insertItem((ItemEntity)entityIn);
        });
    }

    public static boolean isHorizontal(BlockState state) {
        return ((Direction)state.getValue((Property)FACING)).getAxis().isHorizontal();
    }

    @Override
    public Direction.Axis getRotationAxis(BlockState state) {
        return SawBlock.isHorizontal(state) ? ((Direction)state.getValue((Property)FACING)).getAxis() : super.getRotationAxis(state);
    }

    @Override
    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return SawBlock.isHorizontal(state) ? face == ((Direction)state.getValue((Property)FACING)).getOpposite() : super.hasShaftTowards(world, pos, state, face);
    }

    @Override
    public Class<SawBlockEntity> getBlockEntityClass() {
        return SawBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends SawBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.SAW;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    private static class PlacementHelper
    implements IPlacementHelper {
        private PlacementHelper() {
        }

        @Override
        public Predicate<ItemStack> getItemPredicate() {
            return stack -> stack.is((Item)AllItems.MECHANICAL_SAW);
        }

        @Override
        public Predicate<BlockState> getStatePredicate() {
            return state -> state.is((Block)AllBlocks.MECHANICAL_SAW);
        }

        @Override
        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            List<Direction> directions = IPlacementHelper.orderedByDistanceExceptAxis(pos, ray.getLocation(), ((Direction)state.getValue(DirectionalKineticBlock.FACING)).getAxis(), (Direction dir) -> world.getBlockState(pos.relative(dir)).canBeReplaced());
            if (directions.isEmpty()) {
                return PlacementOffset.fail();
            }
            return PlacementOffset.success((Vec3i)pos.relative(directions.getFirst()), s -> (BlockState)((BlockState)((BlockState)s.setValue(DirectionalKineticBlock.FACING, (Comparable)((Direction)state.getValue(DirectionalKineticBlock.FACING)))).setValue((Property)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE, (Comparable)((Boolean)state.getValue((Property)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE)))).setValue((Property)FLIPPED, (Comparable)((Boolean)state.getValue((Property)FLIPPED))));
        }
    }
}

