/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.transmission.sequencer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.catnip.nbt.NBTHelper;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.transmission.sequencer.InstructionSpeedModifiers;
import com.zurrtum.create.content.kinetics.transmission.sequencer.OnIsPoweredResult;
import com.zurrtum.create.content.kinetics.transmission.sequencer.SequencerInstructions;
import java.util.List;
import java.util.Vector;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class Instruction {
    public static final Codec<Instruction> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SequencerInstructions.CODEC.fieldOf("Type").forGetter(instruction -> instruction.instruction), (App)InstructionSpeedModifiers.CODEC.fieldOf("Modifier").forGetter(instruction -> instruction.speedModifier), (App)Codec.INT.fieldOf("Value").forGetter(instruction -> instruction.value)).apply((Applicative)instance, Instruction::new));
    public static final StreamCodec<FriendlyByteBuf, Instruction> STREAM_CODEC = StreamCodec.composite(SequencerInstructions.STREAM_CODEC, instruction -> instruction.instruction, InstructionSpeedModifiers.STREAM_CODEC, instruction -> instruction.speedModifier, (StreamCodec)ByteBufCodecs.VAR_INT, instruction -> instruction.value, Instruction::new);
    public SequencerInstructions instruction;
    public InstructionSpeedModifiers speedModifier;
    public int value;

    public Instruction(SequencerInstructions instruction) {
        this(instruction, 1);
    }

    public Instruction(SequencerInstructions instruction, int value) {
        this(instruction, InstructionSpeedModifiers.FORWARD, value);
    }

    public Instruction(SequencerInstructions instruction, InstructionSpeedModifiers speedModifier, int value) {
        this.instruction = instruction;
        this.speedModifier = speedModifier;
        this.value = value;
    }

    int getDuration(float currentProgress, float speed) {
        speed *= (float)this.speedModifier.value;
        speed = Math.abs(speed);
        double target = (float)this.value - currentProgress;
        switch (this.instruction) {
            case TURN_ANGLE: {
                double degreesPerTick = KineticBlockEntity.convertToAngular(speed);
                return (int)Math.ceil(target / degreesPerTick) + 2;
            }
            case TURN_DISTANCE: {
                double metersPerTick = KineticBlockEntity.convertToLinear(speed);
                return (int)Math.ceil(target / metersPerTick) + 2;
            }
            case DELAY: {
                return (int)target;
            }
            case AWAIT: {
                return -1;
            }
        }
        return 0;
    }

    float getTickProgress(float speed) {
        switch (this.instruction) {
            case TURN_ANGLE: {
                return KineticBlockEntity.convertToAngular(speed);
            }
            case TURN_DISTANCE: {
                return KineticBlockEntity.convertToLinear(speed);
            }
            case DELAY: {
                return 1.0f;
            }
        }
        return 0.0f;
    }

    int getSpeedModifier() {
        switch (this.instruction) {
            case TURN_ANGLE: 
            case TURN_DISTANCE: {
                return this.speedModifier.value;
            }
        }
        return 0;
    }

    OnIsPoweredResult onRedstonePulse() {
        return this.instruction == SequencerInstructions.AWAIT ? OnIsPoweredResult.CONTINUE : OnIsPoweredResult.NOTHING;
    }

    public static ListTag serializeAll(List<Instruction> instructions) {
        ListTag list = new ListTag();
        instructions.forEach(i -> list.add((Object)i.serialize()));
        return list;
    }

    public static Vector<Instruction> deserializeAll(ListTag list) {
        if (list.isEmpty()) {
            return Instruction.createDefault();
        }
        Vector<Instruction> instructions = new Vector<Instruction>(5);
        list.forEach(inbt -> instructions.add(Instruction.deserialize((CompoundTag)inbt)));
        return instructions;
    }

    public static Vector<Instruction> createDefault() {
        Vector<Instruction> instructions = new Vector<Instruction>(5);
        instructions.add(new Instruction(SequencerInstructions.TURN_ANGLE, 90));
        instructions.add(new Instruction(SequencerInstructions.END));
        return instructions;
    }

    CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        NBTHelper.writeEnum(tag, "Type", this.instruction);
        NBTHelper.writeEnum(tag, "Modifier", this.speedModifier);
        tag.putInt("Value", this.value);
        return tag;
    }

    static Instruction deserialize(CompoundTag tag) {
        Instruction instruction = new Instruction(NBTHelper.readEnum(tag, "Type", SequencerInstructions.class));
        instruction.speedModifier = NBTHelper.readEnum(tag, "Modifier", InstructionSpeedModifiers.class);
        instruction.value = tag.getIntOr("Value", 0);
        return instruction;
    }
}

