/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.waterwheel;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.fluid.FluidHelper;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BubbleColumnBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class WaterWheelBlockEntity
extends GeneratingKineticBlockEntity {
    public static final Map<Direction.Axis, Set<BlockPos>> SMALL_OFFSETS = new EnumMap<Direction.Axis, Set<BlockPos>>(Direction.Axis.class);
    public static final Map<Direction.Axis, Set<BlockPos>> LARGE_OFFSETS = new EnumMap<Direction.Axis, Set<BlockPos>>(Direction.Axis.class);
    public int flowScore;
    public BlockState material = Blocks.SPRUCE_PLANKS.defaultBlockState();

    public WaterWheelBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setLazyTickRate(60);
    }

    public WaterWheelBlockEntity(BlockPos pos, BlockState state) {
        this(AllBlockEntityTypes.WATER_WHEEL, pos, state);
    }

    protected int getSize() {
        return 1;
    }

    protected Set<BlockPos> getOffsetsToCheck() {
        return (this.getSize() == 1 ? SMALL_OFFSETS : LARGE_OFFSETS).get(this.getAxis());
    }

    public InteractionResult applyMaterialIfValid(ItemStack stack) {
        Item item = stack.getItem();
        if (!(item instanceof BlockItem)) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        BlockItem blockItem = (BlockItem)item;
        BlockState material = blockItem.getBlock().defaultBlockState();
        if (material == this.material) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        if (!material.is(BlockTags.PLANKS)) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        if (this.level.isClientSide() && !this.isVirtual()) {
            return InteractionResult.SUCCESS;
        }
        this.material = material;
        this.notifyUpdate();
        this.level.levelEvent(2001, this.worldPosition, Block.getId((BlockState)material));
        return InteractionResult.SUCCESS;
    }

    protected Direction.Axis getAxis() {
        Direction.Axis axis = Direction.Axis.X;
        BlockState blockState = this.getBlockState();
        Block block = blockState.getBlock();
        if (block instanceof IRotate) {
            IRotate irotate = (IRotate)block;
            axis = irotate.getRotationAxis(blockState);
        }
        return axis;
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        this.determineAndApplyFlowScore();
    }

    public void determineAndApplyFlowScore() {
        Vec3 wheelPlane = Vec3.atLowerCornerOf((Vec3i)new Vec3i(1, 1, 1).subtract(Direction.get((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)this.getAxis()).getUnitVec3i()));
        int flowScore = 0;
        boolean lava = false;
        for (BlockPos blockPos : this.getOffsetsToCheck()) {
            Vec3 normal;
            Vec3 positiveMotion;
            double dot;
            BlockPos targetPos = blockPos.offset((Vec3i)this.worldPosition);
            Vec3 flowAtPos = this.getFlowVectorAtPosition(targetPos).multiply(wheelPlane);
            lava |= FluidHelper.isLava(this.level.getFluidState(targetPos).getType());
            if (flowAtPos.lengthSqr() == 0.0 || !(Math.abs(dot = (flowAtPos = flowAtPos.normalize()).dot(positiveMotion = VecHelper.rotate(normal = Vec3.atLowerCornerOf((Vec3i)blockPos).normalize(), 90.0, this.getAxis()))) > 0.5)) continue;
            flowScore = (int)((double)flowScore + Math.signum(dot));
        }
        if (flowScore != 0 && !this.level.isClientSide()) {
            this.award(lava ? AllAdvancements.LAVA_WHEEL : AllAdvancements.WATER_WHEEL);
        }
        this.setFlowScoreAndUpdate(flowScore);
    }

    public Vec3 getFlowVectorAtPosition(BlockPos pos) {
        FluidState fluid = this.level.getFluidState(pos);
        Vec3 vec = fluid.getFlow((BlockGetter)this.level, pos);
        BlockState blockState = this.level.getBlockState(pos);
        if (blockState.getBlock() == Blocks.BUBBLE_COLUMN) {
            vec = new Vec3(0.0, (Boolean)blockState.getValue((Property)BubbleColumnBlock.DRAG_DOWN) != false ? -1.0 : 1.0, 0.0);
        }
        return vec;
    }

    public void setFlowScoreAndUpdate(int score) {
        if (this.flowScore == score) {
            return;
        }
        this.flowScore = score;
        this.updateGeneratedRotation();
        this.setChanged();
    }

    private void redraw() {
        if (!this.isVirtual()) {
            AllClientHandle.INSTANCE.queueUpdate(this);
        }
        if (this.hasLevel()) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 16);
            this.level.getChunkSource().getLightEngine().checkBlock(this.worldPosition);
        }
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        super.addBehaviours(behaviours);
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.LAVA_WHEEL, AllAdvancements.WATER_WHEEL);
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        super.read(view, clientPacket);
        this.flowScore = view.getIntOr("FlowScore", 0);
        BlockState prevMaterial = this.material;
        Optional material = view.read("Material", BlockState.CODEC);
        if (material.isEmpty()) {
            return;
        }
        this.material = (BlockState)material.get();
        if (this.material.isAir()) {
            this.material = Blocks.SPRUCE_PLANKS.defaultBlockState();
        }
        if (clientPacket && prevMaterial != this.material) {
            this.redraw();
        }
    }

    @Override
    public void writeSafe(ValueOutput view) {
        super.writeSafe(view);
        view.store("Material", BlockState.CODEC, (Object)this.material);
    }

    @Override
    public void write(ValueOutput view, boolean clientPacket) {
        super.write(view, clientPacket);
        view.putInt("FlowScore", this.flowScore);
        view.store("Material", BlockState.CODEC, (Object)this.material);
    }

    @Override
    protected AABB createRenderBoundingBox() {
        return new AABB(this.worldPosition).inflate((double)this.getSize());
    }

    @Override
    public float getGeneratedSpeed() {
        return Mth.clamp((int)this.flowScore, (int)-1, (int)1) * 8 / this.getSize();
    }

    static {
        for (Direction.Axis axis : Iterate.axes) {
            HashSet<BlockPos> offsets = new HashSet<BlockPos>();
            for (Direction d : Iterate.directions) {
                if (d.getAxis() == axis) continue;
                offsets.add(BlockPos.ZERO.relative(d));
            }
            SMALL_OFFSETS.put(axis, offsets);
            offsets = new HashSet();
            for (Direction d : Iterate.directions) {
                if (d.getAxis() == axis) continue;
                BlockPos centralOffset = BlockPos.ZERO.relative(d, 2);
                offsets.add(centralOffset);
                for (Direction d2 : Iterate.directions) {
                    if (d2.getAxis() == axis || d2.getAxis() == d.getAxis()) continue;
                    offsets.add(centralOffset.relative(d2));
                }
            }
            LARGE_OFFSETS.put(axis, offsets);
        }
    }
}

