/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.depot;

import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.kinetics.belt.BeltHelper;
import com.zurrtum.create.content.kinetics.belt.behaviour.BeltProcessingBehaviour;
import com.zurrtum.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.zurrtum.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.zurrtum.create.content.kinetics.belt.transport.TransportedItemStack;
import com.zurrtum.create.content.logistics.depot.DepotItemHandler;
import com.zurrtum.create.content.logistics.funnel.AbstractFunnelBlock;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import com.zurrtum.create.foundation.item.ItemHelper;
import com.zurrtum.create.infrastructure.items.ItemInventory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;

public class DepotBehaviour
extends BlockEntityBehaviour<SmartBlockEntity> {
    public static final BehaviourType<DepotBehaviour> TYPE = new BehaviourType();
    public TransportedItemStack heldItem;
    public List<TransportedItemStack> incoming;
    public DepotOutputHandler processingOutputBuffer;
    public DepotItemHandler itemHandler;
    TransportedItemStackHandlerBehaviour transportedHandler;
    Supplier<Integer> maxStackSize = () -> this.heldItem != null ? this.heldItem.stack.getMaxStackSize() : 64;
    Supplier<Boolean> canAcceptItems = () -> true;
    Predicate<Direction> canFunnelsPullFrom = $ -> true;
    Consumer<ItemStack> onHeldInserted;
    Predicate<ItemStack> acceptedItems = $ -> true;
    boolean allowMerge;

    public DepotBehaviour(SmartBlockEntity be) {
        super(be);
        this.onHeldInserted = $ -> {};
        this.incoming = new ArrayList<TransportedItemStack>();
        this.itemHandler = new DepotItemHandler(this);
        this.processingOutputBuffer = new DepotOutputHandler();
    }

    public void enableMerging() {
        this.allowMerge = true;
    }

    public DepotBehaviour withCallback(Consumer<ItemStack> changeListener) {
        this.onHeldInserted = changeListener;
        return this;
    }

    public DepotBehaviour onlyAccepts(Predicate<ItemStack> filter) {
        this.acceptedItems = filter;
        return this;
    }

    @Override
    public void tick() {
        BeltProcessingBehaviour.ProcessingResult result;
        super.tick();
        Level world = this.blockEntity.getLevel();
        Iterator<TransportedItemStack> iterator = this.incoming.iterator();
        while (iterator.hasNext()) {
            TransportedItemStack ts = iterator.next();
            if (!this.tick(ts) || world.isClientSide() && !this.blockEntity.isVirtual()) continue;
            if (this.heldItem == null) {
                this.heldItem = ts;
            } else if (!ItemHelper.canItemStackAmountsStack(this.heldItem.stack, ts.stack)) {
                Vec3 vec = VecHelper.getCenterOf((Vec3i)this.blockEntity.getBlockPos());
                Containers.dropItemStack((Level)this.blockEntity.getLevel(), (double)vec.x, (double)(vec.y + 0.5), (double)vec.z, (ItemStack)ts.stack);
            } else {
                this.heldItem.stack.grow(ts.stack.getCount());
            }
            iterator.remove();
            this.blockEntity.notifyUpdate();
        }
        if (this.heldItem == null) {
            return;
        }
        if (!this.tick(this.heldItem)) {
            return;
        }
        BlockPos pos = this.blockEntity.getBlockPos();
        if (world.isClientSide()) {
            return;
        }
        if (this.handleBeltFunnelOutput()) {
            return;
        }
        BeltProcessingBehaviour processingBehaviour = BlockEntityBehaviour.get((BlockGetter)world, pos.above(2), BeltProcessingBehaviour.TYPE);
        if (processingBehaviour == null) {
            return;
        }
        if (!this.heldItem.locked && BeltProcessingBehaviour.isBlocked((BlockGetter)world, pos)) {
            return;
        }
        ItemStack previousItem = this.heldItem.stack;
        boolean wasLocked = this.heldItem.locked;
        BeltProcessingBehaviour.ProcessingResult processingResult = result = wasLocked ? processingBehaviour.handleHeldItem(this.heldItem, this.transportedHandler) : processingBehaviour.handleReceivedItem(this.heldItem, this.transportedHandler);
        if (result == BeltProcessingBehaviour.ProcessingResult.REMOVE) {
            this.heldItem = null;
            this.blockEntity.sendData();
            return;
        }
        boolean bl = this.heldItem.locked = result == BeltProcessingBehaviour.ProcessingResult.HOLD;
        if (this.heldItem.locked != wasLocked || !ItemStack.matches((ItemStack)previousItem, (ItemStack)this.heldItem.stack)) {
            this.blockEntity.sendData();
        }
    }

    protected boolean tick(TransportedItemStack heldItem) {
        heldItem.prevSideOffset = heldItem.sideOffset;
        if (heldItem.beltPosition == 0.5f) {
            return true;
        }
        heldItem.prevBeltPosition = heldItem.beltPosition;
        float diff = 0.5f - heldItem.beltPosition;
        if (diff > 0.001953125f) {
            if (diff > 0.03125f && !BeltHelper.isItemUpright(heldItem.stack)) {
                ++heldItem.angle;
            }
            heldItem.beltPosition += diff / 4.0f;
        } else {
            heldItem.beltPosition = 0.5f;
            heldItem.prevBeltPosition = 0.5f;
        }
        return diff < 0.0625f;
    }

    private boolean handleBeltFunnelOutput() {
        BlockState funnel = this.getLevel().getBlockState(this.getPos().above());
        Direction funnelFacing = AbstractFunnelBlock.getFunnelFacing(funnel);
        if (funnelFacing == null || !this.canFunnelsPullFrom.test(funnelFacing.getOpposite())) {
            return false;
        }
        for (int slot = 0; slot < this.processingOutputBuffer.getContainerSize(); ++slot) {
            ItemStack previousItem = this.processingOutputBuffer.getItem(slot);
            if (previousItem.isEmpty()) continue;
            ItemStack afterInsert = this.blockEntity.getBehaviour(DirectBeltInputBehaviour.TYPE).tryExportingToBeltFunnel(previousItem, null, false);
            if (afterInsert == null) {
                return false;
            }
            if (previousItem.getCount() == afterInsert.getCount()) continue;
            this.processingOutputBuffer.setItem(slot, afterInsert);
            this.blockEntity.notifyUpdate();
            return true;
        }
        ItemStack previousItem = this.heldItem.stack;
        ItemStack afterInsert = this.blockEntity.getBehaviour(DirectBeltInputBehaviour.TYPE).tryExportingToBeltFunnel(previousItem, null, false);
        if (afterInsert == null) {
            return false;
        }
        if (previousItem.getCount() != afterInsert.getCount()) {
            if (afterInsert.isEmpty()) {
                this.heldItem = null;
            } else {
                this.heldItem.stack = afterInsert;
            }
            this.blockEntity.notifyUpdate();
            return true;
        }
        return false;
    }

    @Override
    public void destroy() {
        super.destroy();
        Level level = this.getLevel();
        BlockPos pos = this.getPos();
        Containers.dropContents((Level)level, (BlockPos)pos, (Container)this.processingOutputBuffer);
        for (TransportedItemStack transportedItemStack : this.incoming) {
            Block.popResource((Level)level, (BlockPos)pos, (ItemStack)transportedItemStack.stack);
        }
        if (!this.getHeldItemStack().isEmpty()) {
            Block.popResource((Level)level, (BlockPos)pos, (ItemStack)this.getHeldItemStack());
        }
    }

    @Override
    public void write(ValueOutput view, boolean clientPacket) {
        if (this.heldItem != null) {
            view.store("HeldItem", TransportedItemStack.CODEC, (Object)this.heldItem);
        }
        this.processingOutputBuffer.write(view);
        if (this.canMergeItems() && !this.incoming.isEmpty()) {
            view.store("Incoming", CreateCodecs.TRANSPORTED_ITEM_LIST_CODEC, this.incoming);
        }
    }

    @Override
    public void read(ValueInput view, boolean clientPacket) {
        this.heldItem = view.read("HeldItem", TransportedItemStack.CODEC).orElse(null);
        this.processingOutputBuffer.read(view);
        if (this.canMergeItems()) {
            this.incoming.clear();
            view.read("Incoming", CreateCodecs.TRANSPORTED_ITEM_LIST_CODEC).ifPresent(this.incoming::addAll);
        }
    }

    public void addSubBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        behaviours.add(new DirectBeltInputBehaviour(this.blockEntity).allowingBeltFunnels().setInsertionHandler(this::tryInsertingFromSide).considerOccupiedWhen(this::isOccupied));
        this.transportedHandler = new TransportedItemStackHandlerBehaviour(this.blockEntity, this::applyToAllItems).withStackPlacement(this::getWorldPositionOf);
        behaviours.add(this.transportedHandler);
    }

    public ItemStack getHeldItemStack() {
        return this.heldItem == null ? ItemStack.EMPTY : this.heldItem.stack;
    }

    public boolean canMergeItems() {
        return this.allowMerge;
    }

    public int getPresentStackSize() {
        int cumulativeStackSize = 0;
        cumulativeStackSize += this.getHeldItemStack().getCount();
        for (int slot = 0; slot < this.processingOutputBuffer.getContainerSize(); ++slot) {
            cumulativeStackSize += this.processingOutputBuffer.getItem(slot).getCount();
        }
        return cumulativeStackSize;
    }

    public int getRemainingSpace() {
        int cumulativeStackSize = this.getPresentStackSize();
        for (TransportedItemStack transportedItemStack : this.incoming) {
            cumulativeStackSize += transportedItemStack.stack.getCount();
        }
        int fromGetter = Math.min(this.maxStackSize.get() == 0 ? 64 : this.maxStackSize.get(), this.getHeldItemStack().getMaxStackSize());
        return fromGetter - cumulativeStackSize;
    }

    public ItemStack insert(TransportedItemStack heldItem, boolean simulate) {
        boolean stackTooLarge;
        if (!this.canAcceptItems.get().booleanValue()) {
            return heldItem.stack;
        }
        if (!this.acceptedItems.test(heldItem.stack)) {
            return heldItem.stack;
        }
        if (this.canMergeItems()) {
            int remainingSpace = this.getRemainingSpace();
            ItemStack inserted = heldItem.stack;
            if (remainingSpace <= 0) {
                return inserted;
            }
            if (this.heldItem != null && !ItemHelper.canItemStackAmountsStack(this.heldItem.stack, inserted)) {
                return inserted;
            }
            ItemStack returned = ItemStack.EMPTY;
            if (remainingSpace < inserted.getCount()) {
                returned = heldItem.stack.copyWithCount(inserted.getCount() - remainingSpace);
                if (!simulate) {
                    TransportedItemStack copy = heldItem.copy();
                    copy.stack.setCount(remainingSpace);
                    if (this.heldItem != null) {
                        this.incoming.add(copy);
                    } else {
                        this.heldItem = copy;
                    }
                }
            } else if (!simulate) {
                if (this.heldItem != null) {
                    this.incoming.add(heldItem);
                } else {
                    this.heldItem = heldItem;
                }
            }
            return returned;
        }
        ItemStack returned = ItemStack.EMPTY;
        int maxCount = heldItem.stack.getMaxStackSize();
        boolean bl = stackTooLarge = maxCount < heldItem.stack.getCount();
        if (stackTooLarge) {
            returned = heldItem.stack.copyWithCount(heldItem.stack.getCount() - maxCount);
        }
        if (simulate) {
            return returned;
        }
        if (this.isEmpty()) {
            if (heldItem.insertedFrom.getAxis().isHorizontal()) {
                AllSoundEvents.DEPOT_SLIDE.playOnServer(this.getLevel(), (Vec3i)this.getPos());
            } else {
                AllSoundEvents.DEPOT_PLOP.playOnServer(this.getLevel(), (Vec3i)this.getPos());
            }
        }
        if (stackTooLarge) {
            heldItem = heldItem.copy();
            heldItem.stack.setCount(maxCount);
        }
        this.heldItem = heldItem;
        this.onHeldInserted.accept(heldItem.stack);
        return returned;
    }

    public void setHeldItem(TransportedItemStack heldItem) {
        this.heldItem = heldItem;
    }

    public void removeHeldItem() {
        this.heldItem = null;
    }

    public void setCenteredHeldItem(TransportedItemStack heldItem) {
        this.heldItem = heldItem;
        this.heldItem.beltPosition = 0.5f;
        this.heldItem.prevBeltPosition = 0.5f;
    }

    private boolean isOccupied(Direction side) {
        if (!this.getHeldItemStack().isEmpty() && !this.canMergeItems()) {
            return true;
        }
        if (!this.isOutputEmpty() && !this.canMergeItems()) {
            return true;
        }
        return this.canAcceptItems.get() == false;
    }

    private ItemStack tryInsertingFromSide(TransportedItemStack transportedStack, Direction side, boolean simulate) {
        ItemStack inserted = transportedStack.stack;
        if (this.isOccupied(side)) {
            return inserted;
        }
        int size = transportedStack.stack.getCount();
        transportedStack = transportedStack.copy();
        transportedStack.beltPosition = side.getAxis().isVertical() ? 0.5f : 0.0f;
        transportedStack.insertedFrom = side;
        transportedStack.prevSideOffset = transportedStack.sideOffset;
        transportedStack.prevBeltPosition = transportedStack.beltPosition;
        ItemStack remainder = this.insert(transportedStack, simulate);
        if (remainder.getCount() != size) {
            this.blockEntity.notifyUpdate();
        }
        return remainder;
    }

    private void applyToAllItems(float maxDistanceFromCentre, Function<TransportedItemStack, TransportedItemStackHandlerBehaviour.TransportedResult> processFunction) {
        List<TransportedItemStack> outputs;
        if (this.heldItem == null) {
            return;
        }
        if (0.5f - this.heldItem.beltPosition > maxDistanceFromCentre) {
            return;
        }
        TransportedItemStack transportedItemStack = this.heldItem;
        ItemStack stackBefore = transportedItemStack.stack.copy();
        TransportedItemStackHandlerBehaviour.TransportedResult result = processFunction.apply(transportedItemStack);
        if (result == null || result.didntChangeFrom(stackBefore)) {
            return;
        }
        this.heldItem = null;
        if (result.hasHeldOutput()) {
            this.setCenteredHeldItem(result.getHeldOutput());
        }
        if (!(outputs = result.getOutputs()).isEmpty()) {
            int skip = 0;
            if (this.getHeldItemStack().isEmpty()) {
                this.setCenteredHeldItem(outputs.getFirst());
                skip = 1;
            }
            List items = outputs.stream().skip(skip).map(t -> t.stack).toList();
            if (!(items = this.processingOutputBuffer.insert(items)).isEmpty()) {
                Level world = this.blockEntity.getLevel();
                Vec3 vec = VecHelper.getCenterOf((Vec3i)this.blockEntity.getBlockPos()).add(0.0, 0.5, 0.0);
                double x = vec.x;
                double y = vec.y + 0.5;
                double z = vec.z;
                for (ItemStack stack : items) {
                    Containers.dropItemStack((Level)world, (double)x, (double)y, (double)z, (ItemStack)stack);
                }
            }
        }
        this.blockEntity.notifyUpdate();
    }

    public boolean isEmpty() {
        return this.heldItem == null && this.isOutputEmpty();
    }

    public boolean isOutputEmpty() {
        return this.processingOutputBuffer.isEmpty();
    }

    private Vec3 getWorldPositionOf(TransportedItemStack transported) {
        return VecHelper.getCenterOf((Vec3i)this.blockEntity.getBlockPos());
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    public boolean isItemValid(ItemStack stack) {
        return this.acceptedItems.test(stack);
    }

    public class DepotOutputHandler
    implements ItemInventory {
        private final NonNullList<ItemStack> stacks = NonNullList.withSize((int)8, (Object)ItemStack.EMPTY);

        public int getContainerSize() {
            return 8;
        }

        public ItemStack getItem(int slot) {
            if (slot >= this.getContainerSize()) {
                return ItemStack.EMPTY;
            }
            return (ItemStack)this.stacks.get(slot);
        }

        public void setItem(int slot, ItemStack stack) {
            this.stacks.set(slot, (Object)stack);
        }

        @Override
        public void setChanged() {
            DepotBehaviour.this.blockEntity.notifyUpdate();
        }

        public void write(ValueOutput view) {
            ValueOutput.TypedOutputList list = view.list("Inventory", ItemStack.CODEC);
            for (ItemStack stack : this.stacks) {
                if (stack.isEmpty()) continue;
                list.add((Object)stack);
            }
        }

        public void read(ValueInput view) {
            ValueInput.TypedInputList list = view.listOrEmpty("Inventory", ItemStack.CODEC);
            int i = 0;
            for (ItemStack itemStack : list) {
                this.stacks.set(i++, (Object)itemStack);
            }
            int size = this.stacks.size();
            while (i < size) {
                this.stacks.set(i, (Object)ItemStack.EMPTY);
                ++i;
            }
        }
    }
}

