/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.depot;

import com.zurrtum.create.content.kinetics.belt.transport.TransportedItemStack;
import com.zurrtum.create.content.logistics.depot.DepotBehaviour;
import com.zurrtum.create.infrastructure.items.ItemInventory;
import net.minecraft.world.item.ItemStack;

public class DepotItemHandler
implements ItemInventory {
    private final DepotBehaviour behaviour;

    public DepotItemHandler(DepotBehaviour behaviour) {
        this.behaviour = behaviour;
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        if (slot != 0) {
            return false;
        }
        if (!this.behaviour.isItemValid(stack) || !this.behaviour.canAcceptItems.get().booleanValue()) {
            return false;
        }
        if (this.behaviour.canMergeItems()) {
            Integer max = this.behaviour.maxStackSize.get();
            if (max == 0) {
                return true;
            }
            return this.behaviour.getHeldItemStack().getCount() < max;
        }
        return this.behaviour.getHeldItemStack().isEmpty() && this.behaviour.isOutputEmpty();
    }

    public int getContainerSize() {
        return 9;
    }

    public ItemStack getItem(int slot) {
        return slot == 0 ? this.behaviour.getHeldItemStack() : this.behaviour.processingOutputBuffer.getItem(slot - 1);
    }

    public void setItem(int slot, ItemStack stack) {
        if (slot == 0) {
            if (stack.isEmpty()) {
                this.behaviour.removeHeldItem();
            } else {
                this.behaviour.setHeldItem(new TransportedItemStack(stack));
            }
        } else {
            this.behaviour.processingOutputBuffer.setItem(slot - 1, stack);
        }
    }

    @Override
    public void setChanged() {
        this.behaviour.blockEntity.notifyUpdate();
    }
}

