/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.depot;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.kinetics.base.HorizontalKineticBlock;
import com.zurrtum.create.content.logistics.depot.EjectorBlockEntity;
import com.zurrtum.create.content.logistics.depot.SharedDepotBlockMethods;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.block.ProperWaterloggedBlock;
import com.zurrtum.create.foundation.block.SlipperinessControlBlock;
import com.zurrtum.create.foundation.item.ItemHelper;
import com.zurrtum.create.infrastructure.items.ItemInventoryProvider;
import com.zurrtum.create.infrastructure.packet.c2s.EjectorTriggerPacket;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class EjectorBlock
extends HorizontalKineticBlock
implements IBE<EjectorBlockEntity>,
ProperWaterloggedBlock,
SlipperinessControlBlock,
ItemInventoryProvider<EjectorBlockEntity> {
    public EjectorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)pBuilder.add(new Property[]{WATERLOGGED}));
    }

    @Override
    public Container getInventory(LevelAccessor world, BlockPos pos, BlockState state, EjectorBlockEntity blockEntity, Direction context) {
        return blockEntity.depotBehaviour.itemHandler;
    }

    public FluidState getFluidState(BlockState pState) {
        return this.fluidState(pState);
    }

    public BlockState updateShape(BlockState pState, LevelReader pLevel, ScheduledTickAccess tickView, BlockPos pCurrentPos, Direction pDirection, BlockPos pNeighborPos, BlockState pNeighborState, RandomSource random) {
        this.updateWater(pLevel, tickView, pState, pCurrentPos);
        return pState;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return this.withWater(super.getStateForPlacement(pContext), pContext);
    }

    public VoxelShape getShape(BlockState p_220053_1_, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        return AllShapes.CASING_13PX.get(Direction.UP);
    }

    @Override
    public float getSlipperiness(LevelReader world, BlockPos pos) {
        return this.getBlockEntityOptional((BlockGetter)world, pos).filter(ete -> ete.state == EjectorBlockEntity.State.LAUNCHING).isPresent() ? 1.0f : super.getFriction();
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block p_220069_4_, @Nullable Orientation wireOrientation, boolean p_220069_6_) {
        this.withBlockEntityDo((BlockGetter)world, pos, EjectorBlockEntity::updateSignal);
    }

    public void fallOn(Level p_180658_1_, BlockState p_152427_, BlockPos p_180658_2_, Entity p_180658_3_, double p_180658_4_) {
        Optional blockEntityOptional = this.getBlockEntityOptional((BlockGetter)p_180658_1_, p_180658_2_);
        if (blockEntityOptional.isPresent() && !p_180658_3_.isSuppressingBounce()) {
            p_180658_3_.causeFallDamage(p_180658_4_, 1.0f, p_180658_1_.damageSources().fall());
            return;
        }
        super.fallOn(p_180658_1_, p_152427_, p_180658_2_, p_180658_3_, p_180658_4_);
    }

    public void updateEntityMovementAfterFallOn(BlockGetter worldIn, Entity entityIn) {
        super.updateEntityMovementAfterFallOn(worldIn, entityIn);
        BlockPos position = entityIn.blockPosition();
        if (!worldIn.getBlockState(position).is((Block)AllBlocks.WEIGHTED_EJECTOR)) {
            return;
        }
        if (!entityIn.isAlive()) {
            return;
        }
        if (entityIn.isSuppressingBounce()) {
            return;
        }
        if (!ItemHelper.fromItemEntity(entityIn).isEmpty()) {
            SharedDepotBlockMethods.onLanded(worldIn, entityIn);
            return;
        }
        Optional teProvider = this.getBlockEntityOptional(worldIn, position);
        if (!teProvider.isPresent()) {
            return;
        }
        EjectorBlockEntity ejectorBlockEntity = (EjectorBlockEntity)teProvider.get();
        if (ejectorBlockEntity.getState() == EjectorBlockEntity.State.RETRACTING) {
            return;
        }
        if (ejectorBlockEntity.powered) {
            return;
        }
        if (ejectorBlockEntity.launcher.getHorizontalDistance() == 0) {
            return;
        }
        if (entityIn.onGround()) {
            entityIn.setOnGround(false);
            Vec3 center = VecHelper.getCenterOf((Vec3i)position).add(0.0, 0.4375, 0.0);
            Vec3 positionVec = entityIn.position();
            double diff = center.distanceTo(positionVec);
            entityIn.setDeltaMovement(0.0, -0.125, 0.0);
            Vec3 vec = center.add(positionVec).scale(0.5);
            if (diff > 0.25) {
                entityIn.setPos(vec.x, vec.y, vec.z);
                return;
            }
        }
        ejectorBlockEntity.activate();
        ejectorBlockEntity.notifyUpdate();
        if (entityIn.level().isClientSide()) {
            AllClientHandle.INSTANCE.sendPacket(new EjectorTriggerPacket(ejectorBlockEntity.getBlockPos()));
        }
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.is((Item)AllItems.WRENCH)) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        return SharedDepotBlockMethods.onUse(stack, state, level, pos, player, hand, hitResult);
    }

    @Override
    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.getValue((Property)HORIZONTAL_FACING)).getClockWise().getAxis();
    }

    @Override
    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return this.getRotationAxis(state) == face.getAxis();
    }

    @Override
    public Class<EjectorBlockEntity> getBlockEntityClass() {
        return EjectorBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends EjectorBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.WEIGHTED_EJECTOR;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level worldIn, BlockPos pos, Direction direction) {
        return SharedDepotBlockMethods.getComparatorInputOverride(blockState, worldIn, pos);
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }
}

