/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.depot;

import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.api.behaviour.interaction.MovingInteractionBehaviour;
import com.zurrtum.create.api.contraption.storage.item.MountedItemStorage;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.MountedStorageManager;
import com.zurrtum.create.content.kinetics.belt.transport.TransportedItemStack;
import com.zurrtum.create.content.logistics.depot.storage.DepotMountedStorage;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class MountedDepotInteractionBehaviour
extends MovingInteractionBehaviour {
    @Override
    public boolean handlePlayerInteraction(Player player, InteractionHand activeHand, BlockPos localPos, AbstractContraptionEntity contraptionEntity) {
        if (activeHand == InteractionHand.OFF_HAND) {
            return false;
        }
        Level world = player.level();
        if (world.isClientSide()) {
            return true;
        }
        ItemStack itemInHand = player.getItemInHand(activeHand);
        MountedStorageManager manager = contraptionEntity.getContraption().getStorage();
        MountedItemStorage storage = (MountedItemStorage)manager.getAllItemStorages().get((Object)localPos);
        if (!(storage instanceof DepotMountedStorage)) {
            return false;
        }
        DepotMountedStorage depot = (DepotMountedStorage)storage;
        Optional<TransportedItemStack> itemOnDepot = depot.getHeld();
        if (itemOnDepot.isPresent()) {
            ItemStack heldItem = itemOnDepot.get().stack;
            if (ItemStack.isSameItemSameComponents((ItemStack)heldItem, (ItemStack)itemInHand)) {
                int remainder = heldItem.getCount();
                int count = itemInHand.getCount();
                int extract = Math.min(remainder, itemInHand.getMaxStackSize() - count);
                if (extract != 0) {
                    itemInHand.setCount(count + extract);
                    if (extract == remainder) {
                        heldItem = ItemStack.EMPTY;
                    } else {
                        heldItem.setCount(remainder - extract);
                    }
                }
            }
            if (!heldItem.isEmpty()) {
                player.getInventory().placeItemBackInInventory(heldItem);
                world.playSound(null, BlockPos.containing((Position)contraptionEntity.toGlobalVector(Vec3.atCenterOf((Vec3i)localPos), 0.0f)), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, 1.0f + world.getRandom().nextFloat());
                if (itemInHand.isEmpty()) {
                    depot.removeHeldItem();
                    depot.setChanged();
                    return true;
                }
            }
        }
        if (itemInHand.isEmpty()) {
            return true;
        }
        TransportedItemStack transported = new TransportedItemStack(itemInHand);
        transported.insertedFrom = player.getDirection();
        transported.prevBeltPosition = 0.25f;
        transported.beltPosition = 0.25f;
        depot.setHeld(transported);
        depot.setChanged();
        player.setItemInHand(activeHand, ItemStack.EMPTY);
        AllSoundEvents.DEPOT_SLIDE.playOnServer(world, (Vec3i)BlockPos.containing((Position)contraptionEntity.toGlobalVector(Vec3.atCenterOf((Vec3i)localPos), 0.0f)));
        return true;
    }
}

