/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.factoryBoard;

import com.mojang.serialization.MapCodec;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.api.schematic.requirement.SpecialBlockItemRequirement;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelBlockItem;
import com.zurrtum.create.content.logistics.factoryBoard.PanelSlot;
import com.zurrtum.create.content.logistics.factoryBoard.ServerFactoryPanelBehaviour;
import com.zurrtum.create.content.logistics.packagerLink.LogisticallyLinkedBlockItem;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement;
import com.zurrtum.create.foundation.advancement.AdvancementBehaviour;
import com.zurrtum.create.foundation.block.BreakControlBlock;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.block.ProperWaterloggedBlock;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class FactoryPanelBlock
extends FaceAttachedHorizontalDirectionalBlock
implements ProperWaterloggedBlock,
IBE<FactoryPanelBlockEntity>,
IWrenchable,
SpecialBlockItemRequirement,
BreakControlBlock {
    public static final MapCodec<FactoryPanelBlock> CODEC = FactoryPanelBlock.simpleCodec(FactoryPanelBlock::new);
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public FactoryPanelBlock(BlockBehaviour.Properties p_53182_) {
        super(p_53182_);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder.add(new Property[]{FACE, FACING, WATERLOGGED, POWERED}));
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return FactoryPanelBlock.canAttachLenient(pLevel, pPos, FactoryPanelBlock.getConnectedDirection((BlockState)pState).getOpposite());
    }

    public static boolean canAttachLenient(LevelReader pReader, BlockPos pPos, Direction pDirection) {
        BlockPos blockpos = pPos.relative(pDirection);
        return !pReader.getBlockState(blockpos).getCollisionShape((BlockGetter)pReader, blockpos).isEmpty();
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        BlockState stateForPlacement = super.getStateForPlacement(pContext);
        if (stateForPlacement == null) {
            return null;
        }
        if (stateForPlacement.getValue((Property)FACE) == AttachFace.FLOOR) {
            stateForPlacement = (BlockState)stateForPlacement.setValue((Property)FACING, (Comparable)((Direction)stateForPlacement.getValue((Property)FACING)).getOpposite());
        }
        Level level = pContext.getLevel();
        BlockPos pos = pContext.getClickedPos();
        BlockState blockState = level.getBlockState(pos);
        FactoryPanelBlockEntity fpbe = (FactoryPanelBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        Vec3 location = pContext.getClickLocation();
        if (blockState.is((Block)this) && location != null && fpbe != null) {
            if (!level.isClientSide()) {
                PanelSlot targetedSlot = FactoryPanelBlock.getTargetedSlot(pos, blockState, location);
                ItemStack panelItem = FactoryPanelBlockItem.fixCtrlCopiedStack(pContext.getItemInHand());
                UUID networkFromStack = LogisticallyLinkedBlockItem.networkFromStack(panelItem);
                Player pPlayer = pContext.getPlayer();
                if (fpbe.addPanel(targetedSlot, networkFromStack) && pPlayer != null) {
                    pPlayer.displayClientMessage((Component)Component.translatable((String)"create.logistically_linked.connected"), true);
                    if (!pPlayer.isCreative()) {
                        panelItem.shrink(1);
                        if (panelItem.isEmpty()) {
                            pPlayer.setItemInHand(pContext.getHand(), ItemStack.EMPTY);
                        }
                    }
                }
            }
            stateForPlacement = blockState;
        }
        return this.withWater(stateForPlacement, pContext);
    }

    @Override
    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        PanelSlot slot = FactoryPanelBlock.getTargetedSlot(pos, state, context.getClickLocation());
        if (!(world instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        return this.onBlockEntityUse((BlockGetter)world, pos, be -> {
            ServerFactoryPanelBehaviour behaviour = be.panels.get((Object)slot);
            if (behaviour == null || !behaviour.isActive()) {
                return InteractionResult.SUCCESS;
            }
            if (!be.removePanel(slot)) {
                return InteractionResult.SUCCESS;
            }
            if (!player.isCreative()) {
                player.getInventory().placeItemBackInInventory(AllItems.FACTORY_GAUGE.getDefaultInstance());
            }
            IWrenchable.playRemoveSound(world, pos);
            if (be.activePanels() == 0) {
                world.destroyBlock(pos, false);
            }
            return InteractionResult.SUCCESS;
        });
    }

    public void setPlacedBy(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        super.setPlacedBy(pLevel, pPos, pState, pPlacer, pStack);
        if (pPlacer == null) {
            return;
        }
        AdvancementBehaviour.setPlacedBy(pLevel, pPos, pPlacer);
        double range = pPlacer.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE) + 1.0;
        HitResult hitResult = pPlacer.pick(range, 1.0f, false);
        Vec3 location = hitResult.getLocation();
        if (location == null) {
            return;
        }
        PanelSlot initialSlot = FactoryPanelBlock.getTargetedSlot(pPos, pState, location);
        this.withBlockEntityDo((BlockGetter)pLevel, pPos, fpbe -> fpbe.addPanel(initialSlot, LogisticallyLinkedBlockItem.networkFromStack(pStack)));
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (player == null) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        if (!stack.is((Item)AllItems.FACTORY_GAUGE)) {
            return InteractionResult.SUCCESS;
        }
        Vec3 location = hitResult.getLocation();
        if (location == null) {
            return InteractionResult.SUCCESS;
        }
        if (!FactoryPanelBlockItem.isTuned(stack)) {
            AllSoundEvents.DENY.playOnServer(level, (Vec3i)pos);
            player.displayClientMessage((Component)Component.translatable((String)"create.factory_panel.tune_before_placing"), true);
            return InteractionResult.FAIL;
        }
        PanelSlot newSlot = FactoryPanelBlock.getTargetedSlot(pos, state, location);
        this.withBlockEntityDo((BlockGetter)level, pos, fpbe -> {
            if (!fpbe.addPanel(newSlot, LogisticallyLinkedBlockItem.networkFromStack(FactoryPanelBlockItem.fixCtrlCopiedStack(stack)))) {
                return;
            }
            player.displayClientMessage((Component)Component.translatable((String)"create.logistically_linked.connected"), true);
            level.playSound(null, pos, this.soundType.getPlaceSound(), SoundSource.BLOCKS);
            if (player.isCreative()) {
                return;
            }
            stack.shrink(1);
            if (stack.isEmpty()) {
                player.setItemInHand(hand, ItemStack.EMPTY);
            }
        });
        return InteractionResult.SUCCESS;
    }

    @Override
    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player) {
        return !this.tryDestroySubPanelFirst(state, level, pos, player);
    }

    private boolean tryDestroySubPanelFirst(BlockState state, Level level, BlockPos pos, Player player) {
        double range = player.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE) + 1.0;
        HitResult hitResult = player.pick(range, 1.0f, false);
        Vec3 location = hitResult.getLocation();
        PanelSlot destroyedSlot = FactoryPanelBlock.getTargetedSlot(pos, state, location);
        return InteractionResult.SUCCESS == this.onBlockEntityUse((BlockGetter)level, pos, fpbe -> {
            if (fpbe.activePanels() < 2) {
                return InteractionResult.FAIL;
            }
            if (!fpbe.removePanel(destroyedSlot)) {
                return InteractionResult.FAIL;
            }
            if (!player.isCreative()) {
                FactoryPanelBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)AllItems.FACTORY_GAUGE.getDefaultInstance());
            }
            return InteractionResult.SUCCESS;
        });
    }

    public boolean isSignalSource(BlockState pState) {
        return true;
    }

    public int getSignal(BlockState pBlockState, BlockGetter pBlockAccess, BlockPos pPos, Direction pSide) {
        return (Boolean)pBlockState.getValue((Property)POWERED) != false ? 15 : 0;
    }

    public int getDirectSignal(BlockState pBlockState, BlockGetter pBlockAccess, BlockPos pPos, Direction pSide) {
        return (Boolean)pBlockState.getValue((Property)POWERED) != false && FactoryPanelBlock.getConnectedDirection((BlockState)pBlockState) == pSide ? 15 : 0;
    }

    public boolean canBeReplaced(BlockState pState, BlockPlaceContext pUseContext) {
        if (!pUseContext.getItemInHand().is((Item)AllItems.FACTORY_GAUGE)) {
            return false;
        }
        Vec3 location = pUseContext.getClickLocation();
        BlockPos pos = pUseContext.getClickedPos();
        PanelSlot slot = FactoryPanelBlock.getTargetedSlot(pos, pState, location);
        FactoryPanelBlockEntity blockEntity = (FactoryPanelBlockEntity)this.getBlockEntity((BlockGetter)pUseContext.getLevel(), pos);
        if (blockEntity == null) {
            return false;
        }
        return !blockEntity.panels.get((Object)slot).isActive();
    }

    public VoxelShape getCollisionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        EntityCollisionContext ecc;
        if (pContext instanceof EntityCollisionContext && (ecc = (EntityCollisionContext)pContext).getEntity() == null) {
            return this.getShape(pState, pLevel, pPos, pContext);
        }
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        FactoryPanelBlockEntity blockEntity = (FactoryPanelBlockEntity)this.getBlockEntity(pLevel, pPos);
        if (blockEntity != null) {
            return blockEntity.getShape();
        }
        return AllShapes.FACTORY_PANEL_FALLBACK.get(FactoryPanelBlock.getConnectedDirection((BlockState)pState));
    }

    public BlockState updateShape(BlockState pState, LevelReader pLevel, ScheduledTickAccess tickView, BlockPos pCurrentPos, Direction pFacing, BlockPos pFacingPos, BlockState pFacingState, RandomSource random) {
        this.updateWater(pLevel, tickView, pState, pCurrentPos);
        return super.updateShape(pState, pLevel, tickView, pCurrentPos, pFacing, pFacingPos, pFacingState, random);
    }

    public FluidState getFluidState(BlockState pState) {
        return this.fluidState(pState);
    }

    public static Direction connectedDirection(BlockState state) {
        return FactoryPanelBlock.getConnectedDirection((BlockState)state);
    }

    public static PanelSlot getTargetedSlot(BlockPos pos, BlockState blockState, Vec3 clickLocation) {
        double bestDistance = Double.MAX_VALUE;
        PanelSlot bestSlot = PanelSlot.BOTTOM_LEFT;
        Vec3 localClick = clickLocation.subtract(Vec3.atLowerCornerOf((Vec3i)pos));
        float xRot = 57.295776f * FactoryPanelBlock.getXRot(blockState);
        float yRot = 57.295776f * FactoryPanelBlock.getYRot(blockState);
        for (PanelSlot slot : PanelSlot.values()) {
            Vec3 vec = new Vec3(0.25 + (double)slot.xOffset * 0.5, 0.0, 0.25 + (double)slot.yOffset * 0.5);
            vec = VecHelper.rotateCentered(vec, 180.0, Direction.Axis.Y);
            vec = VecHelper.rotateCentered(vec, xRot + 90.0f, Direction.Axis.X);
            double diff = (vec = VecHelper.rotateCentered(vec, yRot, Direction.Axis.Y)).distanceToSqr(localClick);
            if (diff > bestDistance) continue;
            bestDistance = diff;
            bestSlot = slot;
        }
        return bestSlot;
    }

    @Override
    public Class<FactoryPanelBlockEntity> getBlockEntityClass() {
        return FactoryPanelBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends FactoryPanelBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.FACTORY_PANEL;
    }

    public static float getXRot(BlockState state) {
        AttachFace face = (AttachFace)state.getValueOrElse((Property)FACE, (Comparable)AttachFace.FLOOR);
        return face == AttachFace.CEILING ? 1.5707964f : (face == AttachFace.FLOOR ? -1.5707964f : 0.0f);
    }

    public static float getYRot(BlockState state) {
        Direction facing = (Direction)state.getValueOrElse((Property)FACING, (Comparable)Direction.SOUTH);
        AttachFace face = (AttachFace)state.getValueOrElse((Property)FACE, (Comparable)AttachFace.FLOOR);
        return (face == AttachFace.CEILING ? (float)Math.PI : 0.0f) + AngleHelper.rad(AngleHelper.horizontalAngle(facing));
    }

    @Override
    public ItemRequirement getRequiredItems(BlockState state, BlockEntity blockEntity) {
        return ItemRequirement.NONE;
    }

    @NotNull
    protected MapCodec<? extends FaceAttachedHorizontalDirectionalBlock> codec() {
        return CODEC;
    }
}

