/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.factoryBoard;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelBlock;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelPosition;
import com.zurrtum.create.content.logistics.factoryBoard.PanelSlot;
import com.zurrtum.create.content.logistics.factoryBoard.ServerFactoryPanelBehaviour;
import com.zurrtum.create.content.logistics.packager.PackagerBlockEntity;
import com.zurrtum.create.content.logistics.packager.repackager.RepackagerBlockEntity;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.EnumMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FactoryPanelBlockEntity
extends SmartBlockEntity {
    public EnumMap<PanelSlot, ServerFactoryPanelBehaviour> panels;
    public boolean redraw;
    public boolean restocker = false;
    public VoxelShape lastShape;

    public FactoryPanelBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.FACTORY_PANEL, pos, state);
    }

    @Override
    protected AABB createRenderBoundingBox() {
        return new AABB(this.worldPosition).inflate(8.0);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        this.panels = new EnumMap(PanelSlot.class);
        this.redraw = true;
        for (PanelSlot slot : PanelSlot.values()) {
            ServerFactoryPanelBehaviour e = new ServerFactoryPanelBehaviour(this, slot);
            this.panels.put(slot, e);
            behaviours.add(e);
        }
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.FACTORY_GAUGE);
    }

    @Override
    public void lazyTick() {
        BlockState state;
        super.lazyTick();
        if (this.level.isClientSide()) {
            return;
        }
        if (this.activePanels() == 0) {
            this.level.setBlockAndUpdate(this.worldPosition, Blocks.AIR.defaultBlockState());
        }
        if ((state = this.getBlockState()).is((Block)AllBlocks.FACTORY_GAUGE)) {
            boolean shouldBeRestocker = this.level.getBlockState(this.worldPosition.relative(FactoryPanelBlock.connectedDirection(state).getOpposite())).is((Block)AllBlocks.PACKAGER);
            if (this.restocker == shouldBeRestocker) {
                return;
            }
            this.restocker = shouldBeRestocker;
            this.redraw = true;
            this.sendData();
        }
    }

    @Nullable
    public PackagerBlockEntity getRestockedPackager() {
        BlockState state = this.getBlockState();
        if (!this.restocker || !state.is((Block)AllBlocks.FACTORY_GAUGE)) {
            return null;
        }
        BlockPos packagerPos = this.worldPosition.relative(FactoryPanelBlock.connectedDirection(state).getOpposite());
        if (!this.level.isLoaded(packagerPos)) {
            return null;
        }
        BlockEntity be = this.level.getBlockEntity(packagerPos);
        if (!(be instanceof PackagerBlockEntity)) {
            return null;
        }
        PackagerBlockEntity pbe = (PackagerBlockEntity)be;
        if (pbe instanceof RepackagerBlockEntity) {
            return null;
        }
        return pbe;
    }

    public int activePanels() {
        int result = 0;
        for (ServerFactoryPanelBehaviour panelBehaviour : this.panels.values()) {
            if (!panelBehaviour.isActive()) continue;
            ++result;
        }
        return result;
    }

    @Override
    public void remove() {
        for (ServerFactoryPanelBehaviour panelBehaviour : this.panels.values()) {
            if (!panelBehaviour.isActive()) continue;
            panelBehaviour.disconnectAll();
        }
        super.remove();
    }

    @Override
    public void destroy() {
        super.destroy();
        int panelCount = this.activePanels();
        if (panelCount > 1) {
            Block.popResource((Level)this.level, (BlockPos)this.worldPosition, (ItemStack)new ItemStack((ItemLike)AllItems.FACTORY_GAUGE, panelCount - 1));
        }
    }

    public boolean addPanel(PanelSlot slot, UUID frequency) {
        ServerFactoryPanelBehaviour behaviour = this.panels.get((Object)slot);
        if (behaviour != null && !behaviour.isActive()) {
            behaviour.enable();
            if (frequency != null) {
                behaviour.setNetwork(frequency);
            }
            this.redraw = true;
            this.lastShape = null;
            if (this.activePanels() > 1) {
                SoundType soundType = this.getBlockState().getSoundType();
                this.level.playSound(null, this.worldPosition, soundType.getPlaceSound(), SoundSource.BLOCKS, (soundType.getVolume() + 1.0f) / 2.0f, soundType.getPitch() * 0.8f);
            }
            return true;
        }
        return false;
    }

    public boolean removePanel(PanelSlot slot) {
        ServerFactoryPanelBehaviour behaviour = this.panels.get((Object)slot);
        if (behaviour != null && behaviour.isActive()) {
            behaviour.disable();
            this.redraw = true;
            this.lastShape = null;
            if (this.activePanels() > 0) {
                SoundType soundType = this.getBlockState().getSoundType();
                this.level.playSound(null, this.worldPosition, soundType.getBreakSound(), SoundSource.BLOCKS, (soundType.getVolume() + 1.0f) / 2.0f, soundType.getPitch() * 0.8f);
            }
            return true;
        }
        return false;
    }

    public VoxelShape getShape() {
        if (this.lastShape != null) {
            return this.lastShape;
        }
        float xRot = 57.295776f * FactoryPanelBlock.getXRot(this.getBlockState()) + 90.0f;
        float yRot = 57.295776f * FactoryPanelBlock.getYRot(this.getBlockState());
        Direction connectedDirection = FactoryPanelBlock.connectedDirection(this.getBlockState());
        Vec3 inflateAxes = VecHelper.axisAlingedPlaneOf(connectedDirection);
        this.lastShape = Shapes.empty();
        for (ServerFactoryPanelBehaviour behaviour : this.panels.values()) {
            if (!behaviour.isActive()) continue;
            FactoryPanelPosition panelPosition = behaviour.getPanelPosition();
            Vec3 vec = new Vec3(0.25 + (double)panelPosition.slot().xOffset * 0.5, 0.0625, 0.25 + (double)panelPosition.slot().yOffset * 0.5);
            vec = VecHelper.rotateCentered(vec, 180.0, Direction.Axis.Y);
            vec = VecHelper.rotateCentered(vec, xRot, Direction.Axis.X);
            vec = VecHelper.rotateCentered(vec, yRot, Direction.Axis.Y);
            AABB bb = new AABB(vec, vec).inflate(0.0625).inflate(inflateAxes.x * 3.0 / 16.0, inflateAxes.y * 3.0 / 16.0, inflateAxes.z * 3.0 / 16.0);
            this.lastShape = Shapes.or((VoxelShape)this.lastShape, (VoxelShape)Shapes.create((AABB)bb));
        }
        return this.lastShape;
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        super.read(view, clientPacket);
        this.restocker = view.getBooleanOr("Restocker", false);
        if (clientPacket && view.getBooleanOr("Redraw", false)) {
            this.lastShape = null;
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 16);
        }
    }

    @Override
    protected void write(ValueOutput view, boolean clientPacket) {
        super.write(view, clientPacket);
        view.putBoolean("Restocker", this.restocker);
        if (clientPacket && this.redraw) {
            view.putBoolean("Redraw", true);
            this.redraw = false;
        }
    }
}

