/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.factoryBoard;

import com.mojang.serialization.Codec;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelPosition;
import com.zurrtum.create.content.logistics.factoryBoard.ServerFactoryPanelBehaviour;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.Nullable;

public class FactoryPanelSupportBehaviour
extends BlockEntityBehaviour<SmartBlockEntity> {
    private static final Codec<List<FactoryPanelPosition>> LINKED_CODEC = Codec.list(FactoryPanelPosition.CODEC);
    public static final BehaviourType<FactoryPanelSupportBehaviour> TYPE = new BehaviourType();
    private List<FactoryPanelPosition> linkedPanels;
    private boolean changed;
    private Supplier<Boolean> outputPower;
    private Supplier<Boolean> isOutput;
    private Runnable onNotify;

    public FactoryPanelSupportBehaviour(SmartBlockEntity be, Supplier<Boolean> isOutput, Supplier<Boolean> outputPower, Runnable onNotify) {
        super(be);
        this.isOutput = isOutput;
        this.outputPower = outputPower;
        this.onNotify = onNotify;
        this.linkedPanels = new ArrayList<FactoryPanelPosition>();
    }

    public boolean shouldPanelBePowered() {
        return this.isOutput() && this.outputPower.get() != false;
    }

    public boolean isOutput() {
        return this.isOutput.get();
    }

    public void notifyLink() {
        this.onNotify.run();
    }

    @Override
    public void destroy() {
        for (FactoryPanelPosition panelPos : this.linkedPanels) {
            if (!this.getLevel().isLoaded(panelPos.pos())) continue;
            ServerFactoryPanelBehaviour behaviour = ServerFactoryPanelBehaviour.at((BlockAndTintGetter)this.getLevel(), panelPos);
            behaviour.targetedByLinks.remove(this.getPos());
            behaviour.blockEntity.notifyUpdate();
        }
        super.destroy();
    }

    public void notifyPanels() {
        if (this.getLevel().isClientSide()) {
            return;
        }
        Iterator<FactoryPanelPosition> iterator = this.linkedPanels.iterator();
        while (iterator.hasNext()) {
            FactoryPanelPosition panelPos = iterator.next();
            if (!this.getLevel().isLoaded(panelPos.pos())) continue;
            ServerFactoryPanelBehaviour behaviour = ServerFactoryPanelBehaviour.at((BlockAndTintGetter)this.getLevel(), panelPos);
            if (behaviour == null) {
                iterator.remove();
                this.changed = true;
                continue;
            }
            behaviour.checkForRedstoneInput();
        }
    }

    @Nullable
    public Boolean shouldBePoweredTristate() {
        Iterator<FactoryPanelPosition> iterator = this.linkedPanels.iterator();
        while (iterator.hasNext()) {
            FactoryPanelPosition panelPos = iterator.next();
            if (!this.getLevel().isLoaded(panelPos.pos())) {
                return null;
            }
            ServerFactoryPanelBehaviour behaviour = ServerFactoryPanelBehaviour.at((BlockAndTintGetter)this.getLevel(), panelPos);
            if (behaviour == null) {
                iterator.remove();
                this.changed = true;
                continue;
            }
            if (!behaviour.isActive() || !behaviour.satisfied || behaviour.count == 0) continue;
            return true;
        }
        return false;
    }

    public List<FactoryPanelPosition> getLinkedPanels() {
        return this.linkedPanels;
    }

    public void connect(ServerFactoryPanelBehaviour panel) {
        FactoryPanelPosition panelPosition = panel.getPanelPosition();
        if (this.linkedPanels.contains(panelPosition)) {
            return;
        }
        this.linkedPanels.add(panelPosition);
        this.changed = true;
    }

    public void disconnect(ServerFactoryPanelBehaviour panel) {
        this.linkedPanels.remove(panel.getPanelPosition());
        this.changed = true;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.changed) {
            this.changed = false;
            if (!this.isOutput()) {
                this.notifyLink();
            }
            this.blockEntity.setChanged();
        }
    }

    @Override
    public void write(ValueOutput view, boolean clientPacket) {
        view.store("LinkedGauges", LINKED_CODEC, this.linkedPanels);
    }

    @Override
    public void read(ValueInput view, boolean clientPacket) {
        this.linkedPanels.clear();
        view.read("LinkedGauges", LINKED_CODEC).ifPresent(this.linkedPanels::addAll);
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }
}

